/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items;

import java.util.List;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.IThaumcraftItems;

public class ItemTCBase
extends Item
implements IThaumcraftItems {
    protected final String BASE_NAME;
    protected String[] VARIANTS;
    protected int[] VARIANTS_META;

    public ItemTCBase(String name, String ... variants) {
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(ConfigItems.TABTC);
        this.setNoRepair();
        this.func_77627_a(variants.length > 1);
        this.BASE_NAME = name;
        this.VARIANTS = variants.length == 0 ? new String[]{name} : variants;
        this.VARIANTS_META = new int[this.VARIANTS.length];
        for (int m = 0; m < this.VARIANTS.length; ++m) {
            this.VARIANTS_META[m] = m;
        }
        ConfigItems.ITEM_VARIANT_HOLDERS.add(this);
    }

    public String func_77667_c(ItemStack itemStack) {
        if (this.field_77787_bX && itemStack.func_77960_j() < this.VARIANTS.length && this.VARIANTS[itemStack.func_77960_j()] != this.BASE_NAME) {
            return String.format(super.func_77658_a() + ".%s", this.VARIANTS[itemStack.func_77960_j()]);
        }
        return super.func_77667_c(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List<ItemStack> list) {
        if (!this.func_77614_k()) {
            super.func_150895_a(item, creativeTab, list);
        } else {
            for (int meta = 0; meta < this.VARIANTS.length; ++meta) {
                list.add(new ItemStack((Item)this, 1, meta));
            }
        }
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public String[] getVariantNames() {
        return this.VARIANTS;
    }

    @Override
    public int[] getVariantMeta() {
        return this.VARIANTS_META;
    }

    @Override
    public ItemMeshDefinition getCustomMesh() {
        return null;
    }

    @Override
    public ModelResourceLocation getCustomModelResourceLocation(String variant) {
        if (variant.equals(this.BASE_NAME)) {
            return new ModelResourceLocation("thaumcraft:" + this.BASE_NAME);
        }
        return new ModelResourceLocation("thaumcraft:" + this.BASE_NAME, variant);
    }
}

