/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters;

import java.awt.Color;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.casters.FocusMediumRoot;
import thaumcraft.api.casters.FocusModSplit;
import thaumcraft.api.casters.FocusNode;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.IFocusElement;
import thaumcraft.api.casters.NodeSetting;
import thaumcraft.common.items.ItemTCBase;

public class ItemFocus
extends ItemTCBase {
    private int maxComplexity;

    public ItemFocus(String name, int complexity) {
        super(name, new String[0]);
        this.field_77777_bU = 1;
        this.func_77656_e(0);
        this.maxComplexity = complexity;
    }

    public int getFocusColor(ItemStack focusstack) {
        if (focusstack == null || focusstack.func_77978_p() == null) {
            return 0xFFFFFF;
        }
        int color = 0xFFFFFF;
        if (!focusstack.func_77978_p().func_74764_b("color")) {
            FocusPackage core = ItemFocus.getPackage(focusstack);
            if (core != null) {
                FocusEffect[] fe = core.getFocusEffects();
                int r = 0;
                int g = 0;
                int b = 0;
                for (FocusEffect ef : fe) {
                    Color c = new Color(FocusEngine.getElementColor(ef.getKey()));
                    r += c.getRed();
                    g += c.getGreen();
                    b += c.getBlue();
                }
                Color c = new Color(r /= fe.length, g /= fe.length, b /= fe.length);
                color = c.getRGB();
                focusstack.func_77983_a("color", (NBTBase)new NBTTagInt(color));
            }
        } else {
            color = focusstack.func_77978_p().func_74762_e("color");
        }
        return color;
    }

    public String getSortingHelper(ItemStack focusstack) {
        if (focusstack == null || !focusstack.func_77942_o()) {
            return null;
        }
        int sh = focusstack.func_77978_p().func_74762_e("sort");
        if (sh == 0) {
            sh = ItemFocus.getPackage(focusstack).getSortingHelper();
            focusstack.func_77983_a("sort", (NBTBase)new NBTTagInt(sh));
        }
        return focusstack.func_82833_r() + sh;
    }

    public static void setPackage(ItemStack focusstack, FocusPackage core) {
        NBTTagCompound tag = core.serialize();
        focusstack.func_77983_a("package", (NBTBase)tag);
    }

    public static FocusPackage getPackage(ItemStack focusstack) {
        NBTTagCompound tag = focusstack.func_179543_a("package", false);
        if (tag != null) {
            FocusPackage p = new FocusPackage();
            p.deserialize(tag);
            return p;
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        this.addFocusInformation(stack, player, list, par4);
    }

    public void addFocusInformation(ItemStack focusstack, EntityPlayer player, List list, boolean par4) {
        FocusPackage p = ItemFocus.getPackage(focusstack);
        if (p != null) {
            float al = this.getVisCost(focusstack);
            String amount = ItemStack.field_111284_a.format(al);
            list.add(amount + " " + I18n.func_74838_a((String)"item.Focus.cost1"));
            for (IFocusElement fe : p.nodes) {
                if (!(fe instanceof FocusNode) || fe instanceof FocusMediumRoot) continue;
                this.buildInfo(list, (FocusNode)fe, 0);
            }
        }
    }

    private void buildInfo(List list, FocusNode node, int depth) {
        if (node instanceof FocusNode && !(node instanceof FocusMediumRoot)) {
            String t0 = "";
            for (int a = 0; a < depth; ++a) {
                t0 = t0 + "  ";
            }
            t0 = t0 + TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)node.getUnlocalizedName());
            if (!node.getSettingList().isEmpty()) {
                t0 = t0 + TextFormatting.DARK_AQUA + " [";
                boolean q = false;
                for (String st : node.getSettingList()) {
                    NodeSetting ns = node.getSetting(st);
                    t0 = t0 + (q ? ", " : "") + ns.getLocalizedName() + " " + ns.getValueText();
                    q = true;
                }
                t0 = t0 + "]";
            }
            list.add(t0);
            if (node instanceof FocusModSplit) {
                FocusModSplit split = (FocusModSplit)node;
                for (FocusPackage p : split.getSplitPackages()) {
                    for (IFocusElement fe : p.nodes) {
                        if (!(fe instanceof FocusNode) || fe instanceof FocusMediumRoot) continue;
                        this.buildInfo(list, (FocusNode)fe, depth + 1);
                    }
                }
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack focusstack) {
        return EnumRarity.RARE;
    }

    public float getVisCost(ItemStack focusstack) {
        FocusPackage p = ItemFocus.getPackage(focusstack);
        return p == null ? 0.0f : (float)p.getComplexity() / 5.0f;
    }

    public int getActivationTime(ItemStack focusstack) {
        FocusPackage p = ItemFocus.getPackage(focusstack);
        return p == null ? 0 : Math.max(5, p.getComplexity() / 4 * (p.getComplexity() / 4));
    }

    public int getMaxComplexity() {
        return this.maxComplexity;
    }
}

