/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.crafting;

import baubles.api.IBauble;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.lib.events.PlayerEvents;

public class InfusionRunicAugmentRecipe
extends InfusionRecipe {
    private ItemStack[] components;

    public InfusionRunicAugmentRecipe() {
        super("RUNICSHIELDING", null, 0, null, null, new ItemStack[]{new ItemStack(ItemsTC.amber), new ItemStack(ItemsTC.salisMundus)});
    }

    public InfusionRunicAugmentRecipe(ItemStack in) {
        super("RUNICSHIELDING", null, 0, null, in, new ItemStack[]{new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.amber)});
        this.components = new ItemStack[]{new ItemStack(ItemsTC.salisMundus), new ItemStack(ItemsTC.amber)};
        int fc = PlayerEvents.getRunicCharge(in);
        if (fc > 0) {
            ArrayList<ItemStack> com = new ArrayList<ItemStack>();
            com.add(new ItemStack(ItemsTC.salisMundus));
            com.add(new ItemStack(ItemsTC.amber));
            for (int c = 0; c < fc; ++c) {
                com.add(new ItemStack(ItemsTC.amber));
            }
            this.components = com.toArray(this.components);
        }
    }

    @Override
    public boolean matches(ArrayList<ItemStack> input, ItemStack central, World world, EntityPlayer player) {
        if (!ThaumcraftCapabilities.knowsResearch(player, this.research)) {
            return false;
        }
        if (!(central.func_77973_b() instanceof ItemArmor) && !(central.func_77973_b() instanceof IBauble)) {
            return false;
        }
        ItemStack i2 = null;
        ArrayList<ItemStack> ii = new ArrayList<ItemStack>();
        for (ItemStack is : input) {
            ii.add(is.func_77946_l());
        }
        for (ItemStack comp : this.getComponents(central)) {
            boolean b = false;
            for (int a = 0; a < ii.size(); ++a) {
                i2 = ((ItemStack)ii.get(a)).func_77946_l();
                if (!ThaumcraftApiHelper.areItemStacksEqualForCrafting(i2, comp)) continue;
                ii.remove(a);
                b = true;
                break;
            }
            if (b) continue;
            return false;
        }
        return ii.size() == 0;
    }

    @Override
    public Object getRecipeOutput(EntityPlayer player, ItemStack input, ArrayList<ItemStack> comps) {
        if (input == null) {
            return null;
        }
        ItemStack out = input.func_77946_l();
        int base = PlayerEvents.getRunicCharge(input) + 1;
        out.func_77983_a("TC.RUNIC", (NBTBase)new NBTTagByte((byte)base));
        return out;
    }

    @Override
    public AspectList getAspects(EntityPlayer player, ItemStack input, ArrayList<ItemStack> comps) {
        AspectList out = new AspectList();
        int vis = 20 + (int)(20.0 * Math.pow(2.0, PlayerEvents.getRunicCharge(input)));
        if (vis > 0) {
            out.add(Aspect.PROTECT, vis);
            out.add(Aspect.CRYSTAL, vis / 2);
            out.add(Aspect.ENERGY, vis / 2);
        }
        return out;
    }

    @Override
    public int getInstability(EntityPlayer player, ItemStack input, ArrayList<ItemStack> comps) {
        int i = 5 + PlayerEvents.getRunicCharge(input) / 2;
        return i;
    }

    public ItemStack[] getComponents(ItemStack input) {
        ArrayList<ItemStack> com = new ArrayList<ItemStack>();
        com.add(new ItemStack(ItemsTC.salisMundus));
        com.add(new ItemStack(ItemsTC.amber));
        int fc = PlayerEvents.getRunicCharge(input);
        if (fc > 0) {
            for (int c = 0; c < fc; ++c) {
                com.add(new ItemStack(ItemsTC.amber));
            }
        }
        return com.toArray(new ItemStack[0]);
    }

    public ItemStack[] getComponents() {
        return this.components;
    }
}

