/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import com.google.common.base.Predicate;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.EntitySpecialItem;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;
import thaumcraft.common.lib.events.TaintEvents;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockBamf;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.devices.TileArcaneEar;
import thaumcraft.common.world.ThaumcraftWorldGenerator;
import thaumcraft.common.world.aura.AuraHandler;
import thaumcraft.common.world.aura.AuraThread;

@Mod.EventBusSubscriber
public class ServerEvents {
    long lastcheck = 0L;
    static HashMap<Integer, Integer> serverTicks = new HashMap();
    public static ConcurrentHashMap<Integer, AuraThread> auraThreads = new ConcurrentHashMap();
    DecimalFormat myFormatter = new DecimalFormat("#######.##");
    public static HashMap<Integer, LinkedBlockingQueue<BreakData>> breakList = new HashMap();
    public static HashMap<Integer, LinkedBlockingQueue<VirtualSwapper>> swapList = new HashMap();
    public static HashMap<Integer, ArrayList<ChunkPos>> chunksToGenerate = new HashMap();
    public static final Predicate<SwapperPredicate> DEFAULT_PREDICATE = new Predicate<SwapperPredicate>(){

        public boolean apply(@Nullable SwapperPredicate pred) {
            return true;
        }
    };
    private static HashMap<Integer, LinkedBlockingQueue<RunnableEntry>> serverRunList = new HashMap();
    private static LinkedBlockingQueue<RunnableEntry> clientRunList = new LinkedBlockingQueue();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void clientWorldTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.SERVER) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && !clientRunList.isEmpty()) {
            LinkedBlockingQueue<RunnableEntry> temp = new LinkedBlockingQueue<RunnableEntry>();
            while (!clientRunList.isEmpty()) {
                RunnableEntry current = clientRunList.poll();
                if (current == null) continue;
                if (current.delay > 0) {
                    --current.delay;
                    temp.offer(current);
                    continue;
                }
                try {
                    current.runnable.run();
                }
                catch (Exception exception) {}
            }
            while (!temp.isEmpty()) {
                clientRunList.offer((RunnableEntry)temp.poll());
            }
        }
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        int dim = event.world.field_73011_w.getDimension();
        if (event.phase == TickEvent.Phase.START) {
            if (!auraThreads.containsKey(dim) && AuraHandler.getAuraWorld(dim) != null) {
                AuraThread at = new AuraThread(dim);
                Thread thread = new Thread(at);
                thread.start();
                auraThreads.put(dim, at);
            }
        } else {
            LinkedBlockingQueue<RunnableEntry> rlist;
            if (!serverTicks.containsKey(dim)) {
                serverTicks.put(dim, 0);
            }
            if ((rlist = serverRunList.get(dim)) == null) {
                rlist = new LinkedBlockingQueue();
                serverRunList.put(dim, rlist);
            } else if (!rlist.isEmpty()) {
                LinkedBlockingQueue<RunnableEntry> temp = new LinkedBlockingQueue<RunnableEntry>();
                while (!rlist.isEmpty()) {
                    RunnableEntry current = rlist.poll();
                    if (current == null) continue;
                    if (current.delay > 0) {
                        --current.delay;
                        temp.offer(current);
                        continue;
                    }
                    try {
                        current.runnable.run();
                    }
                    catch (Exception exception) {}
                }
                while (!temp.isEmpty()) {
                    rlist.offer((RunnableEntry)temp.poll());
                }
            }
            int ticks = serverTicks.get(dim);
            ServerEvents.tickChunkRegeneration(event);
            ServerEvents.tickBlockSwap(event.world);
            ServerEvents.tickBlockBreak(event.world);
            ArrayList<Integer[]> nbe = TileArcaneEar.noteBlockEvents.get(dim);
            if (nbe != null) {
                nbe.clear();
            }
            if (ticks % 20 == 0) {
                CopyOnWriteArrayList<ChunkPos> dc = AuraHandler.dirtyChunks.get(dim);
                if (dc != null && dc.size() > 0) {
                    for (ChunkPos pos : dc) {
                        event.world.func_175646_b(pos.func_180619_a(5), null);
                    }
                    dc.clear();
                }
                if (AuraHandler.taintTrigger.containsKey(dim)) {
                    if (!Config.wuss) {
                        TaintEvents.taintEvent(event.world, AuraHandler.taintTrigger.get(dim));
                    }
                    AuraHandler.taintTrigger.remove(dim);
                }
                TaskHandler.clearSuspendedOrExpiredTasks(event.world);
            }
            SealHandler.tickSealEntities(event.world);
            serverTicks.put(dim, ticks + 1);
        }
    }

    public static void tickChunkRegeneration(TickEvent.WorldTickEvent event) {
        int dim = event.world.field_73011_w.getDimension();
        int count = 0;
        ArrayList<ChunkPos> chunks = chunksToGenerate.get(dim);
        if (chunks != null && chunks.size() > 0) {
            for (int a = 0; a < 10 && (chunks = chunksToGenerate.get(dim)) != null && chunks.size() > 0; ++a) {
                ++count;
                ChunkPos loc = chunks.get(0);
                long worldSeed = event.world.func_72905_C();
                Random fmlRandom = new Random(worldSeed);
                long xSeed = fmlRandom.nextLong() >> 3;
                long zSeed = fmlRandom.nextLong() >> 3;
                fmlRandom.setSeed(xSeed * (long)loc.field_77276_a + zSeed * (long)loc.field_77275_b ^ worldSeed);
                ThaumcraftWorldGenerator.INSTANCE.worldGeneration(fmlRandom, loc.field_77276_a, loc.field_77275_b, event.world, false);
                chunks.remove(0);
                chunksToGenerate.put(dim, chunks);
            }
        }
        if (count > 0) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.INFO, "[Thaumcraft] Regenerated " + count + " chunks. " + Math.max(0, chunks.size()) + " chunks left");
        }
    }

    private static void tickBlockSwap(World world) {
        int dim = world.field_73011_w.getDimension();
        LinkedBlockingQueue<VirtualSwapper> queue = swapList.get(dim);
        LinkedBlockingQueue<VirtualSwapper> queue2 = new LinkedBlockingQueue<VirtualSwapper>();
        if (queue != null) {
            while (!queue.isEmpty()) {
                boolean allow;
                VirtualSwapper vs = queue.poll();
                if (vs == null) continue;
                IBlockState bs = world.func_180495_p(vs.pos);
                boolean bl = allow = bs.func_185887_b(world, vs.pos) >= 0.0f;
                if (vs.source != null && vs.source instanceof IBlockState && (IBlockState)vs.source != bs || vs.source != null && vs.source instanceof Material && (Material)vs.source != bs.func_185904_a()) {
                    allow = false;
                }
                if (vs.visCost > 0.0f && AuraHelper.getVis(world, vs.pos) < vs.visCost) {
                    allow = false;
                }
                if (!world.canMineBlockBody(vs.player, vs.pos) || !allow || vs.target != null && vs.target.func_77969_a(new ItemStack(bs.func_177230_c(), 1, bs.func_177230_c().func_176201_c(bs))) || ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)vs.player, (BlockSnapshot)new BlockSnapshot(world, vs.pos, bs), (EnumFacing)EnumFacing.UP).isCanceled() || !vs.allowSwap.apply((Object)new SwapperPredicate(world, vs.player, vs.pos))) continue;
                int slot = -1;
                slot = !vs.consumeTarget || vs.target == null ? 1 : InventoryUtils.isPlayerCarrying(vs.player, vs.target);
                if (vs.player.field_71075_bZ.field_75098_d) {
                    slot = 1;
                }
                boolean matches = false;
                if (vs.source instanceof Material) {
                    boolean bl2 = matches = bs.func_185904_a() == (Material)vs.source;
                }
                if (vs.source instanceof IBlockState) {
                    boolean bl3 = matches = bs == (IBlockState)vs.source;
                }
                if (vs.source != null && !matches || slot < 0) continue;
                if (!vs.player.field_71075_bZ.field_75098_d) {
                    if (vs.consumeTarget) {
                        vs.player.field_71071_by.func_70298_a(slot, 1);
                    }
                    if (vs.pickup) {
                        List<Object> ret = new ArrayList();
                        if (vs.silk && bs.func_177230_c().canSilkHarvest(world, vs.pos, bs, vs.player)) {
                            ItemStack itemstack = BlockUtils.getSilkTouchDrop(bs);
                            if (itemstack != null) {
                                ret.add(itemstack);
                            }
                        } else {
                            ret = bs.func_177230_c().getDrops((IBlockAccess)world, vs.pos, bs, vs.fortune);
                        }
                        if (ret.size() > 0) {
                            for (ItemStack itemStack : ret) {
                                if (vs.player.field_71071_by.func_70441_a(itemStack)) continue;
                                world.func_72838_d((Entity)new EntityItem(world, (double)vs.pos.func_177958_n() + 0.5, (double)vs.pos.func_177956_o() + 0.5, (double)vs.pos.func_177952_p() + 0.5, itemStack));
                            }
                        }
                    }
                    if (vs.visCost > 0.0f) {
                        ThaumcraftApi.internalMethods.drainVis(world, vs.pos, vs.visCost, false);
                    }
                }
                if (vs.target == null) {
                    world.func_175698_g(vs.pos);
                } else {
                    Block tb = Block.func_149634_a((Item)vs.target.func_77973_b());
                    if (tb != null) {
                        world.func_180501_a(vs.pos, tb.func_176203_a(vs.target.func_77952_i()), 3);
                    } else {
                        world.func_175698_g(vs.pos);
                        EntitySpecialItem entityItem = new EntitySpecialItem(world, (double)vs.pos.func_177958_n() + 0.5, (double)vs.pos.func_177956_o() + 0.1, (double)vs.pos.func_177952_p() + 0.5, vs.target.func_77946_l());
                        entityItem.field_70181_x = 0.0;
                        entityItem.field_70159_w = 0.0;
                        entityItem.field_70179_y = 0.0;
                        world.func_72838_d((Entity)entityItem);
                    }
                }
                if (vs.fx) {
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockBamf(vs.pos, vs.color, true, vs.fancy, null), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)vs.pos.func_177958_n(), (double)vs.pos.func_177956_o(), (double)vs.pos.func_177952_p(), 32.0));
                }
                if (vs.lifespan <= 0) continue;
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int yy = -1; yy <= 1; ++yy) {
                        for (int i = -1; i <= 1; ++i) {
                            matches = false;
                            if (vs.source instanceof Material) {
                                IBlockState bb = world.func_180495_p(vs.pos.func_177982_a(xx, yy, i));
                                boolean bl4 = matches = bb.func_177230_c().func_149688_o(bb) == vs.source;
                            }
                            if (vs.source instanceof IBlockState) {
                                boolean bl5 = matches = world.func_180495_p(vs.pos.func_177982_a(xx, yy, i)) == vs.source;
                            }
                            if (xx == 0 && yy == 0 && i == 0 || !matches || !BlockUtils.isBlockExposed(world, vs.pos.func_177982_a(xx, yy, i))) continue;
                            queue2.offer(new VirtualSwapper(vs.pos.func_177982_a(xx, yy, i), vs.source, vs.target, vs.consumeTarget, vs.lifespan - 1, vs.player, vs.fx, vs.fancy, vs.color, vs.pickup, vs.silk, vs.fortune, vs.allowSwap, vs.visCost));
                        }
                    }
                }
            }
            swapList.put(dim, queue2);
        }
    }

    private static void tickBlockBreak(World world) {
        int dim = world.field_73011_w.getDimension();
        LinkedBlockingQueue<BreakData> queue = breakList.get(dim);
        LinkedBlockingQueue<BreakData> queue2 = new LinkedBlockingQueue<BreakData>();
        if (queue != null) {
            while (!queue.isEmpty()) {
                BreakData vs = queue.poll();
                if (vs == null) continue;
                IBlockState bs = world.func_180495_p(vs.pos);
                if (bs == vs.source) {
                    if (vs.visCost > 0.0f && AuraHelper.getVis(world, vs.pos) < vs.visCost || !world.canMineBlockBody(vs.player, vs.pos) || !(bs.func_185887_b(world, vs.pos) >= 0.0f)) continue;
                    if (vs.fx) {
                        world.func_175715_c(vs.pos.hashCode(), vs.pos, (int)((1.0f - vs.durabilityCurrent / vs.durabilityMax) * 10.0f));
                    }
                    vs.durabilityCurrent -= vs.strength;
                    if (vs.durabilityCurrent <= 0.0f) {
                        BlockUtils.harvestBlock(world, vs.player, vs.pos, true, vs.silk, vs.fortune, false);
                        if (vs.fx) {
                            world.func_175715_c(vs.pos.hashCode(), vs.pos, -1);
                        }
                        if (!(vs.visCost > 0.0f)) continue;
                        ThaumcraftApi.internalMethods.drainVis(world, vs.pos, vs.visCost, false);
                        continue;
                    }
                    queue2.offer(new BreakData(vs.strength, vs.durabilityCurrent, vs.durabilityMax, vs.pos, vs.source, vs.player, vs.fx, vs.silk, vs.fortune, vs.visCost));
                    continue;
                }
                if (!vs.fx) continue;
                world.func_175715_c(vs.pos.hashCode(), vs.pos, -1);
            }
            breakList.put(dim, queue2);
        }
    }

    public static void addSwapper(World world, BlockPos pos, Object source, ItemStack target, boolean consumeTarget, int life, EntityPlayer player, boolean fx, boolean fancy, int color, boolean pickup, boolean silk, int fortune, Predicate<SwapperPredicate> allowSwap, float visCost) {
        int dim = world.field_73011_w.getDimension();
        LinkedBlockingQueue<VirtualSwapper> queue = swapList.get(dim);
        if (queue == null) {
            swapList.put(dim, new LinkedBlockingQueue());
            queue = swapList.get(dim);
        }
        queue.offer(new VirtualSwapper(pos, source, target, consumeTarget, life, player, fx, fancy, color, pickup, silk, fortune, allowSwap, visCost));
        swapList.put(dim, queue);
    }

    public static void addBreaker(final World world, final BlockPos pos, final IBlockState source, final EntityPlayer player, final boolean fx, final boolean silk, final int fortune, final float str, final float durabilityCurrent, final float durabilityMax, int delay, final float vis, final Runnable run) {
        int dim = world.field_73011_w.getDimension();
        if (delay > 0) {
            ServerEvents.addRunnableServer(world, new Runnable(){

                @Override
                public void run() {
                    ServerEvents.addBreaker(world, pos, source, player, fx, silk, fortune, str, durabilityCurrent, durabilityMax, 0, vis, run);
                }
            }, delay);
        } else {
            LinkedBlockingQueue<BreakData> queue = breakList.get(dim);
            if (queue == null) {
                breakList.put(dim, new LinkedBlockingQueue());
                queue = breakList.get(dim);
            }
            queue.offer(new BreakData(str, durabilityCurrent, durabilityMax, pos, source, player, fx, silk, fortune, vis));
            breakList.put(dim, queue);
            if (run != null) {
                run.run();
            }
        }
    }

    public static void addRunnableServer(World world, Runnable runnable, int delay) {
        if (world.field_72995_K) {
            return;
        }
        LinkedBlockingQueue<RunnableEntry> rlist = serverRunList.get(world.field_73011_w.getDimension());
        if (rlist == null) {
            rlist = new LinkedBlockingQueue();
            serverRunList.put(world.field_73011_w.getDimension(), rlist);
        }
        rlist.add(new RunnableEntry(runnable, delay));
    }

    public static void addRunnableClient(World world, Runnable runnable, int delay) {
        if (!world.field_72995_K) {
            return;
        }
        clientRunList.add(new RunnableEntry(runnable, delay));
    }

    public static class RunnableEntry {
        Runnable runnable;
        int delay;

        public RunnableEntry(Runnable runnable, int delay) {
            this.runnable = runnable;
            this.delay = delay;
        }
    }

    public static class VirtualSwapper {
        int color;
        boolean fancy;
        Predicate<SwapperPredicate> allowSwap;
        int lifespan = 0;
        BlockPos pos;
        Object source;
        ItemStack target;
        EntityPlayer player = null;
        boolean fx;
        boolean silk;
        boolean pickup;
        boolean consumeTarget;
        int fortune;
        float visCost;

        VirtualSwapper(BlockPos pos, Object source, ItemStack t, boolean consumeTarget, int life, EntityPlayer p, boolean fx, boolean fancy, int color, boolean pickup, boolean silk, int fortune, Predicate<SwapperPredicate> allowSwap, float cost) {
            this.pos = pos;
            this.source = source;
            this.target = t;
            this.lifespan = life;
            this.player = p;
            this.consumeTarget = consumeTarget;
            this.fx = fx;
            this.fancy = fancy;
            this.allowSwap = allowSwap;
            this.silk = silk;
            this.fortune = fortune;
            this.pickup = pickup;
            this.color = color;
            this.visCost = cost;
        }
    }

    public static class SwapperPredicate {
        public World world;
        public EntityPlayer player;
        public BlockPos pos;

        public SwapperPredicate(World world, EntityPlayer player, BlockPos pos) {
            this.world = world;
            this.player = player;
            this.pos = pos;
        }
    }

    public static class BreakData {
        float strength = 0.0f;
        float durabilityCurrent = 1.0f;
        float durabilityMax = 1.0f;
        IBlockState source;
        BlockPos pos;
        EntityPlayer player = null;
        boolean fx;
        boolean silk;
        int fortune;
        float visCost;

        public BreakData(float strength, float durabilityCurrent, float durabilityMax, BlockPos pos, IBlockState source, EntityPlayer player, boolean fx, boolean silk, int fortune, float vis) {
            this.strength = strength;
            this.source = source;
            this.pos = pos;
            this.player = player;
            this.fx = fx;
            this.silk = silk;
            this.fortune = fortune;
            this.durabilityCurrent = durabilityCurrent;
            this.durabilityMax = durabilityMax;
            this.visCost = vis;
        }
    }
}

