/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.research;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.IScanThing;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.lib.utils.Utils;

public class ScanSky
implements IScanThing {
    @Override
    public boolean checkThing(EntityPlayer player, Object obj) {
        if (obj != null || player.field_70125_A > 0.0f || !player.field_70170_p.func_175678_i(player.func_180425_c().func_177984_a()) || !ThaumcraftCapabilities.knowsResearchStrict(player, "CELESTIALSCANNING")) {
            return false;
        }
        int yaw = (int)(player.field_70177_z + 90.0f) % 360;
        int pitch = (int)Math.abs(player.field_70125_A);
        int ca = (int)(((double)player.field_70170_p.func_72826_c(0.0f) + 0.25) * 360.0) % 360;
        boolean night = ca > 180;
        boolean inRangeYaw = false;
        boolean inRangePitch = false;
        if (night) {
            ca -= 180;
        }
        if (ca > 90) {
            inRangeYaw = Math.abs(Math.abs(yaw) - 180) < 10;
            inRangePitch = Math.abs(180 - ca - pitch) < 7;
        } else {
            inRangeYaw = Math.abs(yaw) < 10;
            boolean bl = inRangePitch = Math.abs(ca - pitch) < 7;
        }
        if (inRangeYaw && inRangePitch) {
            return true;
        }
        return night;
    }

    @Override
    public void onSuccess(EntityPlayer player, Object object) {
        if (object != null || player.field_70125_A > 0.0f || !player.field_70170_p.func_175678_i(player.func_180425_c().func_177984_a()) || !ThaumcraftCapabilities.knowsResearchStrict(player, "CELESTIALSCANNING")) {
            return;
        }
        int yaw = (int)(player.field_70177_z + 90.0f) % 360;
        int pitch = (int)Math.abs(player.field_70125_A);
        int ca = (int)(((double)player.field_70170_p.func_72826_c(0.0f) + 0.25) * 360.0) % 360;
        boolean night = ca > 180;
        boolean inRangeYaw = false;
        boolean inRangePitch = false;
        if (night) {
            ca -= 180;
        }
        if (ca > 90) {
            inRangeYaw = Math.abs(Math.abs(yaw) - 180) < 10;
            inRangePitch = Math.abs(180 - ca - pitch) < 7;
        } else {
            inRangeYaw = Math.abs(yaw) < 10;
            inRangePitch = Math.abs(ca - pitch) < 7;
        }
        int worldDay = (int)(player.field_70170_p.func_82737_E() / 24000L);
        if (inRangeYaw && inRangePitch) {
            String pk = "CEL_" + worldDay + "_";
            String key = pk + (night ? "Moon" + player.field_70170_p.func_72853_d() : "Sun");
            System.out.println(key);
            if (ThaumcraftCapabilities.knowsResearch(player, key)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("tc.celestial.fail.1", new Object[]{""}));
                return;
            }
            if (InventoryUtils.isPlayerCarryingAmount(player, new ItemStack(Items.field_151121_aF), true) && InventoryUtils.isPlayerCarryingAmount(player, new ItemStack(ItemsTC.scribingTools, 1, Short.MAX_VALUE), true)) {
                InventoryUtils.consumeInventoryItem(player, new ItemStack(Items.field_151121_aF), true, true);
                ItemStack stack = new ItemStack(ItemsTC.celestialNotes, 1, night ? 5 + player.field_70170_p.func_72853_d() : 0);
                if (!player.field_71071_by.func_70441_a(stack)) {
                    player.func_71019_a(stack, false);
                }
                ThaumcraftApi.internalMethods.progressResearch(player, key);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("tc.celestial.fail.2", new Object[]{""}));
            }
            this.cleanResearch(player, pk);
            return;
        }
        if (night) {
            String pk;
            String key;
            boolean below;
            boolean bl = ca > 90 ? 180 - ca - pitch < 0 : (below = ca - pitch > 0);
            boolean right = ca > 90 ? Math.abs(yaw) - 180 > 0 : yaw > 0;
            int num = 0;
            if (below) {
                num = Utils.setBit(num, 0);
            }
            if (right) {
                num = Utils.setBit(num, 1);
            }
            if (ThaumcraftCapabilities.knowsResearch(player, key = (pk = "CEL_" + worldDay + "_") + "Star" + num)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("tc.celestial.fail.1", new Object[]{""}));
                return;
            }
            if (InventoryUtils.isPlayerCarryingAmount(player, new ItemStack(Items.field_151121_aF), true) && InventoryUtils.isPlayerCarryingAmount(player, new ItemStack(ItemsTC.scribingTools, 1, Short.MAX_VALUE), true)) {
                InventoryUtils.consumeInventoryItem(player, new ItemStack(Items.field_151121_aF), true, true);
                ItemStack stack = new ItemStack(ItemsTC.celestialNotes, 1, 1 + num);
                if (!player.field_71071_by.func_70441_a(stack)) {
                    player.func_71019_a(stack, false);
                }
                ThaumcraftApi.internalMethods.progressResearch(player, key);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("tc.celestial.fail.2", new Object[]{""}));
            }
            this.cleanResearch(player, pk);
            return;
        }
    }

    private void cleanResearch(EntityPlayer player, String pk) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : ThaumcraftCapabilities.getKnowledge(player).getResearchList()) {
            if (!key.startsWith("CEL_") || key.startsWith(pk)) continue;
            list.add(key);
        }
        for (String key : list) {
            ThaumcraftCapabilities.getKnowledge(player).removeResearch(key);
        }
        ResearchManager.syncList.put(player.func_70005_c_(), true);
    }

    @Override
    public String getResearchKey(EntityPlayer player, Object object) {
        return "";
    }
}

