/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.crafting;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.items.IScribeTools;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.api.research.theorycraft.ITheorycraftAid;
import thaumcraft.api.research.theorycraft.ResearchTableData;
import thaumcraft.api.research.theorycraft.TheorycraftManager;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.tiles.TileThaumcraft;

public class TileResearchTable
extends TileThaumcraft
implements IInventory {
    public ItemStack[] contents = new ItemStack[2];
    public ResearchTableData data = null;

    @Override
    public void readSyncNBT(NBTTagCompound nbttagcompound) {
        NBTTagList var2 = nbttagcompound.func_150295_c("Inventory", 10);
        this.contents = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < Math.min(2, var2.func_74745_c()); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < 0 || var5 >= this.contents.length) continue;
            this.contents[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        if (nbttagcompound.func_74764_b("note")) {
            this.data = new ResearchTableData(this);
            this.data.deserialize(nbttagcompound.func_74775_l("note"));
        } else {
            this.data = null;
        }
    }

    @Override
    public NBTTagCompound writeSyncNBT(NBTTagCompound nbttagcompound) {
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.contents.length; ++var3) {
            if (this.contents[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.contents[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbttagcompound.func_74782_a("Inventory", (NBTBase)var2);
        if (this.data != null) {
            nbttagcompound.func_74782_a("note", (NBTBase)this.data.serialize());
        } else {
            nbttagcompound.func_82580_o("note");
        }
        return nbttagcompound;
    }

    protected void func_190201_b(World worldIn) {
        super.func_190201_b(worldIn);
        if (!this.func_145830_o()) {
            this.func_145834_a(worldIn);
        }
    }

    public void startNewTheory(EntityPlayer player, Set<String> mutators) {
        this.data = new ResearchTableData(player, this);
        this.data.initialize(player, mutators);
        this.syncTile(false);
        this.func_70296_d();
    }

    public void finishTheory(EntityPlayer player) {
        Comparator valueComparator = (e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue());
        Map sortedMap = this.data.categoryTotals.entrySet().stream().sorted(valueComparator).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        int i = 0;
        for (String cat : sortedMap.keySet()) {
            int tot = Math.round((float)((Integer)sortedMap.get(cat)).intValue() / 100.0f * (float)IPlayerKnowledge.EnumKnowledgeType.THEORY.getProgression());
            if (i > this.data.penaltyStart) {
                tot *= 0;
            }
            ResearchCategory rc = ResearchCategories.getResearchCategory(cat);
            ThaumcraftApi.internalMethods.addKnowledge(player, IPlayerKnowledge.EnumKnowledgeType.THEORY, rc, tot);
            ++i;
        }
        this.data = null;
    }

    public Set<String> checkSurroundingAids() {
        ITheorycraftAid mu;
        HashMap<String, ITheorycraftAid> mutators = new HashMap<String, ITheorycraftAid>();
        for (int y = -1; y <= 1; ++y) {
            for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    for (String muk : TheorycraftManager.aids.keySet()) {
                        ItemStack is;
                        mu = TheorycraftManager.aids.get(muk);
                        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(x, y, z));
                        if (mu.getAidObject() instanceof Block) {
                            if (state.func_177230_c() != (Block)mu.getAidObject()) continue;
                            mutators.put(muk, mu);
                            continue;
                        }
                        if (!(mu.getAidObject() instanceof ItemStack) || (is = state.func_177230_c().func_185473_a(this.func_145831_w(), this.func_174877_v().func_177982_a(x, y, z), state)) == null || !is.func_185136_b((ItemStack)mu.getAidObject())) continue;
                        mutators.put(muk, mu);
                    }
                }
            }
        }
        List<Entity> l = EntityUtils.getEntitiesInRange(this.func_145831_w(), this.func_174877_v(), null, Entity.class, 5.0);
        if (l != null && !l.isEmpty()) {
            for (Entity e : l) {
                for (String muk : TheorycraftManager.aids.keySet()) {
                    mu = TheorycraftManager.aids.get(muk);
                    if (!(mu.getAidObject() instanceof Class) || !e.getClass().isAssignableFrom((Class)mu.getAidObject())) continue;
                    mutators.put(muk, mu);
                }
            }
        }
        return mutators.keySet();
    }

    public boolean consumeInkFromTable() {
        if (this.contents[0] != null && this.contents[0].func_77973_b() instanceof IScribeTools && this.contents[0].func_77952_i() < this.contents[0].func_77958_k()) {
            this.contents[0].func_77964_b(this.contents[0].func_77952_i() + 1);
            this.syncTile(false);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean consumepaperFromTable() {
        if (this.contents[1] != null && this.contents[1].func_77973_b() == Items.field_151121_aF && this.contents[1].field_77994_a > 0) {
            this.func_70298_a(1, 1);
            this.syncTile(false);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int var1) {
        return this.contents[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        if (this.contents[var1] != null) {
            if (this.contents[var1].field_77994_a <= var2) {
                ItemStack var3 = this.contents[var1];
                this.contents[var1] = null;
                this.func_70296_d();
                return var3;
            }
            ItemStack var3 = this.contents[var1].func_77979_a(var2);
            if (this.contents[var1].field_77994_a == 0) {
                this.contents[var1] = null;
            }
            this.func_70296_d();
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        if (this.contents[var1] != null) {
            ItemStack var2 = this.contents[var1];
            this.contents[var1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.contents[var1] = var2;
        if (var2 != null && var2.field_77994_a > this.func_70297_j_()) {
            var2.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return "Research Table";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) != this ? false : var1.func_174831_c(this.func_174877_v()) <= 64.0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        switch (i) {
            case 0: {
                if (!(itemstack.func_77973_b() instanceof IScribeTools)) break;
                return true;
            }
            case 1: {
                if (itemstack.func_77973_b() != Items.field_151121_aF || itemstack.func_77952_i() != 0) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.syncTile(false);
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundsTC.learn, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

