/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.proxies;

import com.google.common.collect.ImmutableList;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import thaumcraft.Thaumcraft;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigAspects;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigEntities;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.config.ConfigRecipes;
import thaumcraft.common.config.ConfigResearch;
import thaumcraft.common.lib.BehaviorDispenseAlumetum;
import thaumcraft.common.lib.InternalMethodHandler;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.capabilities.PlayerKnowledge;
import thaumcraft.common.lib.capabilities.PlayerWarp;
import thaumcraft.common.lib.events.CraftingEvents;
import thaumcraft.common.lib.events.WorldEvents;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.CropUtils;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.world.ThaumcraftWorldGenerator;
import thaumcraft.common.world.biomes.BiomeHandler;
import thaumcraft.proxies.IProxy;
import thaumcraft.proxies.ProxyGUI;

public class CommonProxy
implements IGuiHandler,
IProxy {
    ProxyGUI proxyGUI = new ProxyGUI();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().version = "6.0.BETA8";
        Thaumcraft.instance.modDir = event.getModConfigurationDirectory();
        try {
            Config.initialize(event.getSuggestedConfigurationFile());
        }
        catch (Exception e) {
            Thaumcraft.log.error("Thaumcraft has a problem loading it's configuration");
        }
        finally {
            if (Config.config != null) {
                Config.save();
            }
        }
        ThaumcraftApi.internalMethods = new InternalMethodHandler();
        PlayerKnowledge.preInit();
        PlayerWarp.preInit();
        PacketHandler.preInit();
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)WorldEvents.INSTANCE);
        GameRegistry.registerFuelHandler((IFuelHandler)new CraftingEvents());
        GameRegistry.registerWorldGenerator((IWorldGenerator)ThaumcraftWorldGenerator.INSTANCE, (int)0);
        Config.save();
        SoundsTC.registerSounds();
        ConfigItems.preInitSeals();
        ConfigBlocks.preInit();
        ConfigItems.preInit();
        ThaumcraftWorldGenerator.INSTANCE.initialize();
        MinecraftForge.EVENT_BUS.register((Object)Thaumcraft.instance);
        ConfigEntities.preInit();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ConfigBlocks.init();
        ConfigItems.init();
        BlockDispenser.field_149943_a.func_82595_a((Object)ItemsTC.alumentum, (Object)new BehaviorDispenseAlumetum());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Thaumcraft.instance, (IGuiHandler)this);
        ConfigResearch.init();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        Config.postInitPotions();
        ConfigEntities.postInitEntitySpawns();
        Config.postInitModCompatibility();
        ConfigRecipes.postInit();
        ConfigAspects.postInit();
        ConfigRecipes.postAspects();
        Config.postInitLoot();
        Config.postInitMisc();
        ImmutableList messages = FMLInterModComms.fetchRuntimeMessages((Object)this);
        for (FMLInterModComms.IMCMessage message : messages) {
            String[] t;
            ItemStack crop;
            if (message.key.equals("portableHoleBlacklist") && message.isStringMessage()) {
                BlockUtils.portableHoleBlackList.add(message.getStringValue());
            }
            if (message.key.equals("harvestStandardCrop") && message.isItemStackMessage()) {
                crop = message.getItemStackValue();
                CropUtils.addStandardCrop(crop, crop.func_77952_i());
            }
            if (message.key.equals("harvestClickableCrop") && message.isItemStackMessage()) {
                crop = message.getItemStackValue();
                CropUtils.addClickableCrop(crop, crop.func_77952_i());
            }
            if (message.key.equals("harvestStackedCrop") && message.isItemStackMessage()) {
                crop = message.getItemStackValue();
                CropUtils.addStackedCrop(crop, crop.func_77952_i());
            }
            if (message.key.equals("nativeCluster") && message.isStringMessage() && (t = message.getStringValue().split(",")) != null && t.length == 5) {
                try {
                    ItemStack ore = new ItemStack(Item.func_150899_d((int)Integer.parseInt(t[0])), 1, Integer.parseInt(t[1]));
                    ItemStack cluster = new ItemStack(Item.func_150899_d((int)Integer.parseInt(t[2])), 1, Integer.parseInt(t[3]));
                    Utils.addSpecialMiningResult(ore, cluster, Float.parseFloat(t[4]));
                }
                catch (Exception ore) {
                    // empty catch block
                }
            }
            if (message.key.equals("lampBlacklist") && message.isItemStackMessage()) {
                crop = message.getItemStackValue();
                CropUtils.blacklistLamp(crop, crop.func_77952_i());
            }
            if (message.key.equals("dimensionBlacklist") && message.isStringMessage() && (t = message.getStringValue().split(":")) != null && t.length == 2) {
                try {
                    BiomeHandler.addDimBlacklist(Integer.parseInt(t[0]), Integer.parseInt(t[1]));
                }
                catch (Exception ore) {
                    // empty catch block
                }
            }
            if (message.key.equals("biomeBlacklist") && message.isStringMessage() && (t = message.getStringValue().split(":")) != null && t.length == 2 && Biome.func_150568_d((int)Integer.parseInt(t[0])) != null) {
                try {
                    BiomeHandler.addBiomeBlacklist(Integer.parseInt(t[0]), Integer.parseInt(t[1]));
                }
                catch (Exception ore) {
                    // empty catch block
                }
            }
            if (!message.key.equals("championWhiteList") || !message.isStringMessage()) continue;
            try {
                t = message.getStringValue().split(":");
                Class oclass = (Class)EntityList.field_75625_b.get(t[0]);
                if (oclass == null) continue;
                ConfigEntities.championModWhitelist.put(oclass, Integer.parseInt(t[1]));
            }
            catch (Exception e) {
                Thaumcraft.log.error("Failed to Whitelist [" + message.getStringValue() + "] with [ championWhiteList ] message.");
            }
        }
        ConfigResearch.postInit();
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return this.proxyGUI.getClientGuiElement(ID, player, world, x, y, z);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return this.proxyGUI.getServerGuiElement(ID, player, world, x, y, z);
    }

    @Override
    public boolean isShiftKeyDown() {
        return false;
    }

    @Override
    public World getClientWorld() {
        return null;
    }
}

