/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileArcaneBore;
import thaumcraft.common.tiles.TileArcaneBoreBase;
import thaumcraft.common.tiles.TileThaumcraft;

public class BlockWoodenDeviceItem
extends ItemBlock {
    public BlockWoodenDeviceItem(Block par1) {
        super(par1);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public int func_77647_b(int par1) {
        return par1;
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return super.func_77658_a() + "." + par1ItemStack.func_77960_j();
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (stack.func_77960_j() == 0) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            if (!BlockWoodenDeviceItem.canPlaceBlockOnSide(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, side)) {
                return true;
            }
            Block bi = world.func_147439_a(x, y, z);
            if (side > 1 && stack.func_77960_j() == 0 && (bi == Blocks.field_150460_al || bi == Blocks.field_150470_am)) {
                if (world.field_72995_K) {
                    return false;
                }
                this.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
                return true;
            }
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        int var6;
        TileThaumcraft tile;
        boolean ret = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (metadata == 4 && (tile = (TileArcaneBoreBase)world.func_147438_o(x, y, z)) != null && tile instanceof TileArcaneBoreBase) {
            var6 = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (var6) {
                case 0: {
                    tile.orientation = ForgeDirection.getOrientation((int)2);
                    break;
                }
                case 1: {
                    tile.orientation = ForgeDirection.getOrientation((int)5);
                    break;
                }
                case 2: {
                    tile.orientation = ForgeDirection.getOrientation((int)3);
                    break;
                }
                case 3: {
                    tile.orientation = ForgeDirection.getOrientation((int)4);
                }
            }
            world.func_147471_g(x, y, x);
        }
        if (metadata == 5 && (tile = (TileArcaneBore)world.func_147438_o(x, y, z)) != null && tile instanceof TileArcaneBore) {
            ((TileArcaneBore)tile).baseOrientation = ForgeDirection.getOrientation((int)side);
            var6 = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)player);
            ((TileArcaneBore)tile).orientation = ForgeDirection.getOrientation((int)var6);
            world.func_147471_g(x, y, x);
        }
        return ret;
    }

    public boolean func_150936_a(World world, int x, int y, int z, int side, EntityPlayer par6EntityPlayer, ItemStack par7ItemStack) {
        if (par7ItemStack.func_77960_j() == 5) {
            if (side > 1) {
                return false;
            }
            if (world.func_147439_a(x, y, z) != ConfigBlocks.blockWoodenDevice && world.func_72805_g(x, y, z) != 4) {
                return false;
            }
        }
        return super.func_150936_a(world, x, y, z, side, par6EntityPlayer, par7ItemStack);
    }

    public static boolean canPlaceBlockOnSide(World world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN) {
            return false;
        }
        Block bi = world.func_147439_a(x += dir.getOpposite().offsetX, y, z += dir.getOpposite().offsetZ);
        int md = world.func_72805_g(x, y, z);
        if (bi == ConfigBlocks.blockStoneDevice && md == 0) {
            return true;
        }
        if (bi == ConfigBlocks.blockTube && md == 4) {
            return true;
        }
        if (bi == Blocks.field_150460_al || bi == Blocks.field_150470_am || bi == ConfigBlocks.blockMetalDevice && md == 0) {
            return true;
        }
        if (bi == ConfigBlocks.blockArcaneFurnace && md == 10) {
            return false;
        }
        bi = world.func_147439_a(x += dir.getOpposite().offsetX, y, z += dir.getOpposite().offsetZ);
        md = world.func_72805_g(x, y, z);
        return bi == ConfigBlocks.blockArcaneFurnace && md == 0;
    }
}

