/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import thaumcraft.api.IRepairable;
import thaumcraft.api.IRepairableExtended;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.EntityAspectOrb;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.monster.EntityTaintChicken;
import thaumcraft.common.entities.monster.EntityTaintCow;
import thaumcraft.common.entities.monster.EntityTaintCreeper;
import thaumcraft.common.entities.monster.EntityTaintPig;
import thaumcraft.common.entities.monster.EntityTaintSheep;
import thaumcraft.common.entities.monster.EntityTaintVillager;
import thaumcraft.common.entities.monster.EntityThaumicSlime;
import thaumcraft.common.entities.projectile.EntityPrimalArrow;
import thaumcraft.common.items.armor.Hover;
import thaumcraft.common.items.armor.ItemHoverHarness;
import thaumcraft.common.items.equipment.ItemBowBone;
import thaumcraft.common.items.equipment.ItemElementalSword;
import thaumcraft.common.items.wands.WandManager;
import thaumcraft.common.lib.InventoryHelper;
import thaumcraft.common.lib.Utils;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.tiles.TileOwned;

public class EventHandlerEntity {
    public HashMap<Integer, Float> prevStep = new HashMap();
    public static HashMap<String, ArrayList<WeakReference<Entity>>> linkedEntities = new HashMap();

    @SubscribeEvent
    public void droppedItem(ItemTossEvent event) {
        NBTTagCompound itemData = event.entityItem.getEntityData();
        itemData.func_74778_a("thrower", event.player.func_70005_c_());
    }

    public static void doRepair(ItemStack is, EntityPlayer player) {
        AspectList cost;
        int level = EnchantmentHelper.func_77506_a((int)Config.enchRepair.field_77352_x, (ItemStack)is);
        if (level <= 0) {
            return;
        }
        if (level > 2) {
            level = 2;
        }
        if ((cost = ThaumcraftCraftingManager.getObjectTags(is)) == null || cost.size() == 0) {
            return;
        }
        cost = ResearchManager.reduceToPrimals(cost);
        AspectList finalCost = new AspectList();
        for (Aspect a : cost.getAspects()) {
            finalCost.merge(a, (int)Math.sqrt(cost.getAmount(a) * 2) * level);
        }
        if (is.func_77973_b() instanceof IRepairableExtended) {
            if (((IRepairableExtended)is.func_77973_b()).doRepair(is, player, level) && WandManager.consumeVisFromInventory(player, finalCost)) {
                is.func_77972_a(-level, (EntityLivingBase)player);
            }
        } else if (WandManager.consumeVisFromInventory(player, finalCost)) {
            is.func_77972_a(-level, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void livingTick(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (!event.entity.field_70170_p.field_72995_K && player.field_70173_aa % 40 == 0) {
                ItemStack is;
                int a = 0;
                while (true) {
                    EntityPlayer entityPlayer = player;
                    if (a >= entityPlayer.field_71071_by.func_70451_h()) break;
                    if (player.field_71071_by.field_70462_a[a] != null && (is = player.field_71071_by.field_70462_a[a]).func_77960_j() > 0 && is.func_77973_b() instanceof IRepairable && !player.field_71075_bZ.field_75098_d && !(is.func_77973_b() instanceof ItemHoverHarness)) {
                        EventHandlerEntity.doRepair(is, player);
                    }
                    ++a;
                }
                for (a = 0; a < 4; ++a) {
                    if (player.field_71071_by.func_70440_f(a) == null || (is = player.field_71071_by.func_70440_f(a)).func_77960_j() <= 0 || !(is.func_77973_b() instanceof IRepairable) || player.field_71075_bZ.field_75098_d) continue;
                    EventHandlerEntity.doRepair(is, player);
                }
            }
            if ((player.field_71071_by.func_70440_f(2) == null || !(player.field_71071_by.func_70440_f(2).func_77973_b() instanceof ItemHoverHarness)) && Hover.getHover(player.func_145782_y())) {
                Hover.setHover(player.func_145782_y(), false);
                player.field_71075_bZ.field_75100_b = false;
            }
            this.updateSpeed(player);
            if (player.field_70170_p.field_72995_K && (player.func_70093_af() || player.field_71071_by.func_70440_f(0) == null || player.field_71071_by.func_70440_f(0).func_77973_b() != ConfigItems.itemBootsTraveller) && this.prevStep.containsKey(player.func_145782_y())) {
                player.field_70138_W = this.prevStep.get(player.func_145782_y()).floatValue();
                this.prevStep.remove(player.func_145782_y());
            }
            if (player.func_70632_aY() && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemElementalSword) {
                player.field_70181_x += (double)0.08f;
                if (player.field_70181_x > 0.5) {
                    player.field_70181_x = 0.2f;
                }
                if (player instanceof EntityPlayerMP) {
                    Utils.resetFloatCounter((EntityPlayerMP)player);
                }
            }
        }
    }

    private void updateSpeed(EntityPlayer player) {
        int haste;
        if (!player.field_71075_bZ.field_75100_b && player.field_71071_by.func_70440_f(0) != null && player.field_70701_bs > 0.0f && (haste = EnchantmentHelper.func_77506_a((int)Config.enchHaste.field_77352_x, (ItemStack)player.field_71071_by.func_70440_f(0))) > 0) {
            float bonus = (float)haste * 0.015f;
            if (player.field_70160_al) {
                bonus /= 2.0f;
            }
            if (player.func_70090_H()) {
                bonus /= 2.0f;
            }
            player.func_70060_a(0.0f, 1.0f, bonus);
        }
    }

    @SubscribeEvent
    public void playerJumps(LivingEvent.LivingJumpEvent event) {
        if (event.entity instanceof EntityPlayer && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(0) != null && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(0).func_77973_b() == ConfigItems.itemBootsTraveller) {
            event.entityLiving.field_70181_x += (double)0.275f;
        }
    }

    @SubscribeEvent
    public void playerInteract(EntityInteractEvent event) {
        if (event.target instanceof EntityGolemBase && ((EntityGolemBase)event.target).getOwnerName().length() > 0 && !((EntityGolemBase)event.target).getOwnerName().equals(event.entityPlayer.func_70005_c_())) {
            if (!event.entityPlayer.field_70170_p.field_72995_K) {
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("You are not my Master!", new Object[0]));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void entitySpawns(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K) {
            ArrayList<WeakReference<Entity>> dudes;
            if (event.entity instanceof EntityEnderPearl) {
                int x = MathHelper.func_76128_c((double)event.entity.field_70165_t);
                int y = MathHelper.func_76128_c((double)event.entity.field_70163_u);
                int z = MathHelper.func_76128_c((double)event.entity.field_70161_v);
                block0: for (int xx = -5; xx <= 5; ++xx) {
                    for (int yy = -5; yy <= 5; ++yy) {
                        for (int zz = -5; zz <= 5; ++zz) {
                            TileEntity tile = event.world.func_147438_o(x + xx, y + yy, z + zz);
                            if (tile == null || !(tile instanceof TileOwned)) continue;
                            if (((EntityEnderPearl)event.entity).func_85052_h() instanceof EntityPlayer) {
                                ((EntityPlayer)((EntityEnderPearl)event.entity).func_85052_h()).func_145747_a((IChatComponent)new ChatComponentText("\u00a75\u00a7oThe magic of a nearby warded object destroys the ender pearl."));
                            }
                            event.entity.func_70106_y();
                            break block0;
                        }
                    }
                }
            }
            if (event.entity instanceof EntityPlayer && (dudes = linkedEntities.get(event.entity.func_70005_c_())) != null) {
                for (WeakReference<Entity> dude : dudes) {
                    if (dude.get() == null) continue;
                    ((Entity)dude.get()).field_71088_bW = ((Entity)dude.get()).func_82147_ab();
                    ((Entity)dude.get()).func_71027_c(event.world.field_73011_w.field_76574_g);
                }
            }
        }
    }

    @SubscribeEvent
    public void itemPickup(EntityItemPickupEvent event) {
        if (event.entityPlayer.func_70005_c_().startsWith("FakeThaumcraft")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingTick(LivingDeathEvent event) {
        AspectList aspectsCompound;
        if (!event.entityLiving.field_70170_p.field_72995_K && !(event.entityLiving instanceof ITaintedMob) && event.entityLiving.func_82165_m(Config.potionFluxTaintID)) {
            EntityMob entity = null;
            if (event.entityLiving instanceof EntityCreeper) {
                entity = new EntityTaintCreeper(event.entityLiving.field_70170_p);
            } else if (event.entityLiving instanceof EntitySheep) {
                entity = new EntityTaintSheep(event.entityLiving.field_70170_p);
            } else if (event.entityLiving instanceof EntityCow) {
                entity = new EntityTaintCow(event.entityLiving.field_70170_p);
            } else if (event.entityLiving instanceof EntityPig) {
                entity = new EntityTaintPig(event.entityLiving.field_70170_p);
            } else if (event.entityLiving instanceof EntityChicken) {
                entity = new EntityTaintChicken(event.entityLiving.field_70170_p);
            } else if (event.entityLiving instanceof EntityVillager) {
                entity = new EntityTaintVillager(event.entityLiving.field_70170_p);
            } else {
                entity = new EntityThaumicSlime(event.entityLiving.field_70170_p);
                if (entity != null) {
                    ((EntityThaumicSlime)entity).setSlimeSize((int)(1.0f + Math.min(event.entityLiving.func_110138_aP() / 10.0f, 6.0f)));
                }
            }
            if (entity != null) {
                entity.func_70012_b(event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, event.entityLiving.field_70177_z, 0.0f);
                event.entityLiving.field_70170_p.func_72838_d((Entity)entity);
                event.entityLiving.func_70106_y();
            }
        } else if (!event.entityLiving.field_70170_p.field_72995_K && Utils.getRecentlyHit(event.entityLiving) > 0 && (aspectsCompound = ScanManager.generateEntityAspects((Entity)event.entityLiving)) != null && aspectsCompound.size() > 0) {
            AspectList aspects = ResearchManager.reduceToPrimals(aspectsCompound);
            for (Aspect aspect : aspects.getAspects()) {
                if (!event.entityLiving.field_70170_p.field_73012_v.nextBoolean()) continue;
                EntityAspectOrb orb = new EntityAspectOrb(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, aspect, 1 + event.entityLiving.field_70170_p.field_73012_v.nextInt(aspects.getAmount(aspect)));
                event.entityLiving.field_70170_p.func_72838_d((Entity)orb);
            }
        }
    }

    @SubscribeEvent
    public void bowNocked(ArrowNockEvent event) {
        if (event.entityPlayer.field_71071_by.func_146028_b(ConfigItems.itemPrimalArrow)) {
            event.entityPlayer.func_71008_a(event.result, event.result.func_77973_b().func_77626_a(event.result));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void bowShot(ArrowLooseEvent event) {
        if (event.entityPlayer.field_71071_by.func_146028_b(ConfigItems.itemPrimalArrow)) {
            float f = 0.0f;
            float dam = 2.0f;
            if (event.bow.func_77973_b() instanceof ItemBowBone) {
                f = (float)event.charge / 10.0f;
                if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                    return;
                }
                dam = 2.5f;
            } else {
                f = (float)event.charge / 20.0f;
                if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                    return;
                }
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            int type = 0;
            for (int j = 0; j < event.entityPlayer.field_71071_by.field_70462_a.length; ++j) {
                if (event.entityPlayer.field_71071_by.field_70462_a[j] == null || event.entityPlayer.field_71071_by.field_70462_a[j].func_77973_b() != ConfigItems.itemPrimalArrow) continue;
                type = event.entityPlayer.field_71071_by.field_70462_a[j].func_77960_j();
                break;
            }
            EntityPrimalArrow entityarrow = new EntityPrimalArrow(event.entityPlayer.field_70170_p, (EntityLivingBase)event.entityPlayer, f * dam, type);
            if (event.bow.func_77973_b() instanceof ItemBowBone) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + 0.5);
            } else if (f == 1.0f) {
                entityarrow.func_70243_d(true);
            }
            int k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)event.bow);
            if (k > 0) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)k * 0.5 + 0.5);
            }
            int l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)event.bow);
            if (type == 3) {
                ++l;
            }
            if (l > 0) {
                entityarrow.func_70240_a(l);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)event.bow) > 0) {
                entityarrow.func_70015_d(100);
            }
            event.bow.func_77972_a(1, (EntityLivingBase)event.entityPlayer);
            event.entityPlayer.field_70170_p.func_72956_a((Entity)event.entityPlayer, "random.bow", 1.0f, 1.0f / (event.entityPlayer.field_70170_p.field_73012_v.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            boolean flag = false;
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)event.bow) > 0 && event.entityPlayer.field_70170_p.field_73012_v.nextFloat() < 0.33f) {
                flag = true;
            }
            if (!event.entityPlayer.field_71075_bZ.field_75098_d || !flag) {
                InventoryHelper.consumeInventoryItem(event.entityPlayer, ConfigItems.itemPrimalArrow, type);
            }
            if (!event.entityPlayer.field_70170_p.field_72995_K) {
                event.entityPlayer.field_70170_p.func_72838_d((Entity)entityarrow);
            }
            event.setCanceled(true);
        }
    }
}

