/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.client.gui.GuiResearchBrowser;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.network.misc.PacketConfig;
import thaumcraft.common.lib.network.playerdata.PacketSyncAspects;
import thaumcraft.common.lib.network.playerdata.PacketSyncResearch;
import thaumcraft.common.lib.network.playerdata.PacketSyncScannedEntities;
import thaumcraft.common.lib.network.playerdata.PacketSyncScannedItems;
import thaumcraft.common.lib.network.playerdata.PacketSyncScannedPhenomena;
import thaumcraft.common.lib.research.ResearchManager;

public class EventHandlerNetwork {
    @SubscribeEvent
    public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            EntityPlayer p = event.player;
            Thaumcraft.proxy.getPlayerKnowledge().wipePlayerKnowledge(p.func_70005_c_());
            ResearchManager.loadPlayerData(p);
            Collection<ResearchCategoryList> rc = ResearchCategories.researchCategories.values();
            for (ResearchCategoryList cat : rc) {
                Collection<ResearchItem> res = cat.research.values();
                for (ResearchItem ri : res) {
                    if (!ri.isAutoUnlock()) continue;
                    Thaumcraft.proxy.getResearchManager().completeResearch(p, ri.key);
                }
            }
            Thaumcraft.packetPipeline.sendTo(new PacketSyncResearch(p), (EntityPlayerMP)p);
            Thaumcraft.packetPipeline.sendTo(new PacketSyncScannedItems(p), (EntityPlayerMP)p);
            Thaumcraft.packetPipeline.sendTo(new PacketSyncScannedEntities(p), (EntityPlayerMP)p);
            Thaumcraft.packetPipeline.sendTo(new PacketSyncScannedPhenomena(p), (EntityPlayerMP)p);
            Thaumcraft.packetPipeline.sendTo(new PacketSyncAspects(p), (EntityPlayerMP)p);
            Thaumcraft.packetPipeline.sendTo(new PacketConfig(), (EntityPlayerMP)p);
        }
    }

    @SubscribeEvent
    public void clientLoggedIn(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (Thaumcraft.proxy.getClientWorld() != null && Minecraft.func_71410_x().field_71439_g != null) {
            GuiResearchBrowser.completedResearch.put(Minecraft.func_71410_x().field_71439_g.func_70005_c_(), new ArrayList());
            Thaumcraft.log.info("Resetting research to defaults.");
        }
    }

    @SubscribeEvent
    public void clientLogsOut(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (Thaumcraft.proxy.getClientWorld() != null) {
            Thaumcraft.proxy.getPlayerKnowledge().wipePlayerKnowledge(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
            Config.allowCheatSheet = Config.CallowCheatSheet;
            Config.wardedStone = Config.CwardedStone;
            Config.allowMirrors = Config.CallowMirrors;
            Config.hardNode = Config.ChardNode;
            Config.researchDifficulty = Config.CresearchDifficulty;
            Config.aspectCap = Config.CaspectCap;
            Config.aspectTotalCap = Config.CaspectTotalCap;
            Thaumcraft.log.info("Restoring client configs.");
        }
    }
}

