/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.misc;

import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.network.AbstractPacket;
import thaumcraft.common.tiles.TileSensor;

public class PacketNote
extends AbstractPacket {
    private int x;
    private int y;
    private int z;
    private int dim;
    private byte note;

    public PacketNote() {
    }

    public PacketNote(int x, int y, int z, int dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
        this.note = (byte)-1;
    }

    public PacketNote(int x, int y, int z, int dim, byte note) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
        this.note = note;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.dim);
        buffer.writeByte((int)this.note);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.dim = buffer.readInt();
        this.note = buffer.readByte();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (this.note >= 0) {
            TileEntity tile = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
            if (tile != null && tile instanceof TileEntityNote) {
                ((TileEntityNote)tile).field_145879_a = this.note;
            } else if (tile != null && tile instanceof TileSensor) {
                ((TileSensor)tile).note = this.note;
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (this.note == -1) {
            WorldServer world = DimensionManager.getWorld((int)this.dim);
            if (world == null) {
                return;
            }
            TileEntity tile = world.func_147438_o(this.x, this.y, this.z);
            byte note = -1;
            if (tile != null && tile instanceof TileEntityNote) {
                note = ((TileEntityNote)tile).field_145879_a;
            } else if (tile != null && tile instanceof TileSensor) {
                note = ((TileSensor)tile).note;
            }
            if (note >= 0) {
                Thaumcraft.packetPipeline.sendToAllAround(new PacketNote(this.x, this.y, this.z, this.dim, note), new NetworkRegistry.TargetPoint(this.dim, (double)this.x, (double)this.y, (double)this.z, 8.0));
            }
        }
    }
}

