/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.playerdata;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.api.research.ScanResult;
import thaumcraft.common.lib.network.AbstractPacket;
import thaumcraft.common.lib.research.ScanManager;

public class PacketScannedToServer
extends AbstractPacket {
    private int playerid;
    private int dim;
    private byte type;
    private int id;
    private int md;
    private int entityid;
    private String phenomena;
    private String prefix;

    public PacketScannedToServer() {
    }

    public PacketScannedToServer(ScanResult scan, EntityPlayer player, String prefix) {
        this.playerid = player.func_145782_y();
        this.dim = player.field_70170_p.field_73011_w.field_76574_g;
        this.type = scan.type;
        this.id = scan.id;
        this.md = scan.meta;
        this.entityid = scan.entity == null ? 0 : scan.entity.func_145782_y();
        this.phenomena = scan.phenomena;
        this.prefix = prefix;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.playerid);
        buffer.writeInt(this.dim);
        buffer.writeByte((int)this.type);
        buffer.writeInt(this.id);
        buffer.writeInt(this.md);
        buffer.writeInt(this.entityid);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.phenomena);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.prefix);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.playerid = buffer.readInt();
        this.dim = buffer.readInt();
        this.type = buffer.readByte();
        this.id = buffer.readInt();
        this.md = buffer.readInt();
        this.entityid = buffer.readInt();
        this.phenomena = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.prefix = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player2) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return;
        }
        Entity player = world.func_73045_a(this.playerid);
        Entity e = null;
        if (this.entityid != 0) {
            e = world.func_73045_a(this.entityid);
        }
        if (player != null && player instanceof EntityPlayer) {
            ScanManager.completeScan((EntityPlayer)player, new ScanResult(this.type, this.id, this.md, e, this.phenomena), this.prefix);
        }
    }
}

