/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntitySpellParticleFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.Utils;
import thaumcraft.common.tiles.TileThaumcraft;

public class TileMirror
extends TileThaumcraft {
    public boolean linked = false;
    public int linkX;
    public int linkY;
    public int linkZ;
    public int linkDim;
    public ForgeDirection linkedFacing = ForgeDirection.UNKNOWN;
    int transportDelay = 0;
    int count = 0;
    int inc = 40;

    public boolean canUpdate() {
        return true;
    }

    public void restoreLink() {
        if (this.isDestinationValid()) {
            WorldServer targetWorld = MinecraftServer.func_71276_C().func_71218_a(this.linkDim);
            if (targetWorld == null) {
                return;
            }
            TileEntity te = targetWorld.func_147438_o(this.linkX, this.linkY, this.linkZ);
            if (te != null && te instanceof TileMirror) {
                TileMirror tm = (TileMirror)te;
                tm.linked = true;
                tm.linkX = this.field_145851_c;
                tm.linkY = this.field_145848_d;
                tm.linkZ = this.field_145849_e;
                tm.linkDim = this.field_145850_b.field_73011_w.field_76574_g;
                targetWorld.func_147471_g(tm.field_145851_c, tm.field_145848_d, tm.field_145849_e);
                this.linkedFacing = ForgeDirection.getOrientation((int)targetWorld.func_72805_g(this.linkX, this.linkY, this.linkZ));
                this.linked = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public void invalidateLink() {
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (targetWorld == null) {
            return;
        }
        if (!Utils.isChunkLoaded((World)targetWorld, this.linkX, this.linkZ)) {
            return;
        }
        TileEntity te = targetWorld.func_147438_o(this.linkX, this.linkY, this.linkZ);
        if (te != null && te instanceof TileMirror) {
            TileMirror tm = (TileMirror)te;
            tm.linked = false;
            tm.linkedFacing = ForgeDirection.UNKNOWN;
            targetWorld.func_147471_g(this.linkX, this.linkY, this.linkZ);
        }
    }

    public boolean isLinkValid() {
        if (!this.linked) {
            return false;
        }
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (targetWorld == null) {
            return false;
        }
        TileEntity te = targetWorld.func_147438_o(this.linkX, this.linkY, this.linkZ);
        if (te == null || !(te instanceof TileMirror)) {
            this.linked = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return false;
        }
        TileMirror tm = (TileMirror)te;
        if (!tm.linked) {
            this.linked = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return false;
        }
        if (tm.linkX != this.field_145851_c || tm.linkY != this.field_145848_d || tm.linkZ != this.field_145849_e || tm.linkDim != this.field_145850_b.field_73011_w.field_76574_g) {
            this.linked = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return false;
        }
        return true;
    }

    public boolean isLinkValidSimple() {
        if (!this.linked) {
            return false;
        }
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (targetWorld == null) {
            return false;
        }
        TileEntity te = targetWorld.func_147438_o(this.linkX, this.linkY, this.linkZ);
        if (te == null || !(te instanceof TileMirror)) {
            return false;
        }
        TileMirror tm = (TileMirror)te;
        if (!tm.linked) {
            return false;
        }
        return tm.linkX == this.field_145851_c && tm.linkY == this.field_145848_d && tm.linkZ == this.field_145849_e && tm.linkDim == this.field_145850_b.field_73011_w.field_76574_g;
    }

    public boolean isDestinationValid() {
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (targetWorld == null) {
            return false;
        }
        TileEntity te = targetWorld.func_147438_o(this.linkX, this.linkY, this.linkZ);
        if (te == null || !(te instanceof TileMirror)) {
            this.linked = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return false;
        }
        TileMirror tm = (TileMirror)te;
        return !tm.isLinkValid();
    }

    public boolean transport(EntityItem ie) {
        WorldServer targetWorld;
        if (this.transportDelay > 0) {
            return false;
        }
        ItemStack items = ie.func_92059_d();
        if (!this.linked || !this.isLinkValid()) {
            return false;
        }
        this.transportDelay = 1;
        if (this.linkedFacing == ForgeDirection.UNKNOWN && (targetWorld = DimensionManager.getWorld((int)this.linkDim)) != null) {
            this.linkedFacing = ForgeDirection.getOrientation((int)targetWorld.func_72805_g(this.linkX, this.linkY, this.linkZ));
        }
        if ((targetWorld = MinecraftServer.func_71276_C().func_71218_a(this.linkDim)) == null) {
            return false;
        }
        EntityItem ie2 = new EntityItem((World)targetWorld, (double)this.linkX + 0.5 - (double)this.linkedFacing.offsetX * 0.3, (double)this.linkY + 0.5 - (double)this.linkedFacing.offsetY * 0.3, (double)this.linkZ + 0.5 - (double)this.linkedFacing.offsetZ * 0.3, items.func_77946_l());
        ie2.field_70159_w = (float)this.linkedFacing.offsetX * 0.15f;
        ie2.field_70181_x = (float)this.linkedFacing.offsetY * 0.15f;
        ie2.field_70179_y = (float)this.linkedFacing.offsetZ * 0.15f;
        ie2.field_71088_bW = 20;
        targetWorld.func_72838_d((Entity)ie2);
        ie.func_70106_y();
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, ConfigBlocks.blockMirror, 1, 0);
        targetWorld.func_147452_c(this.linkX, this.linkY, this.linkZ, ConfigBlocks.blockMirror, 1, 0);
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.linked = nbttagcompound.func_74767_n("linked");
        this.linkX = nbttagcompound.func_74762_e("linkX");
        this.linkY = nbttagcompound.func_74762_e("linkY");
        this.linkZ = nbttagcompound.func_74762_e("linkZ");
        this.linkDim = nbttagcompound.func_74762_e("linkDim");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("linked", this.linked);
        nbttagcompound.func_74768_a("linkX", this.linkX);
        nbttagcompound.func_74768_a("linkY", this.linkY);
        nbttagcompound.func_74768_a("linkZ", this.linkZ);
        nbttagcompound.func_74768_a("linkDim", this.linkDim);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "mob.endermen.portal", 0.1f, 1.0f, false);
                ForgeDirection face = ForgeDirection.getOrientation((int)this.func_145832_p());
                for (int q = 0; q < Thaumcraft.proxy.particleCount(3); ++q) {
                    double xx = (double)this.field_145851_c + 0.33 + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.33f) - (double)face.offsetX / 2.0;
                    double yy = (double)this.field_145848_d + 0.33 + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.33f) - (double)face.offsetY / 2.0;
                    double zz = (double)this.field_145849_e + 0.33 + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.33f) - (double)face.offsetZ / 2.0;
                    EntitySpellParticleFX var21 = new EntitySpellParticleFX(this.field_145850_b, xx, yy, zz, 0.0, 0.0, 0.0);
                    var21.field_70159_w = (double)face.offsetX * 0.05;
                    var21.field_70181_x = (double)face.offsetY * 0.05;
                    var21.field_70179_y = (double)face.offsetZ * 0.05;
                    var21.func_82338_g(0.5f);
                    var21.func_70538_b(0.0f, 0.0f, 0.0f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)var21);
                }
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }

    public void func_145845_h() {
        if (this.transportDelay > 0) {
            --this.transportDelay;
        }
        if (!this.field_145850_b.field_72995_K && this.count++ % this.inc == 0) {
            if (!this.isLinkValidSimple()) {
                if (this.inc < 600) {
                    this.inc += 20;
                }
                this.restoreLink();
            } else {
                this.inc = 40;
            }
        }
    }
}

