/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.research;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;

public class ResearchPage {
    public PageType type = PageType.TEXT;
    public String text = null;
    public String research = null;
    public ResourceLocation image = null;
    public AspectList aspects = null;
    public Object recipe = null;
    public Object recipeOutput = null;

    public ResearchPage(String text) {
        this.type = PageType.TEXT;
        this.text = text;
    }

    public ResearchPage(IRecipe recipe) {
        this.type = PageType.NORMAL_CRAFTING;
        this.recipe = recipe;
        this.recipeOutput = recipe.func_77571_b();
    }

    public ResearchPage(IRecipe[] recipe) {
        this.type = PageType.NORMAL_CRAFTING;
        this.recipe = recipe;
    }

    public ResearchPage(IArcaneRecipe[] recipe) {
        this.type = PageType.ARCANE_CRAFTING;
        this.recipe = recipe;
    }

    public ResearchPage(CrucibleRecipe[] recipe) {
        this.type = PageType.CRUCIBLE_CRAFTING;
        this.recipe = recipe;
    }

    public ResearchPage(InfusionRecipe[] recipe) {
        this.type = PageType.INFUSION_CRAFTING;
        this.recipe = recipe;
    }

    public ResearchPage(List recipe) {
        this.type = PageType.COMPOUND_CRAFTING;
        this.recipe = recipe;
    }

    public ResearchPage(IArcaneRecipe recipe) {
        this.type = PageType.ARCANE_CRAFTING;
        this.recipe = recipe;
        this.recipeOutput = recipe.func_77571_b();
    }

    public ResearchPage(CrucibleRecipe recipe) {
        this.type = PageType.CRUCIBLE_CRAFTING;
        this.recipe = recipe;
        this.recipeOutput = recipe.getRecipeOutput();
    }

    public ResearchPage(ItemStack input) {
        this.type = PageType.SMELTING;
        this.recipe = input;
        this.recipeOutput = FurnaceRecipes.func_77602_a().func_151395_a(input);
    }

    public ResearchPage(InfusionRecipe recipe) {
        this.type = PageType.INFUSION_CRAFTING;
        this.recipe = recipe;
        this.recipeOutput = recipe.getRecipeOutput() instanceof ItemStack ? (ItemStack)recipe.getRecipeOutput() : recipe.getRecipeInput();
    }

    public ResearchPage(ResourceLocation image, String caption) {
        this.type = PageType.IMAGE;
        this.image = image;
        this.text = caption;
    }

    public ResearchPage(AspectList as) {
        this.type = PageType.ASPECTS;
        this.aspects = as;
    }

    public String getTranslatedText() {
        String ret = "";
        if (this.text != null && (ret = StatCollector.func_74838_a((String)this.text)).isEmpty()) {
            ret = this.text;
        }
        return ret;
    }

    public ResearchPage setRequisite(String research) {
        this.research = research;
        return this;
    }

    public static enum PageType {
        TEXT,
        IMAGE,
        CRUCIBLE_CRAFTING,
        ARCANE_CRAFTING,
        ASPECTS,
        NORMAL_CRAFTING,
        INFUSION_CRAFTING,
        COMPOUND_CRAFTING,
        SMELTING;

    }
}

