/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.fx;

import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityLavaFX;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.beams.FXArc;
import thaumcraft.client.fx.beams.FXBeamBore;
import thaumcraft.client.fx.beams.FXBeamWand;
import thaumcraft.client.fx.beams.FXBolt;
import thaumcraft.client.fx.other.FXBlockWard;
import thaumcraft.client.fx.particles.FXBlockRunes;
import thaumcraft.client.fx.particles.FXBoreParticles;
import thaumcraft.client.fx.particles.FXBoreSparkle;
import thaumcraft.client.fx.particles.FXBreakingFade;
import thaumcraft.client.fx.particles.FXBubble;
import thaumcraft.client.fx.particles.FXBurst;
import thaumcraft.client.fx.particles.FXEssentiaTrail2;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.client.fx.particles.FXPlane;
import thaumcraft.client.fx.particles.FXSmokeSpiral;
import thaumcraft.client.fx.particles.FXSpark;
import thaumcraft.client.fx.particles.FXSparkle;
import thaumcraft.client.fx.particles.FXSwarm;
import thaumcraft.client.fx.particles.FXSwarmRunes;
import thaumcraft.client.fx.particles.FXVent;
import thaumcraft.client.fx.particles.FXVisSparkle;
import thaumcraft.client.fx.particles.FXWisp;
import thaumcraft.client.fx.particles.FXWispEG;
import thaumcraft.client.fx.particles.FXWispyOrb;
import thaumcraft.common.tiles.crafting.TileCrucible;

public class FXDispatcher {
    public World getWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    public int particleCount(int base) {
        return FMLClientHandler.instance().getClient().field_71474_y.field_74362_aa == 2 ? base / 2 : (FMLClientHandler.instance().getClient().field_71474_y.field_74362_aa == 1 ? base * 1 : base * 2);
    }

    public void drawGenericParticles(double x, double y, double z, double x2, double y2, double z2, float r, float g, float b, float alpha, boolean loop, int start, int num, int inc, int age, int delay, float scale, float rot, int layer) {
        FXGeneric fb = new FXGeneric(this.getWorld(), x, y, z, x2, y2, z2);
        fb.setMaxAge(age, delay);
        fb.func_70538_b(r, g, b);
        fb.func_82338_g(alpha);
        fb.setLoop(loop);
        fb.setParticles(start, num, inc);
        fb.setScale(scale);
        fb.setLayer(layer);
        fb.setRotationSpeed(rot);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void drawSwarmRunes(double x, double y, double z, Entity target) {
        FXSwarmRunes fx = new FXSwarmRunes(this.getWorld(), x, y, z, target, 0.7f + this.getWorld().field_73012_v.nextFloat() * 0.2f, 0.3f + this.getWorld().field_73012_v.nextFloat() * 0.1f, 0.0f, 0.22f, 15.0f, 0.08f);
        ParticleEngine.instance.addEffect(this.getWorld(), fx);
    }

    public void drawLevitatorParticles(double x, double y, double z, double x2, double y2, double z2) {
        FXGeneric fb = new FXGeneric(this.getWorld(), x, y, z, x2, y2, z2);
        fb.setMaxAge(400 + this.getWorld().field_73012_v.nextInt(100), 0);
        fb.setAlphaF(0.3f, 0.0f);
        fb.setParticles(24, 1, 1);
        fb.setGridSize(8);
        fb.setScale(2.0f, 5.0f);
        fb.setLayer(2);
        fb.setSlowDown(1.0);
        fb.setRotationSpeed(this.getWorld().field_73012_v.nextFloat() * 360.0f, this.getWorld().field_73012_v.nextBoolean() ? -1.0f : 1.0f);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void drawGolemFlyParticles(double x, double y, double z, double x2, double y2, double z2) {
        try {
            FXGeneric fb = new FXGeneric(this.getWorld(), x, y, z, x2, y2, z2);
            fb.setMaxAge(40 + this.getWorld().field_73012_v.nextInt(20), 0);
            fb.setAlphaF(0.2f, 0.0f);
            fb.setParticles(24, 1, 1);
            fb.setGridSize(8);
            fb.setScale(2.0f, 8.0f);
            fb.setLayer(2);
            fb.setSlowDown(1.0);
            fb.setWind(0.001);
            fb.field_70145_X = false;
            fb.setRotationSpeed(this.getWorld().field_73012_v.nextFloat() * 360.0f, this.getWorld().field_73012_v.nextBoolean() ? -1.0f : 1.0f);
            ParticleEngine.instance.addEffect(this.getWorld(), fb);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void drawPollutionParticles(BlockPos p) {
        float x = (float)p.func_177958_n() + 0.2f + this.getWorld().field_73012_v.nextFloat() * 0.6f;
        float y = (float)p.func_177956_o() + 0.2f + this.getWorld().field_73012_v.nextFloat() * 0.6f;
        float z = (float)p.func_177952_p() + 0.2f + this.getWorld().field_73012_v.nextFloat() * 0.6f;
        FXGeneric fb = new FXGeneric(this.getWorld(), x, y, z, (double)(this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.005, 0.02, (double)(this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.005);
        fb.setMaxAge(400 + this.getWorld().field_73012_v.nextInt(100), 0);
        fb.func_70538_b(1.0f, 0.3f, 0.9f);
        fb.setAlphaF(0.5f, 0.0f);
        fb.setParticles(24, 1, 1);
        fb.setGridSize(8);
        fb.setScale(2.0f, 5.0f);
        fb.setLayer(3);
        fb.setSlowDown(1.0);
        fb.setWind(0.001);
        fb.setRotationSpeed(this.getWorld().field_73012_v.nextFloat() * 360.0f, this.getWorld().field_73012_v.nextBoolean() ? -1.0f : 1.0f);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void drawTaintCloudParticles(double x, double y, double z) {
        FXGeneric fb = new FXGeneric(this.getWorld(), x, y, z, 0.0, (double)(-this.getWorld().field_73012_v.nextFloat()) * 0.15, 0.0);
        fb.setMaxAge(32 + this.getWorld().field_73012_v.nextInt(4), 0);
        fb.func_70538_b(1.0f, 0.5f, 1.0f);
        fb.func_82338_g(0.3f);
        fb.setLoop(false);
        fb.setParticles(176, 32, 1);
        fb.setScale(25.0f + 15.0f * this.getWorld().field_73012_v.nextFloat());
        fb.setLayer(3);
        fb.setRotationSpeed(this.getWorld().field_73012_v.nextFloat() * 360.0f, this.getWorld().field_73012_v.nextBoolean() ? -1.0f - this.getWorld().field_73012_v.nextFloat() : 1.0f + this.getWorld().field_73012_v.nextFloat());
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void drawBlockMistParticles(BlockPos p, int c) {
        Block bs = this.getWorld().func_180495_p(p).func_177230_c();
        Color color = new Color(c);
        for (int a = 0; a < this.particleCount(4); ++a) {
            double x = (double)p.func_177958_n() + bs.func_149704_x() + (double)this.getWorld().field_73012_v.nextFloat() * (bs.func_149753_y() - bs.func_149704_x());
            double y = (double)p.func_177956_o() + bs.func_149665_z() + (double)this.getWorld().field_73012_v.nextFloat() * (bs.func_149669_A() - bs.func_149665_z());
            double z = (double)p.func_177952_p() + bs.func_149706_B() + (double)this.getWorld().field_73012_v.nextFloat() * (bs.func_149693_C() - bs.func_149706_B());
            FXGeneric fb = new FXGeneric(this.getWorld(), x, y, z, this.getWorld().field_73012_v.nextGaussian() * 0.005, 0.005, this.getWorld().field_73012_v.nextGaussian() * 0.005);
            fb.setMaxAge(400 + this.getWorld().field_73012_v.nextInt(100), 0);
            fb.func_70538_b((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            fb.setAlphaF(1.0f, 0.0f);
            fb.setParticles(24, 1, 1);
            fb.setGridSize(8);
            fb.setScale(2.0f, 5.0f);
            fb.setLayer(2);
            fb.setSlowDown(1.0);
            fb.setWind(0.001);
            fb.setRotationSpeed(this.getWorld().field_73012_v.nextFloat() * 360.0f, this.getWorld().field_73012_v.nextBoolean() ? -1.0f : 1.0f);
            ParticleEngine.instance.addEffect(this.getWorld(), fb);
        }
    }

    public void drawWispyMotesOnBlock(BlockPos pp, int age) {
        FXWispyOrb fb = new FXWispyOrb(this.getWorld(), (float)pp.func_177958_n() + this.getWorld().field_73012_v.nextFloat(), pp.func_177956_o(), (float)pp.func_177952_p() + this.getWorld().field_73012_v.nextFloat(), 0.0, 0.0, 0.0, age);
        fb.func_82338_g(0.5f);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void drawBlockMistParticlesFlat(BlockPos p, int c) {
        Block bs = this.getWorld().func_180495_p(p).func_177230_c();
        Color color = new Color(c);
        for (int a = 0; a < this.particleCount(3); ++a) {
            double x = (float)p.func_177958_n() + this.getWorld().field_73012_v.nextFloat();
            double y = (float)p.func_177956_o() + this.getWorld().field_73012_v.nextFloat() * 0.125f;
            double z = (float)p.func_177952_p() + this.getWorld().field_73012_v.nextFloat();
            FXGeneric fb = new FXGeneric(this.getWorld(), x, y, z, (double)(this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.005, 0.005, (double)(this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.005);
            fb.setMaxAge(400 + this.getWorld().field_73012_v.nextInt(100), 0);
            fb.func_70538_b((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            fb.setAlphaF(1.0f, 0.0f);
            fb.setParticles(24, 1, 1);
            fb.setGridSize(8);
            fb.setScale(2.0f, 5.0f);
            fb.setLayer(2);
            fb.setSlowDown(1.0);
            fb.setWind(0.001);
            fb.setRotationSpeed(this.getWorld().field_73012_v.nextFloat() * 360.0f, this.getWorld().field_73012_v.nextBoolean() ? -1.0f : 1.0f);
            ParticleEngine.instance.addEffect(this.getWorld(), fb);
        }
    }

    public void crucibleBoil(BlockPos pos, TileCrucible tile, int j) {
        for (int a = 0; a < this.particleCount(1); ++a) {
            FXBubble fb = new FXBubble(this.getWorld(), (float)pos.func_177958_n() + 0.2f + this.getWorld().field_73012_v.nextFloat() * 0.6f, (float)pos.func_177956_o() + 0.1f + tile.getFluidHeight(), (float)pos.func_177952_p() + 0.2f + this.getWorld().field_73012_v.nextFloat() * 0.6f, 0.0, 0.0, 0.0, 3);
            if (tile.aspects.size() == 0) {
                fb.func_70538_b(1.0f, 1.0f, 1.0f);
            } else {
                Color color = new Color(tile.aspects.getAspects()[this.getWorld().field_73012_v.nextInt(tile.aspects.getAspects().length)].getColor());
                fb.func_70538_b((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            }
            fb.bubblespeed = 0.003 * (double)j;
            ParticleEngine.instance.addEffect(this.getWorld(), fb);
        }
    }

    public void drawBamf(BlockPos p, boolean sound, boolean flair, boolean upwards) {
        this.drawBamf((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5, sound, flair, upwards);
    }

    public void drawBamf(BlockPos p, float r, float g, float b, boolean sound, boolean flair, boolean upwards) {
        this.drawBamf((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5, r, g, b, sound, flair, upwards);
    }

    public void drawBamf(BlockPos p, int color, boolean sound, boolean flair, boolean upwards) {
        this.drawBamf((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5, color, sound, flair, upwards);
    }

    public void drawBamf(double x, double y, double z, int color, boolean sound, boolean flair, boolean upwards) {
        Color c = new Color(color);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        this.drawBamf(x, y, z, r, g, b, sound, flair, upwards);
    }

    public void drawBamf(double x, double y, double z, boolean sound, boolean flair, boolean upwards) {
        this.drawBamf(x, y, z, 0.5f, 0.1f, 0.6f, sound, flair, upwards);
    }

    public void drawBamf(double x, double y, double z, float r, float g, float b, boolean sound, boolean flair, boolean upwards) {
        FXGeneric fb2;
        double vz;
        double vy;
        double vx;
        int a;
        if (sound) {
            this.getWorld().func_72980_b(x, y, z, "thaumcraft:poof", 0.4f, 1.0f + (float)this.getWorld().field_73012_v.nextGaussian() * 0.05f, false);
        }
        for (a = 0; a < this.particleCount(3) + this.getWorld().field_73012_v.nextInt(3) + 1; ++a) {
            vx = (0.05f + this.getWorld().field_73012_v.nextFloat() * 0.05f) * (float)(this.getWorld().field_73012_v.nextBoolean() ? -1 : 1);
            vy = (0.05f + this.getWorld().field_73012_v.nextFloat() * 0.05f) * (float)(this.getWorld().field_73012_v.nextBoolean() ? -1 : 1);
            vz = (0.05f + this.getWorld().field_73012_v.nextFloat() * 0.05f) * (float)(this.getWorld().field_73012_v.nextBoolean() ? -1 : 1);
            if (upwards) {
                vy = Math.abs(vy) * (double)(a + 2);
            }
            fb2 = new FXGeneric(this.getWorld(), x + vx * 2.0, y + (upwards ? (double)(-0.5f + this.getWorld().field_73012_v.nextFloat() * 0.1f) : vy * 2.0), z + vz * 2.0, vx / 2.0, vy / 2.0, vz / 2.0);
            fb2.field_70145_X = false;
            fb2.setMaxAge(20 + this.getWorld().field_73012_v.nextInt(15), 0);
            fb2.func_70538_b(MathHelper.func_76131_a((float)(r * (1.0f + (float)this.getWorld().field_73012_v.nextGaussian() * 0.1f)), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)(g * (1.0f + (float)this.getWorld().field_73012_v.nextGaussian() * 0.1f)), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)(b * (1.0f + (float)this.getWorld().field_73012_v.nextGaussian() * 0.1f)), (float)0.0f, (float)1.0f));
            fb2.setAlphaF(1.0f, 0.5f);
            fb2.setParticles(59, 5, 1);
            fb2.setGridSize(8);
            fb2.setScale(3.0f, 4.0f + this.getWorld().field_73012_v.nextFloat() * 3.0f);
            fb2.setLayer(3);
            fb2.setSlowDown(0.7);
            fb2.setRotationSpeed(this.getWorld().field_73012_v.nextFloat() * 360.0f, this.getWorld().field_73012_v.nextBoolean() ? -1.0f : 1.0f);
            ParticleEngine.instance.addEffect(this.getWorld(), fb2);
        }
        if (flair) {
            for (a = 0; a < this.particleCount(3) + this.getWorld().field_73012_v.nextInt(3); ++a) {
                vx = (0.1f + this.getWorld().field_73012_v.nextFloat() * 0.05f) * (float)(this.getWorld().field_73012_v.nextBoolean() ? -1 : 1);
                vy = (0.1f + this.getWorld().field_73012_v.nextFloat() * 0.05f) * (float)(this.getWorld().field_73012_v.nextBoolean() ? -1 : 1);
                vz = (0.1f + this.getWorld().field_73012_v.nextFloat() * 0.05f) * (float)(this.getWorld().field_73012_v.nextBoolean() ? -1 : 1);
                FXWispyOrb fb = new FXWispyOrb(this.getWorld(), x + vx * 2.0, y + vy * 2.0, z + vz * 2.0, vx, vy, vz, 15 + this.getWorld().field_73012_v.nextInt(10));
                fb.func_82338_g(0.5f);
                ParticleEngine.instance.addEffect(this.getWorld(), fb);
            }
            FXGeneric fb = new FXGeneric(this.getWorld(), x, y, z, 0.0, 0.0, 0.0);
            fb.setMaxAge(10, 0);
            fb.func_70538_b(1.0f, 0.9f, 1.0f);
            fb.setAlphaF(1.0f, 0.0f);
            fb.setParticles(37, 1, 1);
            fb.setGridSize(8);
            fb.setScale(10.0f + this.getWorld().field_73012_v.nextFloat() * 2.0f, 0.0f);
            fb.setLayer(2);
            fb.setRotationSpeed(this.getWorld().field_73012_v.nextFloat() * 360.0f, (float)this.getWorld().field_73012_v.nextGaussian());
            ParticleEngine.instance.addEffect(this.getWorld(), fb);
        }
        for (a = 0; a < this.particleCount(flair ? 1 : 0) + this.getWorld().field_73012_v.nextInt(3); ++a) {
            vx = (0.0025f + this.getWorld().field_73012_v.nextFloat() * 0.005f) * (float)(this.getWorld().field_73012_v.nextBoolean() ? -1 : 1);
            vy = (0.0025f + this.getWorld().field_73012_v.nextFloat() * 0.005f) * (float)(this.getWorld().field_73012_v.nextBoolean() ? -1 : 1);
            vz = (0.0025f + this.getWorld().field_73012_v.nextFloat() * 0.005f) * (float)(this.getWorld().field_73012_v.nextBoolean() ? -1 : 1);
            if (upwards) {
                vy = Math.abs(vy);
            }
            fb2 = new FXGeneric(this.getWorld(), x + vx * 5.0, y + vy * 5.0, z + vz * 5.0, vx, vy, vz);
            if (a > 0 && this.getWorld().field_73012_v.nextBoolean()) {
                fb2.func_70082_c(90.0f * (float)this.getWorld().field_73012_v.nextGaussian(), 90.0f * (float)this.getWorld().field_73012_v.nextGaussian());
            }
            fb2.field_70145_X = false;
            fb2.setMaxAge(75 + this.getWorld().field_73012_v.nextInt(75 + 20 * a), 0);
            fb2.setRBGColorF((0.9f + this.getWorld().field_73012_v.nextFloat() * 0.1f + r) / 2.0f, (0.1f + g) / 2.0f, (0.5f + this.getWorld().field_73012_v.nextFloat() * 0.1f + b) / 2.0f, 0.1f + this.getWorld().field_73012_v.nextFloat() * 0.1f, 0.0f, 0.5f + this.getWorld().field_73012_v.nextFloat() * 0.1f);
            fb2.setAlphaF(0.75f, 0.0f);
            fb2.setParticles(28 + this.getWorld().field_73012_v.nextInt(4), 1, 1);
            fb2.setGridSize(8);
            fb2.setScale(5.0f, 10.0f + this.getWorld().field_73012_v.nextFloat() * 4.0f);
            fb2.setLayer(2);
            fb2.setRotationSpeed(this.getWorld().field_73012_v.nextFloat() * 360.0f, this.getWorld().field_73012_v.nextBoolean() ? -3.0f - this.getWorld().field_73012_v.nextFloat() * 3.0f : 3.0f + this.getWorld().field_73012_v.nextFloat() * 3.0f);
            ParticleEngine.instance.addEffect(this.getWorld(), fb2);
        }
    }

    public void pechsCurseTick(double posX, double posY, double posZ) {
        FXGeneric fb2 = new FXGeneric(this.getWorld(), posX, posY, posZ, 0.0, 0.0, 0.0);
        fb2.func_70082_c(90.0f * (float)this.getWorld().field_73012_v.nextGaussian(), 90.0f * (float)this.getWorld().field_73012_v.nextGaussian());
        fb2.field_70145_X = false;
        fb2.setMaxAge(50 + this.getWorld().field_73012_v.nextInt(50), 0);
        fb2.setRBGColorF(0.9f, 0.1f, 0.5f, 0.1f + this.getWorld().field_73012_v.nextFloat() * 0.1f, 0.0f, 0.5f + this.getWorld().field_73012_v.nextFloat() * 0.1f);
        fb2.setAlphaF(0.75f, 0.0f);
        fb2.setParticles(28 + this.getWorld().field_73012_v.nextInt(4), 1, 1);
        fb2.setGridSize(8);
        fb2.setScale(3.0f, 5.0f + this.getWorld().field_73012_v.nextFloat() * 2.0f);
        fb2.setLayer(2);
        fb2.setRotationSpeed(this.getWorld().field_73012_v.nextFloat() * 360.0f, this.getWorld().field_73012_v.nextBoolean() ? -3.0f - this.getWorld().field_73012_v.nextFloat() * 3.0f : 3.0f + this.getWorld().field_73012_v.nextFloat() * 3.0f);
        ParticleEngine.instance.addEffect(this.getWorld(), fb2);
        FXWispyOrb fb = new FXWispyOrb(this.getWorld(), posX, posY, posZ, 0.0, 0.0, 0.0, 10 + this.getWorld().field_73012_v.nextInt(10));
        fb.func_82338_g(0.75f);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void scanHighlight(float x, float y, float z) {
        Color color = new Color(16695840);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        this.drawGenericParticles(x, y, z, 0.0, (double)this.getWorld().field_73012_v.nextFloat() * 0.02, 0.0, r - 0.2f + this.getWorld().field_73012_v.nextFloat() * 0.4f, g - 0.2f + this.getWorld().field_73012_v.nextFloat() * 0.4f, b - 0.2f + this.getWorld().field_73012_v.nextFloat() * 0.4f, 0.9f, false, 15, 1, 1, 5 + this.getWorld().field_73012_v.nextInt(8), this.getWorld().field_73012_v.nextInt(10), 0.6f + this.getWorld().field_73012_v.nextFloat() * 0.4f, 0.0f, 0);
    }

    public void sparkle(float x, float y, float z, int color) {
        if (this.getWorld().field_73012_v.nextInt(6) < this.particleCount(2)) {
            FXSparkle fx = new FXSparkle(this.getWorld(), x, y, z, 1.5f, color, 6);
            fx.field_70145_X = true;
            ParticleEngine.instance.addEffect(this.getWorld(), fx);
        }
    }

    public void ssparkle(float x, float y, float z, int color) {
        if (this.getWorld().field_73012_v.nextInt(6) < this.particleCount(2)) {
            FXSparkle fx = new FXSparkle(this.getWorld(), x, y, z, 0.5f, color, 1);
            fx.field_70145_X = true;
            ParticleEngine.instance.addEffect(this.getWorld(), fx);
        }
    }

    public void sparkle(float x, float y, float z, float size, int color, float gravity) {
        if (this.getWorld() != null && this.getWorld().field_73012_v.nextInt(6) < this.particleCount(2)) {
            FXSparkle fx = new FXSparkle(this.getWorld(), x, y, z, size, color, 6);
            fx.field_70145_X = true;
            fx.setGravity(gravity);
            ParticleEngine.instance.addEffect(this.getWorld(), fx);
        }
    }

    public void visSparkle(int x, int y, int z, int x2, int y2, int z2, int color) {
        FXVisSparkle fb = new FXVisSparkle(this.getWorld(), (float)x + this.getWorld().field_73012_v.nextFloat(), (float)y + this.getWorld().field_73012_v.nextFloat(), (float)z + this.getWorld().field_73012_v.nextFloat(), (double)x2 + 0.4 + (double)(this.getWorld().field_73012_v.nextFloat() * 0.2f), (double)y2 + 0.4 + (double)(this.getWorld().field_73012_v.nextFloat() * 0.2f), (double)z2 + 0.4 + (double)(this.getWorld().field_73012_v.nextFloat() * 0.2f));
        Color c = new Color(color);
        fb.func_70538_b((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void crucibleBubble(float x, float y, float z, float cr, float cg, float cb) {
        FXBubble fb = new FXBubble(this.getWorld(), x, y, z, 0.0, 0.0, 0.0, 1);
        fb.func_70538_b(cr, cg, cb);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void crucibleFroth(float x, float y, float z) {
        FXBubble fb = new FXBubble(this.getWorld(), x, y, z, 0.0, 0.0, 0.0, -4);
        fb.func_70538_b(0.5f, 0.5f, 0.7f);
        fb.setFroth();
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void crucibleFrothDown(float x, float y, float z) {
        FXBubble fb = new FXBubble(this.getWorld(), x, y, z, 0.0, 0.0, 0.0, -4);
        fb.func_70538_b(0.5f, 0.5f, 0.7f);
        fb.setFroth2();
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void splooshFX(Entity e) {
        float f = this.getWorld().field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
        float f1 = this.getWorld().field_73012_v.nextFloat() * 0.5f + 0.5f;
        float f2 = MathHelper.func_76126_a((float)f) * 2.0f * 0.5f * f1;
        float f3 = MathHelper.func_76134_b((float)f) * 2.0f * 0.5f * f1;
        FXBreakingFade fx = new FXBreakingFade(this.getWorld(), e.field_70165_t + (double)f2, e.field_70163_u + (double)(this.getWorld().field_73012_v.nextFloat() * e.field_70131_O), e.field_70161_v + (double)f3, Items.field_151123_aH, 0);
        if (this.getWorld().field_73012_v.nextBoolean()) {
            fx.func_70538_b(0.6f, 0.0f, 0.3f);
            fx.func_82338_g(0.4f);
        } else {
            fx.func_70538_b(0.3f, 0.0f, 0.3f);
            fx.func_82338_g(0.6f);
        }
        fx.setParticleMaxAge((int)(66.0f / (this.getWorld().field_73012_v.nextFloat() * 0.9f + 0.1f)));
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public void fluxRainSplashFX(BlockPos pos) {
        float f = this.getWorld().field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
        float f1 = this.getWorld().field_73012_v.nextFloat() * 0.5f + 0.5f;
        float f2 = MathHelper.func_76126_a((float)f) * 2.0f * 0.5f * f1;
        float f3 = MathHelper.func_76134_b((float)f) * 2.0f * 0.5f * f1;
        FXBreakingFade fx = new FXBreakingFade(this.getWorld(), (double)pos.func_177958_n() + (double)f2 + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + (double)f3 + 0.5, Items.field_151123_aH, 0);
        fx.func_70538_b(1.0f, 0.2f, 1.0f);
        fx.func_82338_g(0.6f);
        fx.setParticleMaxAge((int)(44.0f / (this.getWorld().field_73012_v.nextFloat() * 0.9f + 0.1f)));
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public void taintsplosionFX(Entity e) {
        FXBreakingFade fx = new FXBreakingFade(this.getWorld(), e.field_70165_t, e.field_70163_u + (double)(this.getWorld().field_73012_v.nextFloat() * e.field_70131_O), e.field_70161_v, Items.field_151123_aH);
        if (this.getWorld().field_73012_v.nextBoolean()) {
            fx.func_70538_b(0.6f, 0.0f, 0.3f);
            fx.func_82338_g(0.4f);
        } else {
            fx.func_70538_b(0.3f, 0.0f, 0.3f);
            fx.func_82338_g(0.6f);
        }
        fx.field_70159_w = (float)(Math.random() * 2.0 - 1.0);
        fx.field_70181_x = (float)(Math.random() * 2.0 - 1.0);
        fx.field_70179_y = (float)(Math.random() * 2.0 - 1.0);
        float f = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
        float f1 = MathHelper.func_76133_a((double)(fx.field_70159_w * fx.field_70159_w + fx.field_70181_x * fx.field_70181_x + fx.field_70179_y * fx.field_70179_y));
        fx.field_70159_w = fx.field_70159_w / (double)f1 * (double)f * 0.9640000000596046;
        fx.field_70181_x = fx.field_70181_x / (double)f1 * (double)f * 0.9640000000596046 + (double)0.1f;
        fx.field_70179_y = fx.field_70179_y / (double)f1 * (double)f * 0.9640000000596046;
        fx.setParticleMaxAge((int)(66.0f / (this.getWorld().field_73012_v.nextFloat() * 0.9f + 0.1f)));
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public void tentacleAriseFX(Entity e) {
        int j = 0;
        while ((float)j < 2.0f * e.field_70131_O) {
            float f = this.getWorld().field_73012_v.nextFloat() * (float)Math.PI * e.field_70131_O;
            float f1 = this.getWorld().field_73012_v.nextFloat() * 0.5f + 0.5f;
            float f2 = MathHelper.func_76126_a((float)f) * e.field_70131_O * 0.25f * f1;
            float f3 = MathHelper.func_76134_b((float)f) * e.field_70131_O * 0.25f * f1;
            FXBreakingFade fx = new FXBreakingFade(this.getWorld(), e.field_70165_t + (double)f2, e.field_70163_u, e.field_70161_v + (double)f3, Items.field_151123_aH);
            fx.func_70538_b(0.4f, 0.0f, 0.4f);
            fx.func_82338_g(0.5f);
            fx.setParticleMaxAge((int)(66.0f / (this.getWorld().field_73012_v.nextFloat() * 0.9f + 0.1f)));
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
            if (!this.getWorld().func_175623_d(e.func_180425_c().func_177977_b())) {
                f = this.getWorld().field_73012_v.nextFloat() * (float)Math.PI * e.field_70131_O;
                f1 = this.getWorld().field_73012_v.nextFloat() * 0.5f + 0.5f;
                f2 = MathHelper.func_76126_a((float)f) * e.field_70131_O * 0.25f * f1;
                f3 = MathHelper.func_76134_b((float)f) * e.field_70131_O * 0.25f * f1;
                this.getWorld().func_175688_a(EnumParticleTypes.BLOCK_CRACK, e.field_70165_t + (double)f2, e.field_70163_u, e.field_70161_v + (double)f3, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)this.getWorld().func_180495_p(e.func_180425_c().func_177977_b()))});
            }
            ++j;
        }
    }

    public void slimeJumpFX(Entity e, int i) {
        float f = this.getWorld().field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
        float f1 = this.getWorld().field_73012_v.nextFloat() * 0.5f + 0.5f;
        float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
        float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
        FXBreakingFade fx = new FXBreakingFade(this.getWorld(), e.field_70165_t + (double)f2, (e.func_174813_aQ().field_72338_b + e.func_174813_aQ().field_72337_e) / 2.0, e.field_70161_v + (double)f3, Items.field_151123_aH, 0);
        fx.func_70538_b(0.7f, 0.0f, 1.0f);
        fx.func_82338_g(0.4f);
        fx.setParticleMaxAge((int)(66.0f / (this.getWorld().field_73012_v.nextFloat() * 0.9f + 0.1f)));
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public void taintLandFX(Entity e) {
        float f = this.getWorld().field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
        float f1 = this.getWorld().field_73012_v.nextFloat() * 0.5f + 0.5f;
        float f2 = MathHelper.func_76126_a((float)f) * 2.0f * 0.5f * f1;
        float f3 = MathHelper.func_76134_b((float)f) * 2.0f * 0.5f * f1;
        if (this.getWorld().field_72995_K) {
            FXBreakingFade fx = new FXBreakingFade(this.getWorld(), e.field_70165_t + (double)f2, (e.func_174813_aQ().field_72338_b + e.func_174813_aQ().field_72337_e) / 2.0, e.field_70161_v + (double)f3, Items.field_151123_aH);
            fx.func_70538_b(0.1f, 0.0f, 0.1f);
            fx.func_82338_g(0.4f);
            fx.setParticleMaxAge((int)(66.0f / (this.getWorld().field_73012_v.nextFloat() * 0.9f + 0.1f)));
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public void drawInfusionParticles1(double x, double y, double z, BlockPos pos, Item id, int md) {
        FXBoreParticles fb = new FXBoreParticles(this.getWorld(), x, y, z, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() + 0.5, id, md).getObjectColor(pos);
        fb.func_82338_g(0.3f);
        fb.field_70159_w = (float)this.getWorld().field_73012_v.nextGaussian() * 0.03f;
        fb.field_70181_x = (float)this.getWorld().field_73012_v.nextGaussian() * 0.03f;
        fb.field_70179_y = (float)this.getWorld().field_73012_v.nextGaussian() * 0.03f;
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fb);
    }

    public void drawInfusionParticles2(double x, double y, double z, BlockPos pos, Block id, int md) {
        FXBoreParticles fb = new FXBoreParticles(this.getWorld(), x, y, z, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() + 0.5, id, md).getObjectColor(pos);
        fb.func_82338_g(0.3f);
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fb);
    }

    public void drawInfusionParticles3(double x, double y, double z, int x2, int y2, int z2) {
        FXBoreSparkle fb = new FXBoreSparkle(this.getWorld(), x, y, z, (double)x2 + 0.5, (double)y2 - 0.5, (double)z2 + 0.5);
        fb.func_70538_b(0.4f + this.getWorld().field_73012_v.nextFloat() * 0.2f, 0.2f, 0.6f + this.getWorld().field_73012_v.nextFloat() * 0.3f);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void drawInfusionParticles4(double x, double y, double z, int x2, int y2, int z2) {
        FXBoreSparkle fb = new FXBoreSparkle(this.getWorld(), x, y, z, (double)x2 + 0.5, (double)y2 - 0.5, (double)z2 + 0.5);
        fb.func_70538_b(0.2f, 0.6f + this.getWorld().field_73012_v.nextFloat() * 0.3f, 0.3f);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void drawVentParticles(double x, double y, double z, double x2, double y2, double z2, int color) {
        FXVent fb = new FXVent(this.getWorld(), x, y, z, x2, y2, z2, color);
        fb.func_82338_g(0.4f);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void drawVentParticles(double x, double y, double z, double x2, double y2, double z2, int color, float scale) {
        FXVent fb = new FXVent(this.getWorld(), x, y, z, x2, y2, z2, color);
        fb.func_82338_g(0.4f);
        fb.setScale(scale);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void spark(float x, float y, float z, float size, float r, float g, float b, float a) {
        FXSpark fx = new FXSpark(this.getWorld(), x, y, z, size);
        fx.func_70538_b(r, g, b);
        fx.func_82338_g(a);
        ParticleEngine.instance.addEffect(this.getWorld(), fx);
    }

    public void smokeSpiral(double x, double y, double z, float rad, int start, int miny, int color) {
        FXSmokeSpiral fx = new FXSmokeSpiral(this.getWorld(), x, y, z, rad, start, miny);
        Color c = new Color(color);
        fx.func_70538_b((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
        ParticleEngine.instance.addEffect(this.getWorld(), fx);
    }

    public void wispFX(double posX, double posY, double posZ, float f, float g, float h, float i) {
        FXWisp ef = new FXWisp(this.getWorld(), posX, posY, posZ, f, g, h, i);
        ef.setGravity(0.02f);
        ParticleEngine.instance.addEffect(this.getWorld(), ef);
    }

    public void wispFX2(double posX, double posY, double posZ, float size, int type, boolean shrink, boolean clip, float gravity) {
        FXWisp ef = new FXWisp(this.getWorld(), posX, posY, posZ, size, type);
        ef.setGravity(gravity);
        ef.shrink = shrink;
        ef.field_70145_X = clip;
        ParticleEngine.instance.addEffect(this.getWorld(), ef);
    }

    public void wispFX3(double posX, double posY, double posZ, double posX2, double posY2, double posZ2, float size, int type, boolean shrink, float gravity) {
        FXWisp ef = new FXWisp(this.getWorld(), posX, posY, posZ, posX2, posY2, posZ2, size, type);
        ef.setGravity(gravity);
        ef.shrink = shrink;
        ParticleEngine.instance.addEffect(this.getWorld(), ef);
    }

    public void wispFX4(double posX, double posY, double posZ, Entity target, int type, boolean shrink, float gravity) {
        FXWisp ef = new FXWisp(this.getWorld(), posX, posY, posZ, target, type);
        ef.setGravity(gravity);
        ef.shrink = shrink;
        ParticleEngine.instance.addEffect(this.getWorld(), ef);
    }

    public void wispFX5(double posX, double posY, double posZ, double posX2, double posY2, double posZ2, float size, boolean shrink, float gravity, int color) {
        FXWisp ef = new FXWisp(this.getWorld(), posX, posY, posZ, posX2, posY2, posZ2, size, -1);
        Color c = new Color(color);
        ef.func_70538_b((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
        ef.setGravity(gravity);
        ef.shrink = shrink;
        ParticleEngine.instance.addEffect(this.getWorld(), ef);
    }

    public void wispFXEG(double posX, double posY, double posZ, Entity target) {
        for (int a = 0; a < this.particleCount(1); ++a) {
            FXWispEG ef = new FXWispEG(this.getWorld(), posX, posY, posZ, target);
            ParticleEngine.instance.addEffect(this.getWorld(), ef);
        }
    }

    public void burst(double sx, double sy, double sz, float size) {
        FXBurst ef = new FXBurst(this.getWorld(), sx, sy, sz, size);
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)ef);
    }

    public void excavateFX(BlockPos pos, EntityLivingBase p, int progress) {
        RenderGlobal rg = Minecraft.func_71410_x().field_71438_f;
        rg.func_180441_b(p.func_145782_y(), pos, progress);
    }

    public Object beamCont(EntityLivingBase p, double tx, double ty, double tz, int type, int color, boolean reverse, float endmod, Object input, int impact) {
        FXBeamWand beamcon = null;
        Color c = new Color(color);
        if (input instanceof FXBeamWand) {
            beamcon = (FXBeamWand)((Object)input);
        }
        if (beamcon == null || beamcon.field_70128_L) {
            beamcon = new FXBeamWand(this.getWorld(), p, tx, ty, tz, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 8);
            beamcon.setType(type);
            beamcon.setEndMod(endmod);
            beamcon.setReverse(reverse);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)beamcon);
        } else {
            beamcon.updateBeam(tx, ty, tz);
            beamcon.setEndMod(endmod);
            beamcon.impact = impact;
        }
        return beamcon;
    }

    public Object beamBore(double px, double py, double pz, double tx, double ty, double tz, int type, int color, boolean reverse, float endmod, Object input, int impact) {
        FXBeamBore beamcon = null;
        Color c = new Color(color);
        if (input instanceof FXBeamBore) {
            beamcon = (FXBeamBore)((Object)input);
        }
        if (beamcon == null || beamcon.field_70128_L) {
            beamcon = new FXBeamBore(this.getWorld(), px, py, pz, tx, ty, tz, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 8);
            beamcon.setType(type);
            beamcon.setEndMod(endmod);
            beamcon.setReverse(reverse);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)beamcon);
        } else {
            beamcon.updateBeam(tx, ty, tz);
            beamcon.setEndMod(endmod);
            beamcon.impact = impact;
        }
        return beamcon;
    }

    public void boreDigFx(int x, int y, int z, int x2, int y2, int z2, Block bi, int md) {
        if (this.getWorld().field_73012_v.nextInt(8) == 0) {
            FXBoreSparkle fb = new FXBoreSparkle(this.getWorld(), (float)x + this.getWorld().field_73012_v.nextFloat(), (float)y + this.getWorld().field_73012_v.nextFloat(), (float)z + this.getWorld().field_73012_v.nextFloat(), (double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5);
            ParticleEngine.instance.addEffect(this.getWorld(), fb);
        } else {
            FXBoreParticles fb = new FXBoreParticles(this.getWorld(), (double)((float)x + this.getWorld().field_73012_v.nextFloat()), (double)((float)y + this.getWorld().field_73012_v.nextFloat()), (double)((float)z + this.getWorld().field_73012_v.nextFloat()), (double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5, bi, md);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fb);
        }
    }

    public void essentiaTrailFx(BlockPos p1, BlockPos p2, int count, int color, float scale, int ext) {
        FXEssentiaTrail2 fb = new FXEssentiaTrail2(this.getWorld(), (double)p1.func_177958_n() + 0.5, (double)p1.func_177956_o() + 0.5, (double)p1.func_177952_p() + 0.5, (double)p2.func_177958_n() + 0.5, (double)p2.func_177956_o() + 0.5, (double)p2.func_177952_p() + 0.5, count, color, scale, ext);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void essentiaDropFx(double x, double y, double z, float r, float g, float b, float alpha) {
        FXGeneric fb = new FXGeneric(this.getWorld(), x, y, z, this.getWorld().field_73012_v.nextGaussian() * (double)0.005f, this.getWorld().field_73012_v.nextGaussian() * (double)0.005f, this.getWorld().field_73012_v.nextGaussian() * (double)0.005f);
        fb.setMaxAge(20 + this.getWorld().field_73012_v.nextInt(10), 0);
        fb.func_70538_b(r, g, b);
        fb.func_82338_g(alpha);
        fb.setLoop(false);
        fb.setParticles(25, 1, 1);
        fb.setScale(0.4f + this.getWorld().field_73012_v.nextFloat() * 0.2f, 0.2f);
        fb.setLayer(1);
        fb.setGravity(0.01f);
        fb.setRotationSpeed(0.0f);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void jarSplashFx(double x, double y, double z) {
        FXGeneric fb = new FXGeneric(this.getWorld(), x + this.getWorld().field_73012_v.nextGaussian() * (double)0.1f, y, z + this.getWorld().field_73012_v.nextGaussian() * (double)0.1f, this.getWorld().field_73012_v.nextGaussian() * (double)0.015f, this.getWorld().field_73012_v.nextFloat() * 0.05f, this.getWorld().field_73012_v.nextGaussian() * (double)0.015f);
        fb.setMaxAge(20 + this.getWorld().field_73012_v.nextInt(10), 0);
        Color c = new Color(2650102);
        fb.func_70538_b((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
        fb.func_82338_g(0.5f);
        fb.setLoop(false);
        fb.setParticles(25, 1, 1);
        fb.setScale(0.4f + this.getWorld().field_73012_v.nextFloat() * 0.2f);
        fb.setLayer(1);
        fb.setGravity(0.1f);
        fb.field_70145_X = false;
        fb.setRotationSpeed(0.0f);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void waterTrailFx(BlockPos p1, BlockPos p2, int count, int color, float scale) {
        FXEssentiaTrail2 fb = new FXEssentiaTrail2(this.getWorld(), (double)p1.func_177958_n() + 0.5, (double)p1.func_177956_o() + 0.66, (double)p1.func_177952_p() + 0.5, (double)p2.func_177958_n() + 0.5, (double)p2.func_177956_o() + 0.5, (double)p2.func_177952_p() + 0.5, count, color, scale, 0);
        fb.field_70181_x += 0.2;
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void furnaceLavaFx(int x, int y, int z, int facingX, int facingZ) {
        EntityFX fb = new EntityLavaFX.Factory().func_178902_a(0, this.getWorld(), (double)((float)x + 0.5f + (this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.3f + (float)facingX * 1.0f), (double)((float)y + 0.3f), (double)((float)z + 0.5f + (this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.3f + (float)facingZ * 1.0f), 0.0, 0.0, 0.0, new int[0]);
        fb.field_70181_x = 0.2f * this.getWorld().field_73012_v.nextFloat();
        float qx = facingX == 0 ? (this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.5f : (float)facingX * this.getWorld().field_73012_v.nextFloat();
        float qz = facingZ == 0 ? (this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.5f : (float)facingZ * this.getWorld().field_73012_v.nextFloat();
        fb.field_70159_w = 0.15f * qx;
        fb.field_70179_y = 0.15f * qz;
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a(fb);
    }

    public void blockRunes(double x, double y, double z, float r, float g, float b, int dur, float grav) {
        FXBlockRunes fb = new FXBlockRunes(this.getWorld(), x + 0.5, y + 0.5, z + 0.5, r, g, b, dur);
        fb.setGravity(grav);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void drawSlash(double x, double y, double z, double x2, double y2, double z2, int dur) {
        FXPlane fb = new FXPlane(this.getWorld(), x, y, z, x2, y2, z2, dur);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }

    public void blockWard(double x, double y, double z, EnumFacing side, float f, float f1, float f2) {
        FXBlockWard fb = new FXBlockWard(this.getWorld(), x + 0.5, y + 0.5, z + 0.5, side, f, f1, f2);
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fb);
    }

    public Object swarmParticleFX(Entity targetedEntity, float f1, float f2, float pg) {
        FXSwarm fx = new FXSwarm(this.getWorld(), targetedEntity.field_70165_t + (double)((this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 2.0f), targetedEntity.field_70163_u + (double)((this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 2.0f), targetedEntity.field_70161_v + (double)((this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 2.0f), targetedEntity, 0.8f + this.getWorld().field_73012_v.nextFloat() * 0.2f, this.getWorld().field_73012_v.nextFloat() * 0.4f, 1.0f - this.getWorld().field_73012_v.nextFloat() * 0.2f, f1, f2, pg);
        ParticleEngine.instance.addEffect(this.getWorld(), fx);
        return fx;
    }

    public void bottleTaintBreak(double x, double y, double z) {
        for (int k1 = 0; k1 < 8; ++k1) {
            this.getWorld().func_175688_a(EnumParticleTypes.ITEM_CRACK, x, y, z, this.getWorld().field_73012_v.nextGaussian() * 0.15, this.getWorld().field_73012_v.nextDouble() * 0.2, this.getWorld().field_73012_v.nextGaussian() * 0.15, new int[]{Item.func_150891_b((Item)ItemsTC.bottleTaint)});
        }
        this.getWorld().func_72980_b(x, y, z, "game.potion.smash", 1.0f, this.getWorld().field_73012_v.nextFloat() * 0.1f + 0.9f, false);
    }

    public void arcLightning(double x, double y, double z, double tx, double ty, double tz, float r, float g, float b, float h) {
        FXSparkle ef2 = new FXSparkle(this.getWorld(), tx, ty, tz, tx, ty, tz, 3.0f, 6, 2);
        ef2.setGravity(0.0f);
        ef2.field_70145_X = true;
        ef2.func_70538_b(r, g, b);
        ParticleEngine.instance.addEffect(this.getWorld(), ef2);
        FXArc efa = new FXArc(this.getWorld(), x, y, z, tx, ty, tz, r, g, b, h);
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)efa);
    }

    public void arcBolt(double x, double y, double z, double tx, double ty, double tz, float r, float g, float b) {
        FXSparkle ef2 = new FXSparkle(this.getWorld(), tx, ty, tz, tx, ty, tz, 3.0f, 6, 2);
        ef2.setGravity(0.0f);
        ef2.field_70145_X = true;
        ef2.func_70538_b(r, g, b);
        ParticleEngine.instance.addEffect(this.getWorld(), ef2);
        FXBolt efa = new FXBolt(this.getWorld(), x, y, z, tx, ty, tz, r, g, b);
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)efa);
    }

    public void infusedStoneSparkle(BlockPos pos, int md) {
        int color = 0;
        switch (md) {
            case 1: {
                color = 1;
                break;
            }
            case 2: {
                color = 4;
                break;
            }
            case 3: {
                color = 2;
                break;
            }
            case 4: {
                color = 3;
                break;
            }
            case 5: {
                color = 6;
                break;
            }
            case 6: {
                color = 5;
                break;
            }
            case 7: {
                color = 0;
            }
        }
        for (int a = 0; a < this.particleCount(3); ++a) {
            FXSparkle fx = new FXSparkle(this.getWorld(), (float)pos.func_177958_n() + this.getWorld().field_73012_v.nextFloat(), (float)pos.func_177956_o() + this.getWorld().field_73012_v.nextFloat(), (float)pos.func_177952_p() + this.getWorld().field_73012_v.nextFloat(), 1.75f, color == -1 ? this.getWorld().field_73012_v.nextInt(5) : color, 3 + this.getWorld().field_73012_v.nextInt(3));
            fx.setGravity(0.1f);
            ParticleEngine.instance.addEffect(this.getWorld(), fx);
        }
    }

    public void cultistSpawn(double x, double y, double z, double a, double b, double c) {
        FXGeneric fb = new FXGeneric(this.getWorld(), x, y, z, a, b, c);
        fb.setMaxAge(10 + this.getWorld().field_73012_v.nextInt(10), 0);
        fb.setRBGColorF(1.0f, 1.0f, 1.0f, 0.6f, 0.0f, 0.0f);
        fb.func_82338_g(0.8f);
        fb.setGridSize(16);
        fb.setParticles(160, 6, 1);
        fb.setScale(3.0f + this.getWorld().field_73012_v.nextFloat() * 2.0f);
        fb.setLayer(3);
        ParticleEngine.instance.addEffect(this.getWorld(), fb);
    }
}

