/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.lib.math.Box;
import thaumcraft.client.lib.math.Intersection;
import thaumcraft.client.lib.math.Line;
import thaumcraft.client.lib.math.Vec4;
import thaumcraft.common.Thaumcraft;

public class ClothHandler {
    HashMap<Integer, ClothMesh> clothMeshes = new HashMap();
    Box body = null;
    HashMap<Integer, Long> lastRender = new HashMap();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void livingTick(LivingEvent.LivingUpdateEvent event) {
        if (!event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (event.entity instanceof EntityVillager && this.lastRender.containsKey(event.entity.func_145782_y()) && this.lastRender.get(event.entity.func_145782_y()) + 80L < System.currentTimeMillis()) {
            this.processCapeTick(event.entityLiving, 1.0f);
        }
    }

    private void processCapeTick(EntityLivingBase entity, float timestep) {
        ClothMesh mesh = this.clothMeshes.get(entity.func_145782_y());
        if (mesh == null) {
            mesh = this.createInitialState(entity);
            this.clothMeshes.put(entity.func_145782_y(), mesh);
        }
        this.calculateForces(entity, mesh, timestep);
    }

    public void addLink(ClothMesh mesh, NodeLink link) {
        mesh.links.add(link);
    }

    private ClothMesh createInitialState(EntityLivingBase entity) {
        ClothMesh mesh = new ClothMesh();
        float ew = entity.field_70130_N / 4.0f;
        for (int i = 0; i < 4; ++i) {
            float offset = -(ew * 1.5f) + ew * (float)i;
            double xx = MathHelper.func_76134_b((float)(entity.field_70761_aq / 180.0f * (float)Math.PI)) * offset;
            double zz = MathHelper.func_76126_a((float)(entity.field_70761_aq / 180.0f * (float)Math.PI)) * offset;
            mesh.nodes.add(new ClothNode((xx -= (double)(MathHelper.func_76134_b((float)((entity.field_70761_aq + 90.0f) / 180.0f * (float)Math.PI)) * ew * 1.4f)) + entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O * 0.75, (zz -= (double)(MathHelper.func_76126_a((float)((entity.field_70761_aq + 90.0f) / 180.0f * (float)Math.PI)) * ew * 1.4f)) + entity.field_70161_v, 0.02, 0.0, true));
            this.addLink(mesh, new NodeLink(i + 4, i, 0.1));
        }
        int ind = 4;
        for (int i = 1; i < 5; ++i) {
            for (int q = 0; q < 4; ++q) {
                ClothNode nd = (ClothNode)mesh.nodes.get(q);
                mesh.nodes.add(new ClothNode(nd.pos.x, nd.pos.y - (double)i * 0.2, nd.pos.z, 0.02, -0.02 + (double)((float)i * 0.001f), false));
                if (q < 3) {
                    this.addLink(mesh, new NodeLink(ind + 1, ind, 0.05));
                }
                if (i < 4) {
                    this.addLink(mesh, new NodeLink(ind + 4, ind, 0.04));
                }
                ++ind;
            }
        }
        return mesh;
    }

    private void calculateForces(EntityLivingBase entity, ClothMesh mesh, float timestep) {
        Vec4 direction;
        ClothNode u;
        ClothNode v;
        boolean first = true;
        float ew = entity.field_70130_N / 4.0f;
        double ex = this.interpolateValue(entity.field_70169_q, entity.field_70165_t, UtilsFX.sysPartialTicks);
        double ey = this.interpolateValue(entity.field_70167_r, entity.field_70163_u, UtilsFX.sysPartialTicks) + (double)entity.field_70131_O * 0.75;
        double eb = this.interpolateValue(entity.field_70167_r, entity.field_70163_u, UtilsFX.sysPartialTicks);
        double ez = this.interpolateValue(entity.field_70166_s, entity.field_70161_v, UtilsFX.sysPartialTicks);
        double fx = MathHelper.func_76134_b((float)((entity.field_70761_aq + 90.0f) / 180.0f * (float)Math.PI)) * ew * 1.4f;
        double fz = MathHelper.func_76126_a((float)((entity.field_70761_aq + 90.0f) / 180.0f * (float)Math.PI)) * ew * 1.4f;
        double fx2 = MathHelper.func_76134_b((float)((entity.field_70761_aq - 90.0f) / 180.0f * (float)Math.PI)) * ew * 1.4f;
        double fz2 = MathHelper.func_76126_a((float)((entity.field_70761_aq - 90.0f) / 180.0f * (float)Math.PI)) * ew * 1.4f;
        ArrayList<Vec4> points = new ArrayList<Vec4>();
        float repulsion = 0.1f;
        float stiffness = 9.0f;
        float damping = 0.85f;
        for (int i = 0; i < mesh.nodes.size(); ++i) {
            v = (ClothNode)mesh.nodes.get(i);
            if (i < 4 && v.fixed) {
                float offset = -(ew * 1.5f) + ew * (float)i;
                double xx = MathHelper.func_76134_b((float)(entity.field_70761_aq / 180.0f * (float)Math.PI)) * offset;
                double zz = MathHelper.func_76126_a((float)(entity.field_70761_aq / 180.0f * (float)Math.PI)) * offset;
                v.pos = new Vec4((xx -= fx) + ex, ey, (zz -= fz) + ez);
                if (i == 0 || i == 3) {
                    points.add(new Vec4(v.pos.x, v.pos.y, v.pos.z));
                    points.add(new Vec4(v.pos.x, eb, v.pos.z));
                    points.add(new Vec4(v.pos.x + fx * 2.0, v.pos.y, v.pos.z + fz * 2.0));
                    points.add(new Vec4(v.pos.x + fx * 2.0, eb, v.pos.z + fz * 2.0));
                }
            }
            for (int q = 0; q < mesh.nodes.size(); ++q) {
                if (i == q) continue;
                u = (ClothNode)mesh.nodes.get(q);
                Vec4 d = v.pos.subtract3(u.pos);
                double distance = d.getLength3() + 0.1;
                direction = d.normalize3();
                v.applyForce(direction.multiply3(repulsion).divide3(distance * distance * 0.5));
                u.applyForce(direction.multiply3(repulsion).divide3(distance * distance * -0.5));
            }
        }
        v = null;
        u = null;
        for (NodeLink link : mesh.links) {
            v = (ClothNode)mesh.nodes.get(link.a);
            u = (ClothNode)mesh.nodes.get(link.b);
            if (u == null || v == null) continue;
            Vec4 d = u.pos.subtract3(v.pos);
            double displacement = link.length - d.getLength3();
            direction = d.normalize3();
            v.applyForce(direction.multiply3((double)(stiffness * stiffness) * displacement * displacement * 0.5));
            u.applyForce(direction.multiply3((double)(stiffness * stiffness) * displacement * displacement * -0.5));
        }
        this.body = Box.computeBoundingBox(points);
        for (ClothNode n : mesh.nodes) {
            n.acc = n.acc.add3(0.0, n.g * (double)timestep, 0.0);
            n.vel = n.vel.add3(n.acc.multiply3(timestep)).multiply3(damping);
            n.acc = new Vec4(0.0, 0.0, 0.0);
            if (n.fixed) continue;
            n.pos = n.pos.add3(n.vel.multiply3(timestep));
            this.doCollisions(mesh, n, entity);
        }
        mesh.lastCorners = this.body.getCorners();
    }

    private void doCollisions(ClothMesh mesh, ClothNode node, EntityLivingBase entity) {
        IBlockState block;
        AxisAlignedBB bb;
        Vec3 vv;
        Line line = new Line(node.pos, node.vel);
        Intersection[] is = this.body.intersect(line);
        if (is != null && is.length == 1 && mesh.lastCorners != null) {
            Line line2;
            Intersection[] is2;
            Vec4[] bc = this.body.getCorners();
            double dist = Double.MAX_VALUE;
            int c = -1;
            for (int ic = 0; ic < mesh.lastCorners.length; ++ic) {
                double d;
                if (mesh.lastCorners[ic].equals(bc[ic]) || !((d = node.pos.distanceToSquared3(bc[ic])) < dist)) continue;
                dist = d;
                c = ic;
            }
            if (c >= 0 && (is2 = this.body.intersect(line2 = new Line(node.pos, bc[c].subtract3(mesh.lastCorners[c])))) != null && is2.length == 1) {
                node.pos = is2[0].getIntersectionPoint();
                node.vel = new Vec4(0.0, 0.0, 0.0);
            }
        }
        BlockPos bp = new BlockPos(node.pos.x, node.pos.y, node.pos.z);
        List list = entity.field_70170_p.func_147461_a(new AxisAlignedBB(node.pos.x, node.pos.y, node.pos.z, node.pos.x, node.pos.y, node.pos.z).func_72314_b(0.1, 0.1, 0.1));
        if ((!list.isEmpty() || entity.field_70170_p.func_175665_u(bp)) && (vv = this.pushOutOfBB(entity.field_70170_p, node.pos.x, node.pos.y, node.pos.z, bb = (block = entity.field_70170_p.func_180495_p(bp)).func_177230_c().func_180640_a(entity.field_70170_p, bp, block))) != null) {
            node.pos = new Vec4(vv.field_72450_a, vv.field_72448_b, vv.field_72449_c);
            node.vel = new Vec4(0.0, 0.0, 0.0);
        }
    }

    private Vec3 pushOutOfBB(World worldObj, double x, double y, double z, AxisAlignedBB bb) {
        double mX = x;
        double mY = y;
        double mZ = z;
        BlockPos blockpos = new BlockPos(x, y, z);
        double d0 = x - (double)blockpos.func_177958_n();
        double d1 = y - (double)blockpos.func_177956_o();
        double d2 = z - (double)blockpos.func_177952_p();
        if (bb == null) {
            return null;
        }
        int i = 3;
        double d3 = 9999.0;
        if (!worldObj.func_175665_u(blockpos.func_177976_e()) && d0 < d3) {
            d3 = d0;
            i = 0;
        }
        if (!worldObj.func_175665_u(blockpos.func_177974_f()) && 1.0 - d0 < d3) {
            d3 = 1.0 - d0;
            i = 1;
        }
        if (!worldObj.func_175665_u(blockpos.func_177984_a()) && 1.0 - d1 < d3) {
            d3 = 1.0 - d1;
            i = 3;
        }
        if (!worldObj.func_175665_u(blockpos.func_177978_c()) && d2 < d3) {
            d3 = d2;
            i = 4;
        }
        if (!worldObj.func_175665_u(blockpos.func_177968_d()) && 1.0 - d2 < d3) {
            d3 = 1.0 - d2;
            i = 5;
        }
        float f = worldObj.field_73012_v.nextFloat() * 0.2f + 0.1f;
        if (i == 0) {
            mX = bb.field_72340_a - 0.01;
        }
        if (i == 1) {
            mX = bb.field_72336_d + 0.01;
        }
        if (i == 3) {
            mY = bb.field_72337_e + 0.01;
        }
        if (i == 4) {
            mZ = bb.field_72339_c - 0.01;
        }
        if (i == 5) {
            mZ = bb.field_72334_f + 0.01;
        }
        return new Vec3(mX, mY, mZ);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderLivingPost(RenderLivingEvent.Post event) {
        ClothMesh mc;
        if (!(event.entity instanceof EntityVillager)) {
            return;
        }
        long time = System.currentTimeMillis();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-event.renderer.func_177068_d().field_78730_l), (double)(-event.renderer.func_177068_d().field_78731_m), (double)(-event.renderer.func_177068_d().field_78728_n));
        if (!this.lastRender.containsKey(event.entity.func_145782_y()) || this.lastRender.get(event.entity.func_145782_y()) < time) {
            this.processCapeTick(event.entity, 1.0f);
            this.lastRender.put(event.entity.func_145782_y(), time + 20L);
            if (this.body != null) {
                for (Vec4 corner : this.body.getCorners()) {
                    Thaumcraft.proxy.getFX().ssparkle((float)corner.x, (float)corner.y, (float)corner.z, 1);
                }
            }
        }
        if ((mc = this.clothMeshes.get(event.entity.func_145782_y())) == null) {
            return;
        }
        for (NodeLink link : mc.links) {
            ClothNode vc = (ClothNode)mc.nodes.get(link.a);
            ClothNode uc = (ClothNode)mc.nodes.get(link.b);
            this.drawLine(vc.pos.x, vc.pos.y, vc.pos.z, uc.pos.x, uc.pos.y, uc.pos.z);
        }
        GlStateManager.func_179121_F();
    }

    private double interpolateValue(double start, double end, double pct) {
        return start + (end - start) * pct;
    }

    private void drawLine(double x, double y, double z, double x2, double y2, double z2) {
        Tessellator var12 = Tessellator.func_178181_a();
        GL11.glPushMatrix();
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        var12.func_178180_c().func_181668_a(3, DefaultVertexFormats.field_181706_f);
        var12.func_178180_c().func_181662_b(x, y, z).func_181666_a(0.0f, 0.6f, 0.8f, 1.0f).func_181675_d();
        var12.func_178180_c().func_181662_b(x2, y2, z2).func_181666_a(0.0f, 0.6f, 0.8f, 1.0f).func_181675_d();
        var12.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private class ClothMesh {
        boolean blockPhysics = false;
        ArrayList<Integer> entityPhysics = new ArrayList();
        ClothMesh mesh;
        private IAttachPoint attachPoint;
        private int sizeX;
        private int sizeY;
        private ArrayList<ClothNode> nodes = new ArrayList();
        private ArrayList<NodeLink> links = new ArrayList();
        Vec4[] lastCorners = null;

        private ClothMesh() {
        }
    }

    private class AttachPointEntity
    implements IAttachPoint {
        Vec3 offset;
        EntityLiving entity;

        private AttachPointEntity(Vec3 offset, EntityLiving entity) {
            this.offset = offset;
            this.entity = entity;
        }

        @Override
        public Vec3 getFinalOffset(ClothMesh mesh) {
            double xx = (double)MathHelper.func_76134_b((float)(this.entity.field_70761_aq / 180.0f * (float)Math.PI)) * this.offset.field_72450_a;
            double zz = (double)MathHelper.func_76126_a((float)(this.entity.field_70761_aq / 180.0f * (float)Math.PI)) * this.offset.field_72450_a;
            return new Vec3(xx -= (double)MathHelper.func_76134_b((float)((this.entity.field_70761_aq + 90.0f) / 180.0f * (float)Math.PI)) * this.offset.field_72449_c, this.offset.field_72448_b, zz -= (double)MathHelper.func_76126_a((float)((this.entity.field_70761_aq + 90.0f) / 180.0f * (float)Math.PI)) * this.offset.field_72449_c);
        }
    }

    private class AttachPointBlock
    implements IAttachPoint {
        Vec3 offset;

        private AttachPointBlock(Vec3 offset) {
            this.offset = offset;
        }

        @Override
        public Vec3 getFinalOffset(ClothMesh mesh) {
            return this.offset;
        }
    }

    private static interface IAttachPoint {
        public Vec3 getFinalOffset(ClothMesh var1);
    }

    private class NodeLink {
        int a;
        int b;
        double length;

        private NodeLink(int a, int b, double length) {
            this.a = a;
            this.b = b;
            this.length = length;
        }
    }

    private class ClothNode {
        Vec4 pos;
        Vec4 vel;
        Vec4 acc;
        double mass;
        boolean fixed = false;
        double g = -0.01;

        private ClothNode(double x, double y, double z, double d, double g, boolean fixed) {
            this.pos = new Vec4(x, y, z);
            this.vel = new Vec4(0.0, 0.0, 0.0);
            this.acc = new Vec4(0.0, 0.0, 0.0);
            this.mass = d;
            this.fixed = fixed;
            this.g = g;
        }

        private void applyForce(Vec4 force) {
            this.acc = this.acc.add3(force.multiply3(this.mass));
        }
    }
}

