/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.items.IFocusPicker;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.client.lib.RenderEventHandler;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.wands.WandManager;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

public class HudHandler {
    final ResourceLocation HUD = new ResourceLocation("thaumcraft", "textures/gui/hud.png");
    public static AspectList currentAura = new AspectList();
    HashMap<Integer, AspectList> oldvals = new HashMap();
    long nextsync = 0L;
    DecimalFormat secondsFormatter = new DecimalFormat("#######.#");
    ItemStack lastItem = null;
    int lastCount = 0;
    final ResourceLocation TAGBACK = new ResourceLocation("thaumcraft", "textures/aspects/_back.png");

    @SideOnly(value=Side.CLIENT)
    void renderThaumometerHud(Minecraft mc, Float partialTicks, EntityPlayer player, long time) {
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        int k = sr.func_78326_a();
        int l = sr.func_78328_b();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        mc.field_71446_o.func_110577_a(this.HUD);
        float t = currentAura.getAmount(Aspect.VOID);
        int single = currentAura.getAmount(Aspect.CRYSTAL);
        int m = 0;
        float gap = 0.0f;
        for (Aspect aspect : AspectHelper.getAuraAspects(currentAura).getAspects()) {
            if (aspect == null) continue;
            float a = (float)currentAura.getAmount(aspect) / t;
            if (single > 0) {
                gap = 1.0f - a;
                gap = gap < 0.0f ? 0.0f : (gap *= 64.0f);
            }
            if (!(a > 0.0f)) continue;
            if (a > 1.0f) {
                m = (int)((a - 1.0f) * 64.0f);
                a = 1.0f;
            }
            GL11.glPushMatrix();
            Color c = new Color(aspect.getColor());
            GL11.glColor4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)0.9f);
            GL11.glTranslated((double)5.0, (double)(9.0f + gap), (double)0.0);
            GL11.glScaled((double)1.0, (double)a, (double)1.0);
            UtilsFX.drawTexturedQuad(0, 0, 88, 56, 8, 64, -90.0);
            GL11.glPopMatrix();
            gap += a * 64.0f;
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UtilsFX.drawTexturedQuad(1, 1, 72, 48, 16, 80, -90.0);
        GL11.glPopMatrix();
        if (single > 0) {
            GL11.glPushMatrix();
            UtilsFX.drawTexturedQuad(2, 13 + m, 109, 61, 14, 5, -90.0);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    void renderSanityHud(Minecraft mc, Float partialTicks, EntityPlayer player, long time) {
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        int k = sr.func_78326_a();
        int l = sr.func_78328_b();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        mc.field_71446_o.func_110577_a(this.HUD);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UtilsFX.drawTexturedQuad(1, 1, 152, 0, 20, 76, -90.0);
        GL11.glPopMatrix();
        float tw = Thaumcraft.proxy.getPlayerKnowledge().getWarpTotal(player.func_70005_c_());
        int p = Thaumcraft.proxy.getPlayerKnowledge().getWarpPerm(player.func_70005_c_());
        int s = Thaumcraft.proxy.getPlayerKnowledge().getWarpSticky(player.func_70005_c_());
        int t = Thaumcraft.proxy.getPlayerKnowledge().getWarpTemp(player.func_70005_c_());
        float mod = 1.0f;
        if (tw > 100.0f) {
            mod = 100.0f / tw;
            tw = 100.0f;
        }
        int gap = (int)((100.0f - tw) / 100.0f * 48.0f);
        int wt = (int)((float)t / 100.0f * 48.0f * mod);
        int ws = (int)((float)s / 100.0f * 48.0f * mod);
        if (t > 0) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)0.5f, (float)1.0f, (float)1.0f);
            UtilsFX.drawTexturedQuad(7, 21 + gap, 200, gap, 8, wt + gap, -90.0);
            GL11.glPopMatrix();
        }
        if (s > 0) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)0.75f, (float)0.0f, (float)0.75f, (float)1.0f);
            UtilsFX.drawTexturedQuad(7, 21 + wt + gap, 200, wt + gap, 8, wt + ws + gap, -90.0);
            GL11.glPopMatrix();
        }
        if (p > 0) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)0.5f, (float)0.0f, (float)0.5f, (float)1.0f);
            UtilsFX.drawTexturedQuad(7, 21 + wt + ws + gap, 200, wt + ws + gap, 8, 48, -90.0);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UtilsFX.drawTexturedQuad(1, 1, 176, 0, 20, 76, -90.0);
        GL11.glPopMatrix();
        if (tw >= 100.0f) {
            GL11.glPushMatrix();
            UtilsFX.drawTexturedQuad(1, 1, 216, 0, 20, 16, -90.0);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    void renderChargeMeters(Minecraft mc, float renderTickTime, EntityPlayer player, long time) {
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        int ww = sr.func_78326_a();
        int hh = sr.func_78328_b();
        int start = 0;
        int total = 0;
        if (Config.chargeBarPos == 2) {
            for (RenderEventHandler.ChargeEntry ce : RenderEventHandler.chargedItems.values()) {
                if (ce.time < time - 10000L) continue;
                ++total;
            }
            total *= 10;
        }
        float shift = 1.0f;
        for (RenderEventHandler.ChargeEntry ce : RenderEventHandler.chargedItems.values()) {
            float level = ce.charge * 16.0f;
            shift = 1.0f;
            if (level > 0.0f) {
                if (ce.time < time - 10000L) continue;
                if (ce.time > time - 500L) {
                    shift = (float)(time - ce.time) / 500.0f;
                }
                if (ce.time < time - 9500L) {
                    shift = 1.0f - (float)(time - ce.time - 9500L) / 500.0f;
                }
            }
            mc.field_71446_o.func_110577_a(this.HUD);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3008);
            if (level == 0.0f && player.field_70173_aa / 10 % 2 == 0) {
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            int x = 0;
            int y = 0;
            switch (Config.chargeBarPos) {
                case 0: {
                    x = (int)(-20.0f + 22.0f * shift);
                    y = hh / 2 + 17 + start * 20;
                    break;
                }
                case 1: {
                    x = ww - (int)(-2.0f + 22.0f * shift);
                    y = hh / 2 + 17 + start * 20;
                    break;
                }
                case 2: {
                    x = ww / 2 - 18 - start * 20 + total;
                    y = (int)(-4.0f + 22.0f * shift);
                }
            }
            UtilsFX.drawTexturedQuad(x, y, 144, 99, 16, 3, -91.0);
            UtilsFX.drawTexturedQuad(x, y, 144, 96, Math.round(level), 3, -91.0);
            if (ce.diff != 0) {
                GL11.glBlendFunc((int)770, (int)1);
                float f = (float)(time - ce.tickTime) / 1000.0f;
                int d = Math.round(f * level);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - f));
                if (ce.diff > 0) {
                    UtilsFX.drawTexturedQuad(x + d - 3, y - 2, 160, 94, 5, 7, -91.0);
                } else {
                    UtilsFX.drawTexturedQuad(x - d - 5 + Math.round(level), y - 2, 160, 94, 5, 7, -91.0);
                }
                GL11.glBlendFunc((int)770, (int)771);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3008);
            UtilsFX.renderItemInGUI(x, y - 16, 100, ce.item);
            RenderHelper.func_74520_c();
            GlStateManager.func_179140_f();
            if (hh / 2 + 50 + ++start * 21 <= hh) continue;
            break;
        }
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    void renderCastingWandHud(Minecraft mc, float partialTicks, EntityPlayer player, long time, ItemStack wandstack) {
        IWand wand = (IWand)wandstack.func_77973_b();
        if (this.oldvals.get(player.field_71071_by.field_70461_c) == null) {
            this.oldvals.put(player.field_71071_by.field_70461_c, wand.getAllVis(wandstack));
        } else if (this.nextsync <= time) {
            this.oldvals.put(player.field_71071_by.field_70461_c, wand.getAllVis(wandstack));
            this.nextsync = time + 1000L;
        }
        int short1 = 240;
        int short2 = 240;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)short1 / 1.0f), (float)((float)short2 / 1.0f));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        int k = sr.func_78326_a();
        int l = sr.func_78328_b();
        int dailLocation = Config.dialBottom ? l - 32 : 0;
        GL11.glTranslatef((float)0.0f, (float)dailLocation, (float)-2000.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        mc.field_71446_o.func_110577_a(this.HUD);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        UtilsFX.drawTexturedQuad(0, 0, 0, 0, 64, 64, -90.0);
        GL11.glPopMatrix();
        GL11.glTranslatef((float)16.0f, (float)16.0f, (float)0.0f);
        int max = wand.getMaxVis(wandstack);
        ItemFocusBasic focus = wand.getFocus(wandstack);
        ItemStack focusStack = wand.getFocusStack(wandstack);
        int count = 0;
        AspectList aspects = wand.getAllVis(wandstack);
        for (Aspect aspect : aspects.getAspects()) {
            int amt = aspects.getAmount(aspect);
            GL11.glPushMatrix();
            if (!Config.dialBottom) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glRotatef((float)(-15 + count * 24), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)-32.0f, (float)0.0f);
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int loc = (int)(30.0f * (float)amt / (float)max);
            GL11.glPushMatrix();
            Color ac = new Color(aspect.getColor());
            GL11.glColor4f((float)((float)ac.getRed() / 255.0f), (float)((float)ac.getGreen() / 255.0f), (float)((float)ac.getBlue() / 255.0f), (float)0.8f);
            UtilsFX.drawTexturedQuad(-4, 35 - loc, 104, 0, 8, loc, -90.0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            UtilsFX.drawTexturedQuad(-8, -3, 72, 0, 16, 42, -90.0);
            GL11.glPopMatrix();
            int sh = 0;
            if (focus != null && focus.getVisCost(focusStack).getAmount(aspect) > 0) {
                GL11.glPushMatrix();
                UtilsFX.drawTexturedQuad(-4, -8, 136, 0, 8, 8, -90.0);
                sh = 8;
                GL11.glPopMatrix();
            }
            if (this.oldvals.get(player.field_71071_by.field_70461_c).getAmount(aspect) > amt) {
                GL11.glPushMatrix();
                UtilsFX.drawTexturedQuad(-4, -8 - sh, 128, 0, 8, 8, -90.0);
                GL11.glPopMatrix();
            } else if (this.oldvals.get(player.field_71071_by.field_70461_c).getAmount(aspect) < amt) {
                GL11.glPushMatrix();
                UtilsFX.drawTexturedQuad(-4, -8 - sh, 120, 0, 8, 8, -90.0);
                GL11.glPopMatrix();
            }
            if (player.func_70093_af()) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                String msg = amt + "";
                mc.field_71456_v.func_73731_b(mc.field_71466_p, msg, -32, -4, 0xFFFFFF);
                GL11.glPopMatrix();
                if (focus != null && focus.getVisCost(focusStack).getAmount(aspect) > 0) {
                    float mod = wand.getConsumptionModifier(wandstack, player, aspect, false);
                    GL11.glPushMatrix();
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    msg = "" + this.secondsFormatter.format((float)focus.getVisCost(focusStack).getAmount(aspect) * mod);
                    mc.field_71456_v.func_73731_b(mc.field_71466_p, msg, 8, -4, 0xFFFFFF);
                    GL11.glPopMatrix();
                }
                mc.field_71446_o.func_110577_a(this.HUD);
            }
            GL11.glPopMatrix();
            ++count;
        }
        if (focus != null) {
            IFocusPicker wt;
            ItemStack picked = null;
            if (focus instanceof IFocusPicker && (picked = (wt = (IFocusPicker)((Object)focus)).getPickedBlock(player.field_71071_by.func_70448_g())) != null) {
                this.renderWandTradeHud(partialTicks, player, time, picked);
            }
            if (picked == null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)-24.0f, (float)-24.0f, (float)90.0f);
                RenderHelper.func_74520_c();
                GL11.glDisable((int)2896);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2903);
                GL11.glEnable((int)2896);
                try {
                    mc.func_175599_af().func_180450_b(wand.getFocusStack(wandstack), 16, 16);
                }
                catch (Exception e) {
                    // empty catch block
                }
                GL11.glDisable((int)2896);
                GL11.glPopMatrix();
                float f = WandManager.getCooldown((EntityLivingBase)player);
                if (f > 0.0f) {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)150.0f);
                    GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                    String secs = this.secondsFormatter.format(f) + "s";
                    int w = mc.field_71466_p.func_78256_a(secs) / 2;
                    mc.field_71456_v.func_73731_b(mc.field_71466_p, secs, -w, -4, 0xFFFFFF);
                    GL11.glPopMatrix();
                }
            }
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderWandTradeHud(float partialTicks, EntityPlayer player, long time, ItemStack picked) {
        if (picked == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        int amount = this.lastCount;
        if (this.lastItem == null || player.field_71071_by.field_70459_e || !picked.func_77969_a(this.lastItem)) {
            amount = 0;
            for (ItemStack is : player.field_71071_by.field_70462_a) {
                if (is == null || !is.func_77969_a(picked)) continue;
                amount += is.field_77994_a;
            }
            this.lastItem = picked;
            player.field_71071_by.field_70459_e = false;
        }
        this.lastCount = amount;
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        try {
            mc.func_175599_af().func_180450_b(picked, -8, -8);
        }
        catch (Exception e) {
            // empty catch block
        }
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        String am = "" + amount;
        int sw = mc.field_71466_p.func_78256_a(am);
        GL11.glTranslatef((float)0.0f, (float)(-mc.field_71466_p.field_78288_b), (float)500.0f);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        for (int a = -1; a <= 1; ++a) {
            for (int b = -1; b <= 1; ++b) {
                if (a != 0 && b != 0 || a == 0 && b == 0) continue;
                mc.field_71466_p.func_78276_b(am, a + 16 - sw, b + 24, 0);
            }
        }
        mc.field_71466_p.func_78276_b(am, 16 - sw, 24, 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void renderAspectsInGui(GuiContainer gui, EntityPlayer player) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        ScaledResolution var13 = new ScaledResolution(Minecraft.func_71410_x());
        int var14 = var13.func_78326_a();
        int var15 = var13.func_78328_b();
        int var16 = Mouse.getX() * var14 / mc.field_71443_c;
        int var17 = var15 - Mouse.getY() * var15 / mc.field_71440_d - 1;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        for (int var20 = 0; var20 < gui.field_147002_h.field_75151_b.size(); ++var20) {
            AspectList tags;
            int guiTop;
            int guiLeft;
            Slot var23;
            int xs = UtilsFX.getGuiXSize(gui);
            int ys = UtilsFX.getGuiYSize(gui);
            int shift = 0;
            int shift2 = 0;
            int shiftx = -8;
            int shifty = -8;
            if (gui instanceof InventoryEffectRenderer && !mc.field_71439_g.func_70651_bq().isEmpty()) {
                shift = 160;
                shift2 = 200;
            }
            if (Thaumcraft.instance.aspectShift) {
                shiftx -= 8;
                shifty -= 8;
            }
            if (!this.isMouseOverSlot(var23 = (Slot)gui.field_147002_h.field_75151_b.get(var20), var16, var17, guiLeft = shift + (gui.field_146294_l - xs - shift2) / 2, guiTop = (gui.field_146295_m - ys) / 2) || var23.func_75211_c() == null || (tags = ThaumcraftCraftingManager.getObjectTags(var23.func_75211_c())) == null) continue;
            int x = var16 + 17;
            int y = var17 + 7 - 33;
            GL11.glDisable((int)2929);
            int index = 0;
            if (tags.size() > 0) {
                for (Aspect tag : tags.getAspectsSortedByAmount()) {
                    if (tag == null) continue;
                    x = var16 + 17 + index * 18;
                    y = var17 + 7 - 33;
                    mc.field_71446_o.func_110577_a(this.TAGBACK);
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glTranslated((double)(x + shiftx - 2), (double)(y + shifty - 2), (double)0.0);
                    GL11.glScaled((double)1.25, (double)1.25, (double)0.0);
                    UtilsFX.drawTexturedQuadFull(0, 0, UtilsFX.getGuiZLevel((Gui)gui));
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                    UtilsFX.drawTag(x + shiftx, y + shifty, tag, tags.getAmount(tag), 0, UtilsFX.getGuiZLevel((Gui)gui));
                    ++index;
                }
            }
            GL11.glEnable((int)2929);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private boolean isMouseOverSlot(Slot par1Slot, int par2, int par3, int par4, int par5) {
        int var4 = par4;
        int var5 = par5;
        return (par2 -= var4) >= par1Slot.field_75223_e - 1 && par2 < par1Slot.field_75223_e + 16 + 1 && (par3 -= var5) >= par1Slot.field_75221_f - 1 && par3 < par1Slot.field_75221_f + 16 + 1;
    }
}

