/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.math;

import thaumcraft.client.lib.math.Line;
import thaumcraft.client.lib.math.Vec4;

public final class Plane {
    private final Vec4 n;

    public Plane(Vec4 vec) {
        if (vec == null) {
            throw new IllegalArgumentException();
        }
        if (vec.getLengthSquared3() == 0.0) {
            throw new IllegalArgumentException();
        }
        this.n = vec;
    }

    public Plane(double nx, double ny, double nz, double d) {
        if (nx == 0.0 && ny == 0.0 && nz == 0.0) {
            throw new IllegalArgumentException();
        }
        this.n = new Vec4(nx, ny, nz, d);
    }

    public static Plane fromPoints(Vec4 pa, Vec4 pb, Vec4 pc) {
        if (pa == null || pb == null || pc == null) {
            throw new IllegalArgumentException();
        }
        Vec4 vab = pb.subtract3(pa);
        Vec4 vac = pc.subtract3(pa);
        Vec4 n = vab.cross3(vac);
        double d = -n.dot3(pa);
        return new Plane(n.x, n.y, n.z, d);
    }

    public final Vec4 getNormal() {
        return this.n;
    }

    public final double getDistance() {
        return this.n.w;
    }

    public final Vec4 getVector() {
        return this.n;
    }

    public final Plane normalize() {
        double length = this.n.getLength3();
        if (length == 0.0) {
            return this;
        }
        return new Plane(new Vec4(this.n.x / length, this.n.y / length, this.n.z / length, this.n.w / length));
    }

    public final double dot(Vec4 p) {
        if (p == null) {
            throw new IllegalArgumentException();
        }
        return this.n.x * p.x + this.n.y * p.y + this.n.z * p.z + this.n.w * p.w;
    }

    public Vec4 intersect(Line line) {
        if (line == null) {
            throw new IllegalArgumentException();
        }
        double t = this.intersectDistance(line);
        if (Double.isNaN(t)) {
            return null;
        }
        if (Double.isInfinite(t)) {
            return line.getOrigin();
        }
        return line.getPointAt(t);
    }

    public double intersectDistance(Line line) {
        if (line == null) {
            throw new IllegalArgumentException();
        }
        double ldotv = this.n.dot3(line.getDirection());
        if (ldotv == 0.0) {
            double ldots = this.n.dot4(line.getOrigin());
            if (ldots == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        return -this.n.dot4(line.getOrigin()) / ldotv;
    }

    public Vec4 intersect(Vec4 pa, Vec4 pb) {
        if (pa == null || pb == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (pa.equals(pb)) {
                double d = this.distanceTo(pa);
                if (d == 0.0) {
                    return pa;
                }
                return null;
            }
            Line l = Line.fromSegment(pa, pb);
            double t = this.intersectDistance(l);
            if (Double.isInfinite(t)) {
                return Vec4.INFINITY;
            }
            if (Double.isNaN(t) || t < 0.0 || t > 1.0) {
                return null;
            }
            return l.getPointAt(t);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Vec4[] clip(Vec4 pa, Vec4 pb) {
        if (pa == null || pb == null) {
            throw new IllegalArgumentException();
        }
        if (pa.equals(pb)) {
            return null;
        }
        Line line = Line.fromSegment(pa, pb);
        double ldotv = this.n.dot3(line.getDirection());
        if (ldotv == 0.0) {
            double ldots = this.n.dot4(line.getOrigin());
            if (ldots == 0.0) {
                return new Vec4[]{pa, pb};
            }
            return null;
        }
        double t = -this.n.dot4(line.getOrigin()) / ldotv;
        if (t < 0.0 || t > 1.0) {
            return null;
        }
        Vec4 p = line.getPointAt(t);
        if (ldotv > 0.0) {
            return new Vec4[]{p, pb};
        }
        return new Vec4[]{pa, p};
    }

    public double distanceTo(Vec4 p) {
        return this.n.dot4(p);
    }

    public int onSameSide(Vec4 pa, Vec4 pb) {
        if (pa == null || pb == null) {
            throw new IllegalArgumentException();
        }
        double da = this.distanceTo(pa);
        double db = this.distanceTo(pb);
        if (da < 0.0 && db < 0.0) {
            return -1;
        }
        if (da > 0.0 && db > 0.0) {
            return 1;
        }
        return 0;
    }

    public int onSameSide(Vec4[] pts) {
        int side;
        if (pts == null) {
            throw new IllegalArgumentException();
        }
        double d = this.distanceTo(pts[0]);
        int n = d < 0.0 ? -1 : (side = d > 0.0 ? 1 : 0);
        if (side == 0) {
            return 0;
        }
        for (int i = 1; i < pts.length; ++i) {
            if (pts[i] == null) {
                throw new IllegalArgumentException();
            }
            d = this.distanceTo(pts[i]);
            if (side == -1 && d < 0.0 || side == 1 && d > 0.0) continue;
            return 0;
        }
        return side;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Plane)) {
            return false;
        }
        Plane plane = (Plane)o;
        return !(this.n == null ? plane.n != null : !this.n.equals(plane.n));
    }

    public int hashCode() {
        return this.n != null ? this.n.hashCode() : 0;
    }

    public final String toString() {
        return this.n.toString();
    }
}

