/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.math;

public class Vec4 {
    public static final Vec4 INFINITY = new Vec4(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
    public static final Vec4 ZERO = new Vec4(0.0, 0.0, 0.0, 1.0);
    public static final Vec4 ONE = new Vec4(1.0, 1.0, 1.0, 1.0);
    public static final Vec4 UNIT_X = new Vec4(1.0, 0.0, 0.0, 0.0);
    public static final Vec4 UNIT_NEGATIVE_X = new Vec4(-1.0, 0.0, 0.0, 0.0);
    public static final Vec4 UNIT_Y = new Vec4(0.0, 1.0, 0.0, 0.0);
    public static final Vec4 UNIT_NEGATIVE_Y = new Vec4(0.0, -1.0, 0.0, 0.0);
    public static final Vec4 UNIT_Z = new Vec4(0.0, 0.0, 1.0, 0.0);
    public static final Vec4 UNIT_NEGATIVE_Z = new Vec4(0.0, 0.0, -1.0, 0.0);
    public static final Vec4 UNIT_W = new Vec4(0.0, 0.0, 0.0, 1.0);
    public static final Vec4 UNIT_NEGATIVE_W = new Vec4(0.0, 0.0, 0.0, -1.0);
    public final double x;
    public final double y;
    public final double z;
    public final double w;
    private static final double DEFAULT_W = 1.0;
    private int hashCode;

    public Vec4(double value) {
        this(value, value, value);
    }

    public Vec4(double x, double y) {
        this(x, y, 0.0, 1.0);
    }

    public Vec4(double x, double y, double z) {
        this(x, y, z, 1.0);
    }

    public Vec4(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Vec4 that = (Vec4)obj;
        return this.x == that.x && this.y == that.y && this.z == that.z && this.w == that.w;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            long tmp = Double.doubleToLongBits(this.x);
            int result = (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.y);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.z);
            result = 29 * result + (int)(tmp ^ tmp >>> 32);
            tmp = Double.doubleToLongBits(this.w);
            this.hashCode = result = 29 * result + (int)(tmp ^ tmp >>> 32);
        }
        return this.hashCode;
    }

    public static Vec4 fromDoubleArray(double[] array, int offset, int length) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        if (array.length < offset + length) {
            throw new IllegalArgumentException();
        }
        if (length == 1) {
            return new Vec4(array[offset], 0.0);
        }
        if (length == 2) {
            return new Vec4(array[offset], array[offset + 1]);
        }
        if (length == 3) {
            return new Vec4(array[offset], array[offset + 1], array[offset + 2]);
        }
        return new Vec4(array[offset], array[offset + 1], array[offset + 2], array[offset + 3]);
    }

    public static Vec4 fromFloatArray(float[] array, int offset, int length) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        if (array.length < offset + length) {
            throw new IllegalArgumentException();
        }
        if (length == 2) {
            return new Vec4(array[offset], array[offset + 1], 0.0);
        }
        if (length == 3) {
            return new Vec4(array[offset], array[offset + 1], array[offset + 2]);
        }
        return new Vec4(array[offset], array[offset + 1], array[offset + 2], array[offset + 3]);
    }

    public static Vec4 fromArray2(double[] array, int offset) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        return Vec4.fromDoubleArray(array, offset, 2);
    }

    public static Vec4 fromArray3(double[] array, int offset) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        return Vec4.fromDoubleArray(array, offset, 3);
    }

    public static Vec4 fromArray4(double[] array, int offset) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        return Vec4.fromDoubleArray(array, offset, 4);
    }

    public final double[] toDoubleArray(double[] array, int offset, int length) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        if (array.length < offset + length) {
            throw new IllegalArgumentException();
        }
        array[offset] = this.x;
        if (length > 1) {
            array[offset + 1] = this.y;
        }
        if (length > 2) {
            array[offset + 2] = this.z;
        }
        if (length > 3) {
            array[offset + 3] = this.w;
        }
        return array;
    }

    public final float[] toFloatArray(float[] array, int offset, int length) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        if (array.length < offset + length) {
            throw new IllegalArgumentException();
        }
        array[offset] = (float)this.x;
        array[offset + 1] = (float)this.y;
        if (length > 2) {
            array[offset + 2] = (float)this.z;
        }
        if (length > 3) {
            array[offset + 3] = (float)this.w;
        }
        return array;
    }

    public final double[] toArray2(double[] array, int offset) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        return this.toDoubleArray(array, offset, 2);
    }

    public final double[] toArray3(double[] array, int offset) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        return this.toDoubleArray(array, offset, 3);
    }

    public final double[] toArray4(double[] array, int offset) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        return this.toDoubleArray(array, offset, 4);
    }

    public Vec4 toHomogeneousPoint3() {
        if (this.w == 1.0) {
            return this;
        }
        return new Vec4(this.x, this.y, this.z, 1.0);
    }

    public Vec4 toHomogeneousDirection3() {
        if (this.w == 0.0) {
            return this;
        }
        return new Vec4(this.x, this.y, this.z, 0.0);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.x).append(", ");
        sb.append(this.y).append(", ");
        sb.append(this.z).append(", ");
        sb.append(this.w);
        sb.append(")");
        return sb.toString();
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getW() {
        return this.w;
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    public final double z() {
        return this.z;
    }

    public final double w() {
        return this.w;
    }

    public static Vec4 fromLine3(Vec4 origin, double t, Vec4 direction) {
        if (origin == null || direction == null) {
            throw new IllegalArgumentException();
        }
        return new Vec4(origin.x + direction.x * t, origin.y + direction.y * t, origin.z + direction.z * t);
    }

    public final Vec4 add3(Vec4 vec4) {
        if (vec4 == null) {
            throw new IllegalArgumentException();
        }
        return new Vec4(this.x + vec4.x, this.y + vec4.y, this.z + vec4.z, this.w);
    }

    public final Vec4 add3(double x, double y, double z) {
        return new Vec4(this.x + x, this.y + y, this.z + z, this.w);
    }

    public final Vec4 subtract3(Vec4 vec4) {
        if (vec4 == null) {
            throw new IllegalArgumentException();
        }
        return new Vec4(this.x - vec4.x, this.y - vec4.y, this.z - vec4.z, this.w);
    }

    public final Vec4 subtract3(double x, double y, double z) {
        return new Vec4(this.x - x, this.y - y, this.z - z, this.w);
    }

    public final Vec4 multiply3(double value) {
        return new Vec4(this.x * value, this.y * value, this.z * value, this.w);
    }

    public final Vec4 multiply3(Vec4 vec4) {
        if (vec4 == null) {
            throw new IllegalArgumentException();
        }
        return new Vec4(this.x * vec4.x, this.y * vec4.y, this.z * vec4.z, this.w);
    }

    public final Vec4 divide3(double value) {
        if (value == 0.0) {
            throw new IllegalArgumentException();
        }
        return new Vec4(this.x / value, this.y / value, this.z / value, this.w);
    }

    public final Vec4 divide3(Vec4 vec4) {
        if (vec4 == null) {
            throw new IllegalArgumentException();
        }
        return new Vec4(this.x / vec4.x, this.y / vec4.y, this.z / vec4.z, this.w);
    }

    public final Vec4 getNegative3() {
        return new Vec4(0.0 - this.x, 0.0 - this.y, 0.0 - this.z, this.w);
    }

    public final Vec4 getAbs3() {
        return new Vec4(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public final double getLength3() {
        return Math.sqrt(this.getLengthSquared3());
    }

    public final double getLengthSquared3() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final Vec4 normalize3() {
        double length = this.getLength3();
        if (length == 0.0) {
            return this;
        }
        return new Vec4(this.x / length, this.y / length, this.z / length);
    }

    public final double distanceTo2(Vec4 vec4) {
        if (vec4 == null) {
            throw new IllegalArgumentException();
        }
        double dx = vec4.x - this.x;
        double dy = vec4.y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public final double distanceTo3(Vec4 vec4) {
        if (vec4 == null) {
            throw new IllegalArgumentException();
        }
        return Math.sqrt(this.distanceToSquared3(vec4));
    }

    public final double distanceToSquared3(Vec4 vec4) {
        if (vec4 == null) {
            throw new IllegalArgumentException();
        }
        double result = 0.0;
        double tmp = this.x - vec4.x;
        result += tmp * tmp;
        tmp = this.y - vec4.y;
        result += tmp * tmp;
        tmp = this.z - vec4.z;
        return result += tmp * tmp;
    }

    public final double dot3(Vec4 vec4) {
        if (vec4 == null) {
            throw new IllegalArgumentException();
        }
        return this.x * vec4.x + this.y * vec4.y + this.z * vec4.z;
    }

    public final double dot4(Vec4 vec4) {
        if (vec4 == null) {
            throw new IllegalArgumentException();
        }
        return this.x * vec4.x + this.y * vec4.y + this.z * vec4.z + this.w * vec4.w;
    }

    public final double dotSelf3() {
        return this.dot3(this);
    }

    public final double dotSelf4() {
        return this.dot4(this);
    }

    public final Vec4 cross3(Vec4 vec4) {
        if (vec4 == null) {
            throw new IllegalArgumentException();
        }
        return new Vec4(this.y * vec4.z - this.z * vec4.y, this.z * vec4.x - this.x * vec4.z, this.x * vec4.y - this.y * vec4.x);
    }

    public final Vec4 projectOnto3(Vec4 vec4) {
        if (vec4 == null) {
            throw new IllegalArgumentException();
        }
        double dot = this.dot3(vec4);
        double length = vec4.getLength3();
        if (length != 0.0 && length != 1.0) {
            dot /= length * length;
        }
        return vec4.multiply3(dot);
    }

    public final Vec4 perpendicularTo3(Vec4 vec4) {
        if (vec4 == null) {
            throw new IllegalArgumentException();
        }
        return this.subtract3(this.projectOnto3(vec4));
    }

    public Vec4[] perpendicularVectors() {
        Vec4 v = this;
        Vec4 v1 = v.x <= v.y && v.x <= v.z ? UNIT_X : (v.y <= v.x && v.y <= v.z ? UNIT_Y : UNIT_Z);
        Vec4 va = v.cross3(v1).normalize3();
        Vec4 vb = v.cross3(va).normalize3();
        return new Vec4[]{va, vb};
    }

    public static Vec4 min3(Vec4 value1, Vec4 value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException();
        }
        return new Vec4(value1.x < value2.x ? value1.x : value2.x, value1.y < value2.y ? value1.y : value2.y, value1.z < value2.z ? value1.z : value2.z);
    }

    public static Vec4 max3(Vec4 value1, Vec4 value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException();
        }
        return new Vec4(value1.x > value2.x ? value1.x : value2.x, value1.y > value2.y ? value1.y : value2.y, value1.z > value2.z ? value1.z : value2.z);
    }

    public static Vec4 clamp3(Vec4 vec4, double min, double max) {
        if (vec4 == null) {
            throw new IllegalArgumentException();
        }
        return new Vec4(vec4.x < min ? min : (vec4.x > max ? max : vec4.x), vec4.y < min ? min : (vec4.y > max ? max : vec4.y), vec4.z < min ? min : (vec4.z > max ? max : vec4.z));
    }

    public static Vec4 mix3(double amount, Vec4 value1, Vec4 value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException();
        }
        if (amount < 0.0) {
            return value1;
        }
        if (amount > 1.0) {
            return value2;
        }
        double t1 = 1.0 - amount;
        return new Vec4(value1.x * t1 + value2.x * amount, value1.y * t1 + value2.y * amount, value1.z * t1 + value2.z * amount);
    }

    public static Vec4 computeAveragePoint(Iterable<? extends Vec4> points) {
        if (points == null) {
            throw new IllegalArgumentException();
        }
        int count = 0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double w = 0.0;
        for (Vec4 vec4 : points) {
            if (vec4 == null) continue;
            ++count;
            x += vec4.x;
            y += vec4.y;
            z += vec4.z;
            w += vec4.w;
        }
        if (count == 0) {
            return null;
        }
        return new Vec4(x / (double)count, y / (double)count, z / (double)count, w / (double)count);
    }

    public static double getAverageDistance(Iterable<? extends Vec4> points) {
        if (points == null) {
            throw new IllegalArgumentException();
        }
        double totalDistance = 0.0;
        int count = 0;
        for (Vec4 vec4 : points) {
            for (Vec4 vec42 : points) {
                if (vec4 == vec42) continue;
                double d = vec4.distanceTo3(vec42);
                totalDistance += d;
                ++count;
            }
        }
        return count == 0 ? 0.0 : totalDistance / (double)count;
    }

    public static Vec4[] computeExtrema(Vec4[] points) {
        if (points == null) {
            throw new IllegalArgumentException();
        }
        if (points.length == 0) {
            return null;
        }
        double xmin = points[0].x;
        double ymin = points[0].y;
        double zmin = points[0].z;
        double xmax = xmin;
        double ymax = ymin;
        double zmax = zmin;
        for (int i = 1; i < points.length; ++i) {
            double x = points[i].x;
            if (x > xmax) {
                xmax = x;
            } else if (x < xmin) {
                xmin = x;
            }
            double y = points[i].y;
            if (y > ymax) {
                ymax = y;
            } else if (y < ymin) {
                ymin = y;
            }
            double z = points[i].z;
            if (z > zmax) {
                zmax = z;
                continue;
            }
            if (!(z < zmin)) continue;
            zmin = z;
        }
        return new Vec4[]{new Vec4(xmin, ymin, zmin), new Vec4(xmax, ymax, zmax)};
    }

    public static boolean areColinear(Vec4 a, Vec4 b, Vec4 c) {
        Vec4 bc;
        if (a == null || b == null || c == null) {
            throw new IllegalArgumentException();
        }
        Vec4 ab = b.subtract3(a).normalize3();
        return Math.abs(ab.dot3(bc = c.subtract3(b).normalize3())) > 0.999;
    }
}

