/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.models.block;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import thaumcraft.client.lib.models.MeshLoader;
import thaumcraft.client.lib.models.MeshModel;
import thaumcraft.client.lib.models.block.SmartBlockModel;
import thaumcraft.codechicken.lib.vec.Vector3;
import thaumcraft.common.blocks.basic.BlockPillar;

public class CustomPillarModel
implements IModel {
    public static final ResourceLocation T_NORMAL = new ResourceLocation("Thaumcraft:blocks/pillar_normal");
    public static final ResourceLocation T_ANCIENT = new ResourceLocation("Thaumcraft:blocks/pillar_ancient");
    public static final ResourceLocation T_ELDRITCH = new ResourceLocation("Thaumcraft:blocks/pillar_eldritch");
    ResourceLocation model = new ResourceLocation("Thaumcraft", "models/obj/pillar.obj");
    MeshModel sourceMesh;
    ResourceLocation tex;

    public CustomPillarModel(IResourceManager resourceManager, ResourceLocation ta) {
        this.tex = ta;
        try {
            this.sourceMesh = new MeshLoader().loadFromResource(this.model);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Arrays.asList(this.tex);
    }

    public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedModel(format, bakedTextureGetter);
    }

    public IModelState getDefaultState() {
        return null;
    }

    public class BakedModel
    extends SmartBlockModel {
        public BakedModel(VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            super(false, false, (TextureAtlasSprite)bakedTextureGetter.apply((Object)CustomPillarModel.this.tex), format, bakedTextureGetter);
        }

        public IBakedModel handleBlockState(IBlockState state) {
            MeshModel mm = CustomPillarModel.this.sourceMesh.clone();
            SimpleBakedModel.Builder b = new SimpleBakedModel.Builder((IBakedModel)this, null);
            switch ((EnumFacing)state.func_177229_b((IProperty)BlockPillar.FACING)) {
                case SOUTH: {
                    mm.rotate(Math.toRadians(270.0), new Vector3(0.0, 1.0, 0.0), new Vector3(1.0, 0.0, 0.0));
                    break;
                }
                case NORTH: {
                    mm.rotate(Math.toRadians(90.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, 1.0));
                    break;
                }
                case WEST: {
                    mm.rotate(Math.toRadians(180.0), new Vector3(0.0, 1.0, 0.0), new Vector3(1.0, 0.0, 1.0));
                }
            }
            b.func_177646_a(this.func_177554_e());
            for (BakedQuad quad : mm.bakeModel(this.func_177554_e())) {
                b.func_177648_a(quad);
            }
            return b.func_177645_b();
        }

        public IBakedModel handleItemState(ItemStack stack) {
            return this;
        }
    }
}

