/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common;

import com.google.common.collect.ImmutableList;
import java.io.File;
import net.minecraft.block.BlockDispenser;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.OreDictionaryEntries;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.lib.models.ModelRegistrationHelper;
import thaumcraft.common.CommonProxy;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigAspects;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigEntities;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.config.ConfigRecipes;
import thaumcraft.common.config.ConfigResearch;
import thaumcraft.common.items.BehaviorDispenseAlumetum;
import thaumcraft.common.lib.CreativeTabThaumcraft;
import thaumcraft.common.lib.InternalMethodHandler;
import thaumcraft.common.lib.events.ChunkEvents;
import thaumcraft.common.lib.events.CommandThaumcraft;
import thaumcraft.common.lib.events.CraftingEvents;
import thaumcraft.common.lib.events.EntityEvents;
import thaumcraft.common.lib.events.PlayerEvents;
import thaumcraft.common.lib.events.ServerTickEventsFML;
import thaumcraft.common.lib.events.ToolEvents;
import thaumcraft.common.lib.events.WorldEvents;
import thaumcraft.common.lib.network.EventHandlerNetwork;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.research.PlayerKnowledge;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.CropUtils;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;
import thaumcraft.common.lib.world.biomes.BiomeHandler;
import thaumcraft.common.lib.world.dim.WorldProviderOuter;

@Mod(modid="Thaumcraft", name="Thaumcraft", version="5.2.4", guiFactory="thaumcraft.client.ThaumcraftGuiFactory", dependencies="required-after:Forge@[11.15.1.1738,);required-after:Baubles@[1.1.3.0,)", acceptedMinecraftVersions="[1.8.9]")
public class Thaumcraft {
    public static final String MODID = "Thaumcraft";
    public static final String MODNAME = "Thaumcraft";
    public static final String VERSION = "5.2.4";
    @SidedProxy(clientSide="thaumcraft.client.ClientProxy", serverSide="thaumcraft.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="Thaumcraft")
    public static Thaumcraft instance;
    public WorldEvents worldEvents;
    public ChunkEvents chunkEvents;
    public ServerTickEventsFML serverTickEvents;
    public CraftingEvents craftingEvents;
    public EventHandlerNetwork networkEventHandler;
    ResearchManager researchManager;
    public ThaumcraftWorldGenerator worldGen;
    public PlayerEvents playerEvents;
    public ToolEvents toolEvents;
    public EntityEvents entityEvents;
    public static ModelRegistrationHelper modelRegistrationHelper;
    public File modDir;
    public static final Logger log;
    public static boolean isHalloween;
    public static CreativeTabs tabTC;
    public boolean aspectShift = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().version = VERSION;
        this.modDir = event.getModConfigurationDirectory();
        try {
            Config.initialize(event.getSuggestedConfigurationFile());
        }
        catch (Exception e) {
            log.error("Thaumcraft has a problem loading it's configuration");
        }
        finally {
            if (Config.config != null) {
                Config.save();
            }
        }
        ThaumcraftApi.internalMethods = new InternalMethodHandler();
        this.worldEvents = new WorldEvents();
        this.chunkEvents = new ChunkEvents();
        this.serverTickEvents = new ServerTickEventsFML();
        this.craftingEvents = new CraftingEvents();
        this.playerEvents = new PlayerEvents();
        this.toolEvents = new ToolEvents();
        this.entityEvents = new EntityEvents();
        Thaumcraft.proxy.playerKnowledge = new PlayerKnowledge();
        Thaumcraft.proxy.researchManager = new ResearchManager();
        PacketHandler.init();
        this.networkEventHandler = new EventHandlerNetwork();
        MinecraftForge.EVENT_BUS.register((Object)this.networkEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.serverTickEvents);
        MinecraftForge.EVENT_BUS.register((Object)this.worldEvents);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this.worldEvents);
        MinecraftForge.EVENT_BUS.register((Object)this.chunkEvents);
        MinecraftForge.EVENT_BUS.register((Object)this.playerEvents);
        MinecraftForge.EVENT_BUS.register((Object)this.entityEvents);
        MinecraftForge.EVENT_BUS.register((Object)this.toolEvents);
        GameRegistry.registerFuelHandler((IFuelHandler)this.craftingEvents);
        MinecraftForge.EVENT_BUS.register((Object)this.craftingEvents);
        this.worldGen = new ThaumcraftWorldGenerator();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.worldGen, (int)0);
        Config.save();
        ConfigBlocks.init();
        ConfigItems.preInit();
        ConfigItems.initSeals();
        OreDictionaryEntries.initializeOreDictionary();
        proxy.registerHandlers();
        this.worldGen.initialize();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        FMLCommonHandler.instance().bus().register((Object)instance);
        BiomeHandler.registerBiomes();
        proxy.registerDisplayInformationPreInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        ConfigEntities.init();
        ConfigItems.init();
        proxy.registerDisplayInformationInit();
        BlockDispenser.field_149943_a.func_82595_a((Object)ItemsTC.alumentum, (Object)new BehaviorDispenseAlumetum());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.registerKeyBindings();
        DimensionManager.registerProviderType((int)Config.dimensionOuterId, WorldProviderOuter.class, (boolean)false);
        DimensionManager.registerDimension((int)Config.dimensionOuterId, (int)Config.dimensionOuterId);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        Config.initPotions();
        ConfigEntities.initEntitySpawns();
        Config.initModCompatibility();
        ConfigItems.postInit();
        ConfigRecipes.init();
        ConfigAspects.init();
        ConfigResearch.init();
        Config.initLoot();
        Config.initMisc();
        ImmutableList messages = FMLInterModComms.fetchRuntimeMessages((Object)this);
        for (FMLInterModComms.IMCMessage message : messages) {
            String[] t;
            ItemStack crop;
            if (message.key.equals("portableHoleBlacklist") && message.isStringMessage()) {
                BlockUtils.portableHoleBlackList.add(message.getStringValue());
            }
            if (message.key.equals("harvestStandardCrop") && message.isItemStackMessage()) {
                crop = message.getItemStackValue();
                CropUtils.addStandardCrop(crop, crop.func_77952_i());
            }
            if (message.key.equals("harvestClickableCrop") && message.isItemStackMessage()) {
                crop = message.getItemStackValue();
                CropUtils.addClickableCrop(crop, crop.func_77952_i());
            }
            if (message.key.equals("harvestStackedCrop") && message.isItemStackMessage()) {
                crop = message.getItemStackValue();
                CropUtils.addStackedCrop(crop, crop.func_77952_i());
            }
            if (message.key.equals("nativeCluster") && message.isStringMessage() && (t = message.getStringValue().split(",")) != null && t.length == 5) {
                try {
                    ItemStack ore = new ItemStack(Item.func_150899_d((int)Integer.parseInt(t[0])), 1, Integer.parseInt(t[1]));
                    ItemStack cluster = new ItemStack(Item.func_150899_d((int)Integer.parseInt(t[2])), 1, Integer.parseInt(t[3]));
                    Utils.addSpecialMiningResult(ore, cluster, Float.parseFloat(t[4]));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (message.key.equals("lampBlacklist") && message.isItemStackMessage()) {
                crop = message.getItemStackValue();
                CropUtils.blacklistLamp(crop, crop.func_77952_i());
            }
            if (message.key.equals("dimensionBlacklist") && message.isStringMessage() && (t = message.getStringValue().split(":")) != null && t.length == 2) {
                try {
                    BiomeHandler.addDimBlacklist(Integer.parseInt(t[0]), Integer.parseInt(t[1]));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (message.key.equals("biomeBlacklist") && message.isStringMessage() && (t = message.getStringValue().split(":")) != null && t.length == 2 && BiomeGenBase.func_150568_d((int)Integer.parseInt(t[0])) != null) {
                try {
                    BiomeHandler.addBiomeBlacklist(Integer.parseInt(t[0]), Integer.parseInt(t[1]));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!message.key.equals("championWhiteList") || !message.isStringMessage()) continue;
            try {
                t = message.getStringValue().split(":");
                Class oclass = (Class)EntityList.field_75625_b.get(t[0]);
                if (oclass == null) continue;
                ConfigEntities.championModWhitelist.put(oclass, Integer.parseInt(t[1]));
            }
            catch (Exception e) {
                log.error("Failed to Whitelist [" + message.getStringValue() + "] with [ championWhiteList ] message.");
            }
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandThaumcraft());
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("Thaumcraft")) {
            Config.syncConfigurable();
            if (Config.config != null && Config.config.hasChanged()) {
                Config.save();
            }
        }
    }

    static {
        log = LogManager.getLogger((String)"THAUMCRAFT");
        isHalloween = false;
        tabTC = new CreativeTabThaumcraft(CreativeTabs.getNextID(), "thaumcraft");
    }
}

