/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.basic;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockTC;
import thaumcraft.common.tiles.misc.TileBarrierStone;

public class BlockPavingStone
extends BlockTC {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", PavingStoneType.class);

    public BlockPavingStone() {
        super(Material.field_151576_e);
        this.func_149647_a(Thaumcraft.tabTC);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)PavingStoneType.BARRIER)));
        this.func_149711_c(2.5f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149675_a(true);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177230_c().func_176201_c(state) == 0;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return state.func_177230_c().func_176201_c(state) == 0 ? new TileBarrierStone() : null;
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity e) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (this.func_176201_c(state) == 1 && e instanceof EntityLivingBase) {
            if (worldIn.field_72995_K && worldIn.field_73012_v.nextBoolean()) {
                Thaumcraft.proxy.getFX().drawWispyMotesOnBlock(pos.func_177984_a(), 30);
            } else {
                ((EntityLivingBase)e).func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 40, 1, true, false));
                ((EntityLivingBase)e).func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 40, 0, true, false));
            }
        }
        super.func_176199_a(worldIn, pos, e);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random random) {
        block3: {
            block5: {
                block4: {
                    if (state.func_177230_c().func_176201_c(state) != 0) break block3;
                    if (world.func_175687_A(pos) <= 0) break block4;
                    for (int a = 0; a < Thaumcraft.proxy.getFX().particleCount(2); ++a) {
                        Thaumcraft.proxy.getFX().blockRunes(pos.func_177958_n(), (float)pos.func_177956_o() + 0.7f, pos.func_177952_p(), 0.2f + random.nextFloat() * 0.4f, random.nextFloat() * 0.3f, 0.8f + random.nextFloat() * 0.2f, 20, -0.02f);
                    }
                    break block3;
                }
                if ((world.func_180495_p(pos.func_177981_b(1)) != BlocksTC.barrier.func_176223_P() || !world.func_180495_p(pos.func_177981_b(1)).func_177230_c().func_176205_b((IBlockAccess)world, pos.func_177981_b(1))) && (world.func_180495_p(pos.func_177981_b(2)) != BlocksTC.barrier.func_176223_P() || !world.func_180495_p(pos.func_177981_b(2)).func_177230_c().func_176205_b((IBlockAccess)world, pos.func_177981_b(2)))) break block5;
                for (int a = 0; a < Thaumcraft.proxy.getFX().particleCount(3); ++a) {
                    Thaumcraft.proxy.getFX().blockRunes(pos.func_177958_n(), (float)pos.func_177956_o() + 0.7f, pos.func_177952_p(), 0.9f + random.nextFloat() * 0.1f, random.nextFloat() * 0.3f, random.nextFloat() * 0.3f, 24, -0.02f);
                }
                break block3;
            }
            List list = world.func_72839_b((Entity)null, AxisAlignedBB.func_178781_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)).func_72314_b(1.0, 1.0, 1.0));
            if (list.isEmpty()) break block3;
            for (Entity entity : list) {
                if (!(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer) continue;
                Thaumcraft.proxy.getFX().blockRunes(pos.func_177958_n(), (float)pos.func_177956_o() + 0.6f + random.nextFloat() * Math.max(0.8f, entity.func_70047_e()), pos.func_177952_p(), 0.6f + random.nextFloat() * 0.4f, 0.0f, 0.3f + random.nextFloat() * 0.7f, 20, 0.0f);
                break;
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        return meta < PavingStoneType.values().length ? this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)PavingStoneType.values()[meta])) : this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((PavingStoneType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
        return meta;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public IProperty[] getProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public String getStateName(IBlockState state, boolean fullName) {
        PavingStoneType type = (PavingStoneType)((Object)state.func_177229_b((IProperty)VARIANT));
        return type.func_176610_l() + (fullName ? "_stone" : "");
    }

    public static enum PavingStoneType implements IStringSerializable
    {
        BARRIER,
        TRAVEL;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

