/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.devices;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.common.blocks.BlockTCDevice;
import thaumcraft.common.blocks.IBlockFacing;
import thaumcraft.common.lib.CustomSoundType;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.tiles.devices.TileMirror;
import thaumcraft.common.tiles.devices.TileMirrorEssentia;

public class BlockMirror
extends BlockTCDevice
implements IBlockFacing {
    public BlockMirror(Class cls) {
        super(Material.field_151573_f, cls);
        this.func_149672_a(new CustomSoundType("jar", 1.0f, 1.0f));
        this.func_149711_c(0.1f);
        this.setHarvestLevel(null, 0);
        IBlockState bs = this.field_176227_L.func_177621_b();
        bs.func_177226_a((IProperty)IBlockFacing.FACING, (Comparable)EnumFacing.UP);
        this.func_180632_j(bs);
    }

    @Override
    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState bs = this.func_176223_P();
        bs = bs.func_177226_a((IProperty)IBlockFacing.FACING, (Comparable)facing);
        return bs;
    }

    @Override
    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
    }

    @Override
    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        EnumFacing d = BlockStateUtils.getFacing(state);
        if (!worldIn.func_180495_p(pos.func_177972_a(d.func_176734_d())).func_177230_c().isSideSolid((IBlockAccess)worldIn, pos.func_177972_a(d.func_176734_d()), d)) {
            this.func_176226_b(worldIn, pos, this.func_176223_P(), 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = BlockStateUtils.getFacing(this.func_176201_c(worldIn.func_180495_p(pos)));
        switch (facing.ordinal()) {
            case 0: {
                this.func_149676_a(0.0f, 0.875f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
                break;
            }
            case 2: {
                this.func_149676_a(0.0f, 0.0f, 0.875f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.125f);
                break;
            }
            case 4: {
                this.func_149676_a(0.875f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 1.0f);
            }
        }
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return worldIn.func_180495_p(pos.func_177972_a(side.func_176734_d())).func_177230_c().isSideSolid((IBlockAccess)worldIn, pos.func_177972_a(side.func_176734_d()), side);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        return true;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileMirror || te instanceof TileMirrorEssentia) {
            this.dropMirror(worldIn, pos, state, te);
        } else {
            super.func_180653_a(worldIn, pos, state, chance, fortune);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        if (te instanceof TileMirror || te instanceof TileMirrorEssentia) {
            this.dropMirror(worldIn, pos, state, te);
        } else {
            super.func_180657_a(worldIn, player, pos, state, (TileEntity)null);
        }
    }

    public void dropMirror(World world, BlockPos pos, IBlockState state, TileEntity te) {
        if (this.tileClass == TileMirror.class) {
            TileMirror tm = (TileMirror)te;
            ItemStack drop = new ItemStack((Block)this, 1, 0);
            if (tm != null && tm instanceof TileMirror) {
                if (tm.linked) {
                    drop.func_77964_b(1);
                    drop.func_77983_a("linkX", (NBTBase)new NBTTagInt(tm.linkX));
                    drop.func_77983_a("linkY", (NBTBase)new NBTTagInt(tm.linkY));
                    drop.func_77983_a("linkZ", (NBTBase)new NBTTagInt(tm.linkZ));
                    drop.func_77983_a("linkDim", (NBTBase)new NBTTagInt(tm.linkDim));
                    drop.func_77983_a("dimname", (NBTBase)new NBTTagString(DimensionManager.getProvider((int)tm.func_145831_w().field_73011_w.func_177502_q()).func_80007_l()));
                    tm.invalidateLink();
                }
                BlockMirror.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
        } else {
            TileMirrorEssentia tm = (TileMirrorEssentia)te;
            ItemStack drop = new ItemStack((Block)this, 1, 0);
            if (tm != null && tm instanceof TileMirrorEssentia) {
                if (tm.linked) {
                    drop.func_77964_b(1);
                    drop.func_77983_a("linkX", (NBTBase)new NBTTagInt(tm.linkX));
                    drop.func_77983_a("linkY", (NBTBase)new NBTTagInt(tm.linkY));
                    drop.func_77983_a("linkZ", (NBTBase)new NBTTagInt(tm.linkZ));
                    drop.func_77983_a("linkDim", (NBTBase)new NBTTagInt(tm.linkDim));
                    drop.func_77983_a("dimname", (NBTBase)new NBTTagString(DimensionManager.getProvider((int)tm.func_145831_w().field_73011_w.func_177502_q()).func_80007_l()));
                    tm.invalidateLink();
                }
                BlockMirror.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileMirror taf;
        if (!world.field_72995_K && this.tileClass == TileMirror.class && entity instanceof EntityItem && !entity.field_70128_L && ((EntityItem)entity).field_71088_bW == 0 && (taf = (TileMirror)world.func_175625_s(pos)) != null) {
            taf.transport((EntityItem)entity);
        }
        super.func_180634_a(world, pos, state, entity);
    }
}

