/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.world.taint;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.IBlockFacing;
import thaumcraft.common.blocks.world.taint.BlockTaintLog;
import thaumcraft.common.blocks.world.taint.ITaintBlock;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.CustomSoundType;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.lib.world.biomes.BiomeHandler;

public class BlockTaintFibre
extends Block
implements ITaintBlock {
    public static final IUnlistedProperty<Boolean> NORTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"north"));
    public static final IUnlistedProperty<Boolean> EAST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"east"));
    public static final IUnlistedProperty<Boolean> SOUTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"south"));
    public static final IUnlistedProperty<Boolean> WEST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"west"));
    public static final IUnlistedProperty<Boolean> UP = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"up"));
    public static final IUnlistedProperty<Boolean> DOWN = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"down"));
    public static final IUnlistedProperty<Integer> GROWTH = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"growth", (int)0, (int)4));

    public BlockTaintFibre() {
        super(ThaumcraftMaterials.MATERIAL_TAINT);
        this.func_149711_c(1.0f);
        this.func_149672_a(new CustomSoundType("gore", 0.5f, 0.8f));
        this.func_149675_a(true);
        this.func_149647_a(Thaumcraft.tabTC);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 3;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 3;
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151678_z;
    }

    @Override
    public void die(World world, BlockPos pos, IBlockState blockState) {
        world.func_175698_g(pos);
    }

    protected boolean func_149700_E() {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150899_d((int)0);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if ((state = this.getExtendedState(state, (IBlockAccess)worldIn, pos)) instanceof IExtendedBlockState) {
            if (worldIn.field_73012_v.nextInt(5) <= fortune && ((Integer)((IExtendedBlockState)state).getValue(GROWTH) == 1 || (Integer)((IExtendedBlockState)state).getValue(GROWTH) == 2 || (Integer)((IExtendedBlockState)state).getValue(GROWTH) == 4)) {
                BlockTaintFibre.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ItemsTC.tainted, 1, 1));
            } else if ((Integer)((IExtendedBlockState)state).getValue(GROWTH) == 3) {
                if (worldIn.field_73012_v.nextInt(5) <= fortune) {
                    BlockTaintFibre.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ItemsTC.tainted, 1, 0));
                }
                AuraHelper.pollute(worldIn, pos, 3 + worldIn.field_73012_v.nextInt(3), true);
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K && (state = this.getExtendedState(state, (IBlockAccess)world, pos)) instanceof IExtendedBlockState) {
            if ((Integer)((IExtendedBlockState)state).getValue(GROWTH) == 0 && BlockTaintFibre.isOnlyAdjacentToTaint(world, pos)) {
                this.die(world, pos, state);
            } else if (AuraHelper.getAura(world, pos, Aspect.FLUX) < Config.AURABASE / 25) {
                this.die(world, pos, state);
                Utils.resetBiomeAt(world, pos, world.field_73012_v.nextInt(25) == 0);
            } else {
                BlockTaintFibre.spreadFibres(world, pos);
            }
        }
    }

    public static void spreadFibres(World world, BlockPos pos) {
        if (Config.wuss) {
            return;
        }
        if (AuraHelper.getAura(world, pos, Aspect.FLUX) > Config.AURABASE / 5) {
            int zz;
            int yy;
            int xx;
            BlockPos t;
            if (world.func_180494_b((BlockPos)pos).field_76756_M != Config.biomeTaintID) {
                Utils.setBiomeAt(world, pos, BiomeHandler.biomeTaint, world.field_73012_v.nextInt(10) == 0);
            }
            if ((t = new BlockPos(xx = pos.func_177958_n() + world.field_73012_v.nextInt(3) - 1, yy = pos.func_177956_o() + world.field_73012_v.nextInt(3) - 1, zz = pos.func_177952_p() + world.field_73012_v.nextInt(3) - 1)).equals((Object)pos)) {
                return;
            }
            IBlockState bs = world.func_180495_p(t);
            Material bm = bs.func_177230_c().func_149688_o();
            float bh = bs.func_177230_c().func_176195_g(world, t);
            if (bh < 0.0f || bh > 10.0f) {
                return;
            }
            if (!bs.func_177230_c().isLeaves((IBlockAccess)world, t) && !bm.func_76224_d() && (world.func_175623_d(t) || bs.func_177230_c().func_176200_f(world, t) || bs.func_177230_c() instanceof BlockFlower || bs.func_177230_c() instanceof IPlantable) && BlockUtils.isAdjacentToSolidBlock(world, t) && !BlockTaintFibre.isOnlyAdjacentToTaint(world, t)) {
                if (world.field_73012_v.nextFloat() < Config.taintSpreadRate) {
                    AuraHelper.drainAura(world, t, Aspect.FLUX, 1);
                }
                world.func_175656_a(t, BlocksTC.taintFibre.func_176223_P());
                world.func_175641_c(t, BlocksTC.taintFibre, 1, 0);
                if (world.func_180494_b((BlockPos)t).field_76756_M != Config.biomeTaintID) {
                    Utils.setBiomeAt(world, t, BiomeHandler.biomeTaint);
                }
                return;
            }
            if (bs.func_177230_c().isLeaves((IBlockAccess)world, t)) {
                EnumFacing face = null;
                if ((double)world.field_73012_v.nextFloat() < 0.6 && (face = BlockUtils.getFaceBlockTouching((IBlockAccess)world, t, BlocksTC.taintLog)) != null) {
                    world.func_175656_a(t, BlocksTC.taintFeature.func_176223_P().func_177226_a((IProperty)IBlockFacing.FACING, (Comparable)face.func_176734_d()));
                    if (world.field_73012_v.nextFloat() < Config.taintSpreadRate * 3.0f) {
                        AuraHelper.drainAura(world, t, Aspect.FLUX, 1);
                    }
                } else {
                    if (world.field_73012_v.nextFloat() < Config.taintSpreadRate) {
                        AuraHelper.drainAura(world, t, Aspect.FLUX, 1);
                    }
                    world.func_175656_a(t, BlocksTC.taintFibre.func_176223_P());
                    world.func_175641_c(t, BlocksTC.taintFibre, 1, 0);
                }
                return;
            }
            if (BlockTaintFibre.isHemmedByTaint(world, t)) {
                if (Utils.isWoodLog((IBlockAccess)world, t) && bs.func_177230_c().func_149688_o() != ThaumcraftMaterials.MATERIAL_TAINT) {
                    world.func_175656_a(t, BlocksTC.taintLog.func_176223_P().func_177226_a((IProperty)BlockTaintLog.VARIANT, (Comparable)((Object)BlockTaintLog.LogType.values()[0])).func_177226_a((IProperty)BlockTaintLog.AXIS, (Comparable)BlockUtils.getBlockAxis(world, t)));
                    if (world.field_73012_v.nextFloat() < Config.taintSpreadRate * 2.0f) {
                        AuraHelper.drainAura(world, t, Aspect.FLUX, 1);
                    }
                    return;
                }
                if (bs.func_177230_c() == Blocks.field_150419_aX || bs.func_177230_c() == Blocks.field_150420_aW || bm == Material.field_151572_C || bm == Material.field_151570_A || bm == Material.field_151589_v || bm == Material.field_151583_m || bm == Material.field_151575_d) {
                    world.func_175656_a(t, BlocksTC.taintBlock.func_176203_a(0));
                    world.func_175641_c(t, BlocksTC.taintBlock, 1, 0);
                    if (world.field_73012_v.nextFloat() < Config.taintSpreadRate * 2.0f) {
                        AuraHelper.drainAura(world, t, Aspect.FLUX, 1);
                    }
                    return;
                }
                if (bm == Material.field_151595_p || bm == Material.field_151578_c || bm == Material.field_151577_b || bm == Material.field_151571_B) {
                    world.func_175656_a(t, BlocksTC.taintBlock.func_176203_a(1));
                    world.func_175641_c(t, BlocksTC.taintBlock, 1, 0);
                    if (world.field_73012_v.nextFloat() < Config.taintSpreadRate * 2.0f) {
                        AuraHelper.drainAura(world, t, Aspect.FLUX, 1);
                    }
                    return;
                }
                if (bm == Material.field_151576_e) {
                    world.func_175656_a(t, BlocksTC.taintBlock.func_176203_a(3));
                    world.func_175641_c(t, BlocksTC.taintBlock, 1, 0);
                    if (world.field_73012_v.nextFloat() < Config.taintSpreadRate * 4.0f) {
                        AuraHelper.drainAura(world, t, Aspect.FLUX, 1);
                    }
                    return;
                }
            }
        }
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if ((state = this.getExtendedState(state, (IBlockAccess)worldIn, pos)) instanceof IExtendedBlockState && (Integer)((IExtendedBlockState)state).getValue(GROWTH) == 0 && BlockTaintFibre.isOnlyAdjacentToTaint(worldIn, pos)) {
            worldIn.func_175698_g(pos);
        }
        super.func_176204_a(worldIn, pos, state, neighborBlock);
    }

    public static int getAdjacentTaint(IBlockAccess world, BlockPos pos) {
        int count = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (world.func_180495_p(pos.func_177972_a(dir)).func_177230_c().func_149688_o() == ThaumcraftMaterials.MATERIAL_TAINT) continue;
            ++count;
        }
        return count;
    }

    public static boolean isOnlyAdjacentToTaint(World world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (world.func_175623_d(pos.func_177972_a(dir)) || world.func_180495_p(pos.func_177972_a(dir)).func_177230_c().func_149688_o() == ThaumcraftMaterials.MATERIAL_TAINT || !world.func_180495_p(pos.func_177972_a(dir)).func_177230_c().func_176212_b((IBlockAccess)world, pos.func_177972_a(dir), dir.func_176734_d())) continue;
            return false;
        }
        return true;
    }

    public static boolean isHemmedByTaint(World world, BlockPos pos) {
        int c = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            Block block = world.func_180495_p(pos.func_177972_a(dir)).func_177230_c();
            if (block.func_149688_o() == ThaumcraftMaterials.MATERIAL_TAINT) {
                ++c;
                continue;
            }
            if (world.func_175623_d(pos.func_177972_a(dir))) {
                --c;
                continue;
            }
            if (block.func_149688_o().func_76224_d() || block.func_176212_b((IBlockAccess)world, pos.func_177972_a(dir), dir.func_176734_d())) continue;
            --c;
        }
        return c > 0;
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70662_br() && world.field_73012_v.nextInt(750) == 0) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(PotionFluxTaint.instance.func_76396_c(), 200, 0, false, true));
        }
    }

    public boolean func_180648_a(World worldIn, BlockPos pos, IBlockState state, int eventID, int eventParam) {
        if (eventID == 1) {
            if (worldIn.field_72995_K) {
                worldIn.func_72980_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "thaumcraft:roots", 0.1f, 0.9f + worldIn.field_73012_v.nextFloat() * 0.2f, false);
            }
            return true;
        }
        return super.func_180648_a(worldIn, pos, state, eventID, eventParam);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing o) {
        return false;
    }

    private boolean drawAt(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        Block b = worldIn.func_180495_p(pos).func_177230_c();
        return b != BlocksTC.taintFibre && b != BlocksTC.taintFeature && b.func_176212_b(worldIn, pos, side.func_176734_d());
    }

    public void func_180654_a(IBlockAccess iblockaccess, BlockPos pos) {
        IBlockState state = this.getExtendedState(iblockaccess.func_180495_p(pos), iblockaccess, pos);
        if (state instanceof IExtendedBlockState) {
            int c = 0;
            if (((Boolean)((IExtendedBlockState)state).getValue(UP)).booleanValue()) {
                ++c;
            }
            if (((Boolean)((IExtendedBlockState)state).getValue(DOWN)).booleanValue()) {
                ++c;
            }
            if (((Boolean)((IExtendedBlockState)state).getValue(EAST)).booleanValue()) {
                ++c;
            }
            if (((Boolean)((IExtendedBlockState)state).getValue(WEST)).booleanValue()) {
                ++c;
            }
            if (((Boolean)((IExtendedBlockState)state).getValue(SOUTH)).booleanValue()) {
                ++c;
            }
            if (((Boolean)((IExtendedBlockState)state).getValue(NORTH)).booleanValue()) {
                ++c;
            }
            if (c > 1) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else if ((Integer)((IExtendedBlockState)state).getValue(GROWTH) == 1 || (Integer)((IExtendedBlockState)state).getValue(GROWTH) == 2) {
                this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 0.8f, 0.8f);
            } else if ((Integer)((IExtendedBlockState)state).getValue(GROWTH) == 3) {
                this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 0.375f, 0.8f);
            } else if ((Integer)((IExtendedBlockState)state).getValue(GROWTH) == 4) {
                this.func_149676_a(0.2f, 0.2f, 0.2f, 0.8f, 1.0f, 0.8f);
            } else {
                if (((Boolean)((IExtendedBlockState)state).getValue(UP)).booleanValue()) {
                    this.func_149676_a(0.0f, 0.95f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
                if (((Boolean)((IExtendedBlockState)state).getValue(DOWN)).booleanValue()) {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.05f, 1.0f);
                }
                if (((Boolean)((IExtendedBlockState)state).getValue(EAST)).booleanValue()) {
                    this.func_149676_a(0.95f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
                if (((Boolean)((IExtendedBlockState)state).getValue(WEST)).booleanValue()) {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
                }
                if (((Boolean)((IExtendedBlockState)state).getValue(SOUTH)).booleanValue()) {
                    this.func_149676_a(0.0f, 0.0f, 0.95f, 1.0f, 1.0f, 1.0f);
                }
                if (((Boolean)((IExtendedBlockState)state).getValue(NORTH)).booleanValue()) {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.05f);
                }
            }
        }
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        if (this.drawAt((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.UP)) {
            this.func_149676_a(0.0f, 0.95f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        }
        if (this.drawAt((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.DOWN)) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.05f, 1.0f);
            super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        }
        if (this.drawAt((IBlockAccess)worldIn, pos.func_177974_f(), EnumFacing.EAST)) {
            this.func_149676_a(0.95f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        }
        if (this.drawAt((IBlockAccess)worldIn, pos.func_177976_e(), EnumFacing.WEST)) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
            super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        }
        if (this.drawAt((IBlockAccess)worldIn, pos.func_177968_d(), EnumFacing.SOUTH)) {
            this.func_149676_a(0.0f, 0.0f, 0.95f, 1.0f, 1.0f, 1.0f);
            super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        }
        if (this.drawAt((IBlockAccess)worldIn, pos.func_177978_c(), EnumFacing.NORTH)) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.05f);
            super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        }
    }

    public boolean func_176200_f(World worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        IBlockState state = this.getExtendedState(world.func_180495_p(pos), world, pos);
        if (state instanceof IExtendedBlockState) {
            return (Integer)((IExtendedBlockState)state).getValue(GROWTH) == 3 ? 12 : ((Integer)((IExtendedBlockState)state).getValue(GROWTH) == 2 || (Integer)((IExtendedBlockState)state).getValue(GROWTH) == 4 ? 6 : super.getLightValue(world, pos));
        }
        return super.getLightValue(world, pos);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState retval = (IExtendedBlockState)state;
            boolean d = this.drawAt(world, pos.func_177977_b(), EnumFacing.DOWN);
            boolean u = this.drawAt(world, pos.func_177984_a(), EnumFacing.UP);
            int growth = 0;
            Random r = new Random(pos.func_177986_g());
            int q = r.nextInt(50);
            if (d) {
                if (q < 4) {
                    growth = 1;
                } else if (q == 4 || q == 5) {
                    growth = 2;
                } else if (q == 6) {
                    growth = 3;
                }
            }
            if (u && q > 47) {
                growth = 4;
            }
            return retval.withProperty(UP, (Object)this.drawAt(world, pos.func_177984_a(), EnumFacing.UP)).withProperty(DOWN, (Object)this.drawAt(world, pos.func_177977_b(), EnumFacing.DOWN)).withProperty(NORTH, (Object)this.drawAt(world, pos.func_177978_c(), EnumFacing.NORTH)).withProperty(EAST, (Object)this.drawAt(world, pos.func_177974_f(), EnumFacing.EAST)).withProperty(SOUTH, (Object)this.drawAt(world, pos.func_177968_d(), EnumFacing.SOUTH)).withProperty(WEST, (Object)this.drawAt(world, pos.func_177976_e(), EnumFacing.WEST)).withProperty(GROWTH, (Object)growth);
        }
        return state;
    }

    protected BlockState func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{UP, DOWN, NORTH, EAST, WEST, SOUTH, GROWTH};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }
}

