/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.armor;

import baubles.api.BaublesApi;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.IRepairable;
import thaumcraft.api.items.IRunicArmor;
import thaumcraft.api.items.IVisDiscountGear;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.renderers.models.gear.ModelHoverHarness;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.armor.Hover;
import thaumcraft.common.items.baubles.ItemGirdleHover;
import thaumcraft.common.lib.aura.AuraHandler;

public class ItemThaumostaticHarness
extends ItemArmor
implements IRepairable,
IVisDiscountGear,
IRunicArmor,
IRechargable {
    ModelBiped model = null;

    public ItemThaumostaticHarness(ItemArmor.ArmorMaterial enumarmormaterial, int j, int k) {
        super(enumarmormaterial, j, k);
        this.func_77656_e(400);
        this.func_77637_a(Thaumcraft.tabTC);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this.model == null) {
            this.model = new ModelHoverHarness();
        }
        return this.model;
    }

    @Override
    public int getRunicCharge(ItemStack itemstack) {
        return 0;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "thaumcraft:textures/models/armor/hoverharness.png";
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.RARE;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77969_a(new ItemStack(ItemsTC.ingots, 1, 2)) ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    public int getVisDiscount(ItemStack stack, EntityPlayer player, Aspect aspect) {
        return aspect == Aspect.AIR ? 3 : 1;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!player.field_71075_bZ.field_75098_d) {
            Hover.handleHoverArmor(player, player.field_71071_by.func_70440_f(2));
        }
    }

    @Override
    public Aspect handleRecharge(World world, ItemStack is, BlockPos pos, EntityPlayer player, int amount) {
        if (player == null || !AuraHandler.shouldPreserveAura(world, player, player.func_180425_c(), Aspect.AIR) && !AuraHandler.shouldPreserveAura(world, player, player.func_180425_c(), Aspect.FIRE)) {
            short fuel = 0;
            if (is.func_77942_o()) {
                fuel = is.func_77978_p().func_74765_d("fuel");
            }
            int te = 20;
            if (player != null && BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(3) != null && BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(3).func_77973_b() instanceof ItemGirdleHover) {
                te = 16;
            }
            boolean b = false;
            for (int a = 0; a < amount; ++a) {
                if (fuel >= 6000 || !AuraHandler.drainAura(world, pos, Aspect.AIR, 1, false) || !AuraHandler.drainAura(world, pos, Aspect.FIRE, 1, false)) continue;
                AuraHandler.drainAura(world, pos, Aspect.AIR, 1);
                AuraHandler.drainAura(world, pos, Aspect.FIRE, 1);
                fuel = (short)(fuel + te);
                b = true;
            }
            if (b) {
                fuel = (short)MathHelper.func_76125_a((int)fuel, (int)0, (int)6000);
                is.func_77983_a("fuel", (NBTBase)new NBTTagShort(fuel));
                return world.field_73012_v.nextBoolean() ? Aspect.AIR : Aspect.FIRE;
            }
        }
        return null;
    }

    @Override
    public AspectList getAspectsInChargable(ItemStack is) {
        int fuel = 0;
        if (is.func_77942_o()) {
            fuel = (short)(is.func_77978_p().func_74765_d("fuel") / 20);
        }
        return new AspectList().add(Aspect.FIRE, fuel).add(Aspect.AIR, fuel);
    }

    @Override
    public float getChargeLevel(ItemStack is) {
        short fuel = 0;
        if (is.func_77942_o()) {
            fuel = is.func_77978_p().func_74765_d("fuel");
        }
        return (float)fuel / 6000.0f;
    }
}

