/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.items.IArchitect;
import thaumcraft.api.items.IArchitectExtended;
import thaumcraft.api.items.IFocusPicker;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.lib.events.ServerTickEventsFML;
import thaumcraft.common.lib.utils.BlockUtils;

public class ItemFocusBuilder
extends ItemFocusBasic
implements IArchitectExtended,
IFocusPicker {
    private static final AspectList cost = new AspectList().add(Aspect.AIR, 1).add(Aspect.EARTH, 1).add(Aspect.ORDER, 1);

    public ItemFocusBuilder() {
        super("builder", 8776595);
    }

    @Override
    public boolean onFocusActivation(ItemStack itemstack, World world, EntityLivingBase player, MovingObjectPosition mop, int count) {
        IWand wand = (IWand)itemstack.func_77973_b();
        if (player instanceof EntityPlayer) {
            if (player.func_70093_af() && mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                IBlockState bi = world.func_180495_p(mop.func_178782_a());
                if (!world.field_72995_K && world.func_175625_s(mop.func_178782_a()) == null) {
                    ItemStack isout = new ItemStack(bi.func_177230_c(), 1, bi.func_177230_c().func_176201_c(bi));
                    try {
                        ItemStack is;
                        if (bi.func_177230_c() != Blocks.field_150350_a && (is = BlockUtils.createStackedBlock(bi)) != null) {
                            isout = is.func_77946_l();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.storePickedBlock(itemstack, isout);
                } else {
                    player.func_71038_i();
                }
            } else {
                mop = this.getArchitectMOP(itemstack, world, player);
                ItemStack pb = this.getPickedBlock(itemstack);
                if (pb != null && world.field_72995_K) {
                    player.func_71038_i();
                } else if (pb != null && mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    ArrayList<BlockPos> blocks = this.getArchitectBlocks(itemstack, world, mop.func_178782_a(), mop.field_178784_b, (EntityPlayer)player);
                    for (BlockPos c : blocks) {
                        ServerTickEventsFML.addSwapper(world, c, null, pb, 0, (EntityPlayer)player, ((EntityPlayer)player).field_71071_by.field_70461_c);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void storePickedBlock(ItemStack stack, ItemStack stackout) {
        NBTTagCompound item = new NBTTagCompound();
        stack.func_77983_a("picked", (NBTBase)stackout.func_77955_b(item));
    }

    @Override
    public ItemStack getPickedBlock(ItemStack stack) {
        ItemStack out = null;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("picked")) {
            out = new ItemStack(Blocks.field_150350_a);
            out.func_77963_c(stack.func_77978_p().func_74775_l("picked"));
        }
        return out;
    }

    @Override
    public AspectList getVisCost(ItemStack itemstack) {
        return cost;
    }

    @Override
    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
        }
        return null;
    }

    @Override
    public int getMaxAreaSize(ItemStack focusstack) {
        return 0;
    }

    @Override
    public ArrayList<BlockPos> getArchitectBlocks(ItemStack stack, World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        IWand wand = (IWand)stack.func_77973_b();
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        int l = 0;
        if (side.func_176740_k() == EnumFacing.Axis.X) {
            l = (int)Math.abs((double)pos.func_177958_n() + 0.5 - player.field_70165_t);
        }
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            l = (int)Math.abs((double)pos.func_177956_o() + 0.5 - player.field_70163_u);
        }
        if (side.func_176740_k() == EnumFacing.Axis.Z) {
            l = (int)Math.abs((double)pos.func_177952_p() + 0.5 - player.field_70161_v);
        }
        l = Math.min(l, 16 + this.getUpgradeLevel(wand.getFocusStack(stack), FocusUpgradeType.enlarge) * 8);
        for (int a = 1; a < l; ++a) {
            out.add(pos.func_177967_a(side, a));
        }
        return out;
    }

    @Override
    public boolean showAxis(ItemStack stack, World world, EntityPlayer player, EnumFacing side, IArchitect.EnumAxis axis) {
        return false;
    }

    @Override
    public MovingObjectPosition getArchitectMOP(ItemStack stack, World world, EntityLivingBase player) {
        IWand wand = (IWand)stack.func_77973_b();
        return BlockUtils.getTargetBlock(world, (Entity)player, false, true, 64.0);
    }

    @Override
    public boolean useBlockHighlight(ItemStack stack) {
        return false;
    }
}

