/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.entities.projectile.EntityGrapple;

public class ItemFocusGrapple
extends ItemFocusBasic {
    private static final AspectList cost = new AspectList().add(Aspect.WATER, 10).add(Aspect.AIR, 10);
    public static FocusUpgradeType sticky = new FocusUpgradeType(new ResourceLocation("thaumcraft", "textures/foci/sticky.png"), "focus.upgrade.sticky.name", "focus.upgrade.sticky.text", new AspectList().add(Aspect.TRAP, 1));

    public ItemFocusGrapple() {
        super("grapple", 0x1515FF);
    }

    @Override
    public boolean canBePlacedInTurret() {
        return false;
    }

    @Override
    public int getActivationCooldown(ItemStack focusstack) {
        return 250;
    }

    @Override
    public boolean onFocusActivation(ItemStack itemstack, World world, EntityLivingBase p, MovingObjectPosition mop, int count) {
        IWand wand = (IWand)itemstack.func_77973_b();
        if (!world.field_72995_K) {
            EntityGrapple grapple = new EntityGrapple(world, p, wand.getFocusPotency(itemstack), this.isUpgradedWith(wand.getFocusStack(itemstack), sticky));
            world.func_72838_d((Entity)grapple);
            world.func_72956_a((Entity)grapple, "thaumcraft:ice", 0.3f, 0.8f + world.field_73012_v.nextFloat() * 0.1f);
        }
        p.func_71038_i();
        return true;
    }

    @Override
    public AspectList getVisCost(ItemStack itemstack) {
        return cost;
    }

    @Override
    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, sticky};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
        }
        return null;
    }
}

