/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.projectile.EntityShockOrb;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXZap;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.EntityUtils;

public class ItemFocusShock
extends ItemFocusBasic {
    private static final AspectList costBase = new AspectList().add(Aspect.AIR, 8);
    private static final AspectList costChain = new AspectList().add(Aspect.AIR, 8).add(Aspect.WATER, 8);
    private static final AspectList costGround = new AspectList().add(Aspect.AIR, 8).add(Aspect.EARTH, 8);
    public static FocusUpgradeType chainlightning = new FocusUpgradeType(new ResourceLocation("thaumcraft", "textures/foci/chainlightning.png"), "focus.upgrade.chainlightning.name", "focus.upgrade.chainlightning.text", new AspectList().add(Aspect.ENERGY, 1));
    public static FocusUpgradeType earthshock = new FocusUpgradeType(new ResourceLocation("thaumcraft", "textures/foci/earthshock.png"), "focus.upgrade.earthshock.name", "focus.upgrade.earthshock.text", new AspectList().add(Aspect.ENERGY, 1));

    public ItemFocusShock() {
        super("shock", 10466239);
    }

    @Override
    public boolean canBePlacedInTurret() {
        return true;
    }

    @Override
    public float getTurretCorrection(ItemStack focusstack) {
        return this.isUpgradedWith(focusstack, earthshock) ? 5.0f : 0.0f;
    }

    @Override
    public float getTurretRange(ItemStack focusstack) {
        return 20.0f;
    }

    @Override
    public AspectList getVisCost(ItemStack itemstack) {
        return this.isUpgradedWith(itemstack, chainlightning) ? costChain : (this.isUpgradedWith(itemstack, earthshock) ? costGround : costBase);
    }

    @Override
    public int getActivationCooldown(ItemStack focusstack) {
        return this.isUpgradedWith(focusstack, chainlightning) ? 500 : (this.isUpgradedWith(focusstack, earthshock) ? 1000 : 250);
    }

    @Override
    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack itemstack) {
        return this.isUpgradedWith(itemstack, earthshock) ? ItemFocusBasic.WandFocusAnimation.WAVE : ItemFocusBasic.WandFocusAnimation.CHARGE;
    }

    public static void shootLightning(World world, EntityLivingBase entityplayer, double xx, double yy, double zz, boolean offset) {
        double px = entityplayer.field_70165_t;
        double py = entityplayer.func_174813_aQ().field_72338_b + (double)(entityplayer.field_70131_O / 2.0f) + 0.25;
        double pz = entityplayer.field_70161_v;
        px += (double)(-MathHelper.func_76134_b((float)(entityplayer.field_70177_z / 180.0f * 3.141593f)) * 0.06f);
        py += (double)-0.06f;
        pz += (double)(-MathHelper.func_76126_a((float)(entityplayer.field_70177_z / 180.0f * 3.141593f)) * 0.06f);
        Vec3 vec3d = entityplayer.func_70676_i(1.0f);
        Thaumcraft.proxy.getFX().arcBolt(px += vec3d.field_72450_a * 0.5, py += vec3d.field_72448_b * 0.5, pz += vec3d.field_72449_c * 0.5, xx, yy, zz, 0.5f, 1.0f, 1.0f);
    }

    @Override
    public boolean onFocusActivation(ItemStack itemstack, World world, EntityLivingBase p, MovingObjectPosition movingobjectposition, int count) {
        IWand wand = (IWand)itemstack.func_77973_b();
        if (this.isUpgradedWith(wand.getFocusStack(itemstack), earthshock)) {
            if (!world.field_72995_K) {
                EntityShockOrb orb = new EntityShockOrb(world, p);
                orb.area += this.getUpgradeLevel(wand.getFocusStack(itemstack), FocusUpgradeType.enlarge) * 2;
                orb.damage = (int)((double)orb.damage + (double)wand.getFocusPotency(itemstack) * 1.33);
                world.func_72838_d((Entity)orb);
                world.func_72956_a((Entity)orb, "thaumcraft:zap", 1.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f);
            }
            p.func_71038_i();
        } else {
            this.doLightningBolt(itemstack, p, count);
        }
        return true;
    }

    public void doLightningBolt(ItemStack stack, EntityLivingBase p, int count) {
        IWand wand = (IWand)stack.func_77973_b();
        int potency = wand.getFocusPotency(stack);
        Entity pointedEntity = EntityUtils.getPointedEntity(p.field_70170_p, (Entity)p, 0.0, 20.0, 1.1f);
        if (p.field_70170_p.field_72995_K) {
            int a;
            MovingObjectPosition mop = BlockUtils.getTargetBlock(p.field_70170_p, (Entity)p, false);
            Vec3 v = p.func_70676_i(2.0f);
            double px = p.field_70165_t + v.field_72450_a * 10.0;
            double py = p.func_174813_aQ().field_72338_b + 0.25 + (double)(p.field_70131_O / 2.0f) + v.field_72448_b * 10.0;
            double pz = p.field_70161_v + v.field_72449_c * 10.0;
            if (mop != null) {
                px = mop.field_72307_f.field_72450_a;
                py = mop.field_72307_f.field_72448_b;
                pz = mop.field_72307_f.field_72449_c;
                for (a = 0; a < 5; ++a) {
                    Thaumcraft.proxy.getFX().sparkle((float)px + (p.field_70170_p.field_73012_v.nextFloat() - p.field_70170_p.field_73012_v.nextFloat()) * 0.3f, (float)py + (p.field_70170_p.field_73012_v.nextFloat() - p.field_70170_p.field_73012_v.nextFloat()) * 0.3f, (float)pz + (p.field_70170_p.field_73012_v.nextFloat() - p.field_70170_p.field_73012_v.nextFloat()) * 0.3f, 2.0f + p.field_70170_p.field_73012_v.nextFloat(), 2, 0.05f + p.field_70170_p.field_73012_v.nextFloat() * 0.05f);
                }
            }
            if (pointedEntity != null) {
                px = pointedEntity.field_70165_t;
                py = pointedEntity.func_174813_aQ().field_72338_b + (double)(pointedEntity.field_70131_O / 2.0f);
                pz = pointedEntity.field_70161_v;
                for (a = 0; a < 5; ++a) {
                    Thaumcraft.proxy.getFX().sparkle((float)px + (p.field_70170_p.field_73012_v.nextFloat() - p.field_70170_p.field_73012_v.nextFloat()) * 0.6f, (float)py + (p.field_70170_p.field_73012_v.nextFloat() - p.field_70170_p.field_73012_v.nextFloat()) * 0.6f, (float)pz + (p.field_70170_p.field_73012_v.nextFloat() - p.field_70170_p.field_73012_v.nextFloat()) * 0.6f, 2.0f + p.field_70170_p.field_73012_v.nextFloat(), 2, 0.05f + p.field_70170_p.field_73012_v.nextFloat() * 0.05f);
                }
            }
            ItemFocusShock.shootLightning(p.field_70170_p, p, px, py, pz, true);
        } else {
            p.field_70170_p.func_72908_a(p.field_70165_t, p.field_70163_u, p.field_70161_v, "thaumcraft:shock", 0.25f, 1.0f);
            if (pointedEntity != null && pointedEntity instanceof EntityLivingBase && (!(pointedEntity instanceof EntityPlayer) || MinecraftServer.func_71276_C().func_71219_W())) {
                int cl = this.getUpgradeLevel(wand.getFocusStack(stack), chainlightning) * 2;
                pointedEntity.func_70097_a(DamageSource.func_76354_b((Entity)p, (Entity)p), (float)((cl > 0 ? 6 : 4) + potency));
                if (cl > 0) {
                    cl += this.getUpgradeLevel(wand.getFocusStack(stack), FocusUpgradeType.enlarge) * 2;
                    EntityLivingBase center = (EntityLivingBase)pointedEntity;
                    ArrayList<Integer> targets = new ArrayList<Integer>();
                    targets.add(pointedEntity.func_145782_y());
                    while (cl > 0) {
                        --cl;
                        ArrayList<Entity> list = EntityUtils.getEntitiesInRange(p.field_70170_p, center.field_70165_t, center.field_70163_u, center.field_70161_v, (Entity)p, EntityLivingBase.class, 8.0);
                        double d = Double.MAX_VALUE;
                        Entity closest = null;
                        for (Entity e : list) {
                            double dd;
                            if (targets.contains(e.func_145782_y()) || e.field_70128_L || e instanceof IEntityOwnable && ((IEntityOwnable)e).func_70902_q().equals((Object)p) || e instanceof EntityPlayer && !MinecraftServer.func_71276_C().func_71219_W() || !((dd = e.func_70068_e((Entity)center)) < d)) continue;
                            closest = e;
                            d = dd;
                        }
                        if (closest == null) continue;
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXZap(center.func_145782_y(), closest.func_145782_y()), new NetworkRegistry.TargetPoint(p.field_70170_p.field_73011_w.func_177502_q(), center.field_70165_t, center.field_70163_u, center.field_70161_v, 64.0));
                        targets.add(closest.func_145782_y());
                        closest.func_70097_a(DamageSource.func_76354_b((Entity)p, (Entity)p), (float)(4 + potency));
                        center = (EntityLivingBase)closest;
                    }
                }
            }
        }
    }

    @Override
    public boolean canApplyUpgrade(ItemStack focusstack, EntityPlayer player, FocusUpgradeType type, int rank) {
        return !type.equals(FocusUpgradeType.enlarge) || this.isUpgradedWith(focusstack, chainlightning) || this.isUpgradedWith(focusstack, earthshock);
    }

    @Override
    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, chainlightning, earthshock};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.enlarge};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.enlarge};
            }
        }
        return null;
    }
}

