/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.crafting;

import baubles.api.IBauble;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.research.ResearchHelper;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;

public class InfusionEnchantmentRecipe
extends InfusionRecipe {
    EnumInfusionEnchantment enchantment;

    public InfusionEnchantmentRecipe(EnumInfusionEnchantment ench, AspectList as, Object[] components) {
        super(ench.research, null, 4, as, null, components);
        this.enchantment = ench;
    }

    public InfusionEnchantmentRecipe(InfusionEnchantmentRecipe recipe, ItemStack in) {
        super(recipe.enchantment.research, null, recipe.instability, recipe.aspects, (Object)in, recipe.components);
        this.enchantment = recipe.enchantment;
    }

    @Override
    public boolean matches(ArrayList<ItemStack> input, ItemStack central, World world, EntityPlayer player) {
        if (central == null || this.research != null && this.research[0].length() > 0 && !ResearchHelper.isResearchComplete(player.func_70005_c_(), this.research)) {
            return false;
        }
        if (EnumInfusionEnchantment.getInfusionEnchantmentLevel(central, this.enchantment) >= this.enchantment.maxLevel) {
            return false;
        }
        if (!this.enchantment.toolClasses.contains("all")) {
            String at;
            Multimap itemMods = central.func_111283_C();
            boolean cool = false;
            if (itemMods != null && itemMods.containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()) && this.enchantment.toolClasses.contains("weapon")) {
                cool = true;
            }
            if (!cool && central.func_77973_b() instanceof ItemTool) {
                Set tcs = ((ItemTool)central.func_77973_b()).getToolClasses(central);
                for (String tc : tcs) {
                    if (!this.enchantment.toolClasses.contains(tc)) continue;
                    cool = true;
                    break;
                }
            }
            if (!cool && central.func_77973_b() instanceof ItemArmor) {
                at = "none";
                switch (((ItemArmor)central.func_77973_b()).field_77881_a) {
                    case 0: {
                        at = "helm";
                        break;
                    }
                    case 1: {
                        at = "chest";
                        break;
                    }
                    case 2: {
                        at = "legs";
                        break;
                    }
                    case 3: {
                        at = "boots";
                    }
                }
                if (this.enchantment.toolClasses.contains("armor") || this.enchantment.toolClasses.contains(at)) {
                    cool = true;
                }
            }
            if (!cool && central.func_77973_b() instanceof IBauble) {
                at = "none";
                switch (((IBauble)central.func_77973_b()).getBaubleType(central)) {
                    case AMULET: {
                        at = "amulet";
                        break;
                    }
                    case BELT: {
                        at = "belt";
                        break;
                    }
                    case RING: {
                        at = "ring";
                    }
                }
                if (this.enchantment.toolClasses.contains("bauble") || this.enchantment.toolClasses.contains(at)) {
                    cool = true;
                }
            }
            if (!cool && central.func_77973_b() instanceof IRechargable && this.enchantment.toolClasses.contains("chargable")) {
                cool = true;
            }
            if (!cool) {
                return false;
            }
        }
        ItemStack i2 = null;
        ArrayList<ItemStack> ii = new ArrayList<ItemStack>();
        for (ItemStack is : input) {
            ii.add(is.func_77946_l());
        }
        for (Object comp : this.components) {
            boolean b = false;
            for (int a = 0; a < ii.size(); ++a) {
                i2 = ((ItemStack)ii.get(a)).func_77946_l();
                if (!ThaumcraftApiHelper.areItemStacksEqualForCrafting(i2, comp)) continue;
                ii.remove(a);
                b = true;
                break;
            }
            if (b) continue;
            return false;
        }
        return ii.size() == 0;
    }

    @Override
    public Object getRecipeOutput(EntityPlayer player, ItemStack input, ArrayList<ItemStack> comps) {
        if (input == null) {
            return null;
        }
        ItemStack out = input.func_77946_l();
        int cl = EnumInfusionEnchantment.getInfusionEnchantmentLevel(out, this.enchantment);
        if (cl >= this.enchantment.maxLevel) {
            return null;
        }
        List<EnumInfusionEnchantment> el = EnumInfusionEnchantment.getInfusionEnchantments(input);
        Random rand = new Random(System.nanoTime());
        if (rand.nextInt(10) < el.size()) {
            int base = 1;
            if (input.func_77942_o()) {
                base += input.func_77978_p().func_74771_c("TC.WARP");
            }
            out.func_77983_a("TC.WARP", (NBTBase)new NBTTagByte((byte)base));
        }
        EnumInfusionEnchantment.addInfusionEnchantment(out, this.enchantment, cl + 1);
        return out;
    }

    @Override
    public AspectList getAspects(EntityPlayer player, ItemStack input, ArrayList<ItemStack> comps) {
        AspectList out = new AspectList();
        if (input == null) {
            return out;
        }
        int cl = EnumInfusionEnchantment.getInfusionEnchantmentLevel(input, this.enchantment) + 1;
        if (cl > this.enchantment.maxLevel) {
            return out;
        }
        List<EnumInfusionEnchantment> el = EnumInfusionEnchantment.getInfusionEnchantments(input);
        int otherEnchantments = el.size();
        if (el.contains((Object)this.enchantment)) {
            --otherEnchantments;
        }
        float modifier = (float)cl + (float)otherEnchantments * 0.33f;
        for (Aspect a : this.getAspects().getAspects()) {
            out.add(a, (int)((float)this.getAspects().getAmount(a) * modifier));
        }
        return out;
    }
}

