/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import baubles.api.BaublesApi;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.IRepairable;
import thaumcraft.api.items.IRepairableExtended;
import thaumcraft.api.items.IRunicArmor;
import thaumcraft.api.items.IVisDiscountGear;
import thaumcraft.api.items.IWarpingGear;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.armor.Hover;
import thaumcraft.common.items.armor.ItemThaumostaticHarness;
import thaumcraft.common.items.baubles.ItemAmuletRunic;
import thaumcraft.common.items.baubles.ItemGirdleRunic;
import thaumcraft.common.items.baubles.ItemRingRunic;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;
import thaumcraft.common.lib.events.WarpEvents;
import thaumcraft.common.lib.potions.PotionDeathGaze;
import thaumcraft.common.lib.potions.PotionUnnaturalHunger;
import thaumcraft.common.lib.potions.PotionWarpWard;
import thaumcraft.common.lib.research.ResearchManager;

public class PlayerEvents {
    static HashMap<Integer, Long> nextCycle = new HashMap();
    static HashMap<Integer, Integer> lastCharge = new HashMap();
    static HashMap<Integer, Integer> lastMaxCharge = new HashMap();
    static HashMap<Integer, Integer[]> runicInfo = new HashMap();
    static HashMap<String, Long> upgradeCooldown = new HashMap();
    static HashMap<Integer, Boolean> dirtyList = new HashMap();
    public HashMap<Integer, Float> prevStep = new HashMap();

    @SubscribeEvent
    public void livingTick(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            this.handleMisc(player);
            this.handleSpeedMods(player);
            if (!player.field_70170_p.field_72995_K) {
                this.handleRunicArmor(player);
                this.handleRepair(player);
                this.handleWarp(player);
            }
        }
    }

    private void handleMisc(EntityPlayer player) {
        if (Hover.getHover(player.func_145782_y()) && (player.field_71071_by.func_70440_f(2) == null || !(player.field_71071_by.func_70440_f(2).func_77973_b() instanceof ItemThaumostaticHarness))) {
            Hover.setHover(player.func_145782_y(), false);
            player.field_71075_bZ.field_75100_b = false;
        }
        if (player.field_70170_p.field_73011_w.func_177502_q() == Config.dimensionOuterId && player.field_70173_aa % 20 == 0 && !player.func_175149_v() && !player.field_71075_bZ.field_75098_d && (player.field_71075_bZ.field_75100_b || Hover.getHover(player.func_145782_y()))) {
            player.field_71075_bZ.field_75100_b = false;
            Hover.setHover(player.func_145782_y(), false);
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "" + EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"tc.break.fly")));
        }
    }

    @SubscribeEvent
    public void tooltipEvent(ItemTooltipEvent event) {
        AspectList al;
        int warp;
        int charge = PlayerEvents.getFinalCharge(event.itemStack);
        if (charge > 0) {
            event.toolTip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"item.runic.charge") + " +" + charge);
        }
        if ((warp = PlayerEvents.getFinalWarp(event.itemStack, event.entityPlayer)) > 0) {
            event.toolTip.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"item.warping") + " " + warp);
        }
        if ((al = PlayerEvents.getFinalDiscount(event.itemStack, event.entityPlayer)) != null) {
            if (al.getAmount(Aspect.ENERGY) > 0) {
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"tc.visdiscount") + ": " + al.getAmount(Aspect.ENERGY) + "%");
            }
            for (Aspect a : al.getAspectsSortedByName()) {
                if (a == Aspect.ENERGY) continue;
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + a.getName() + " " + StatCollector.func_74838_a((String)"tc.discount") + ": " + al.getAmount(a) + "%");
            }
        }
        if (event.itemStack != null) {
            NBTTagList nbttaglist;
            AspectList aspects;
            int c;
            if (event.itemStack.func_77973_b() instanceof IRechargable && (c = Math.round(100.0f * ((IRechargable)event.itemStack.func_77973_b()).getChargeLevel(event.itemStack))) >= 0) {
                event.toolTip.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"tc.charge") + " " + c + "%");
            }
            if (event.itemStack.func_77973_b() instanceof IEssentiaContainerItem && (aspects = ((IEssentiaContainerItem)event.itemStack.func_77973_b()).getAspects(event.itemStack)) != null && aspects.size() > 0) {
                for (Aspect tag : aspects.getAspectsSortedByName()) {
                    event.toolTip.add(tag.getName() + " x" + aspects.getAmount(tag));
                }
            }
            if ((nbttaglist = EnumInfusionEnchantment.getInfusionEnchantmentTagList(event.itemStack)) != null) {
                for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                    short k = nbttaglist.func_150305_b(j).func_74765_d("id");
                    short l = nbttaglist.func_150305_b(j).func_74765_d("lvl");
                    if (k < 0 || k >= EnumInfusionEnchantment.values().length) continue;
                    String s = EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)("enchantment.infusion." + EnumInfusionEnchantment.values()[k].toString()));
                    if (EnumInfusionEnchantment.values()[k].maxLevel > 1) {
                        s = s + " " + StatCollector.func_74838_a((String)("enchantment.level." + l));
                    }
                    event.toolTip.add(1, s);
                }
            }
        }
    }

    public static void markRunicDirty(Entity entity) {
        dirtyList.put(entity.func_145782_y(), true);
    }

    private void handleRunicArmor(EntityPlayer player) {
        if (player.field_70173_aa % 100 == 0 || dirtyList.containsKey(player.func_145782_y())) {
            dirtyList.remove(player.func_145782_y());
            int max = 0;
            int charged = 0;
            int kinetic = 0;
            int healing = 0;
            int emergency = 0;
            for (int a = 0; a < 4; ++a) {
                if (player.field_71071_by.func_70440_f(a) == null || !(player.field_71071_by.func_70440_f(a).func_77973_b() instanceof IRunicArmor)) continue;
                int amount = PlayerEvents.getFinalCharge(player.field_71071_by.func_70440_f(a));
                max += amount;
            }
            IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
            for (int a = 0; a < 4; ++a) {
                if (baubles.func_70301_a(a) == null || !(baubles.func_70301_a(a).func_77973_b() instanceof IRunicArmor)) continue;
                int amount = PlayerEvents.getFinalCharge(baubles.func_70301_a(a));
                if (baubles.func_70301_a(a).func_77973_b() instanceof ItemRingRunic) {
                    switch (baubles.func_70301_a(a).func_77952_i()) {
                        case 2: {
                            ++charged;
                            break;
                        }
                        case 3: {
                            ++healing;
                        }
                    }
                } else if (baubles.func_70301_a(a).func_77973_b() instanceof ItemAmuletRunic && baubles.func_70301_a(a).func_77952_i() == 1) {
                    ++emergency;
                } else if (baubles.func_70301_a(a).func_77973_b() instanceof ItemGirdleRunic && baubles.func_70301_a(a).func_77952_i() == 1) {
                    ++kinetic;
                }
                max += amount;
            }
            if (lastMaxCharge.containsKey(player.func_145782_y())) {
                int charge = lastMaxCharge.get(player.func_145782_y());
                if (charge > max) {
                    player.func_110149_m(player.func_110139_bj() - (float)(charge - max));
                }
                if (max <= 0) {
                    lastMaxCharge.remove(player.func_145782_y());
                }
            }
            if (max > 0) {
                runicInfo.put(player.func_145782_y(), new Integer[]{max, charged, kinetic, healing, emergency});
                lastMaxCharge.put(player.func_145782_y(), max);
            } else {
                runicInfo.remove(player.func_145782_y());
            }
        }
        if (runicInfo.containsKey(player.func_145782_y())) {
            if (!nextCycle.containsKey(player.func_145782_y())) {
                nextCycle.put(player.func_145782_y(), 0L);
            }
            long time = System.currentTimeMillis();
            int charge = (int)player.func_110139_bj();
            if (charge == 0 && lastCharge.containsKey(player.func_145782_y()) && lastCharge.get(player.func_145782_y()) > 0) {
                nextCycle.put(player.func_145782_y(), time + (long)Config.shieldWait);
                lastCharge.put(player.func_145782_y(), 0);
            }
            if (charge < runicInfo.get(player.func_145782_y())[0] && nextCycle.get(player.func_145782_y()) < time && !AuraHandler.shouldPreserveAura(player.field_70170_p, player, player.func_180425_c(), Aspect.AIR) && !AuraHandler.shouldPreserveAura(player.field_70170_p, player, player.func_180425_c(), Aspect.EARTH) && AuraHandler.drainAura(player.field_70170_p, new BlockPos((Entity)player), Aspect.AIR, Config.shieldCost, false) && AuraHandler.drainAura(player.field_70170_p, new BlockPos((Entity)player), Aspect.EARTH, Config.shieldCost, false)) {
                AuraHandler.drainAura(player.field_70170_p, new BlockPos((Entity)player), Aspect.AIR, Config.shieldCost);
                AuraHandler.drainAura(player.field_70170_p, new BlockPos((Entity)player), Aspect.EARTH, Config.shieldCost);
                long interval = Config.shieldRecharge - runicInfo.get(player.func_145782_y())[1] * 500;
                nextCycle.put(player.func_145782_y(), time + interval);
                player.func_110149_m((float)(charge + 1));
                lastCharge.put(player.func_145782_y(), charge + 1);
            }
        }
    }

    public static int getFinalCharge(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IRunicArmor)) {
            return 0;
        }
        IRunicArmor armor = (IRunicArmor)stack.func_77973_b();
        int base = armor.getRunicCharge(stack);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("RS.HARDEN")) {
            base += stack.func_77978_p().func_74771_c("RS.HARDEN");
        }
        return base;
    }

    public static int getFinalWarp(ItemStack stack, EntityPlayer player) {
        if (stack == null) {
            return 0;
        }
        int warp = 0;
        if (stack.func_77973_b() instanceof IWarpingGear) {
            IWarpingGear armor = (IWarpingGear)stack.func_77973_b();
            warp += armor.getWarp(stack, player);
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("TC.WARP")) {
            warp += stack.func_77978_p().func_74771_c("TC.WARP");
        }
        return warp;
    }

    public static AspectList getFinalDiscount(ItemStack stack, EntityPlayer player) {
        if (stack == null || !(stack.func_77973_b() instanceof IVisDiscountGear)) {
            return null;
        }
        IVisDiscountGear gear = (IVisDiscountGear)stack.func_77973_b();
        AspectList out = new AspectList();
        int gen = gear.getVisDiscount(stack, player, null);
        if (gen > 0) {
            out.add(Aspect.ENERGY, gen);
        }
        for (Aspect a : Aspect.getPrimalAspects()) {
            int d = gear.getVisDiscount(stack, player, a);
            if (d <= 0 || d == gen && gen != 0) continue;
            out.add(a, d);
        }
        return out.size() > 0 ? out : null;
    }

    public static int getHardening(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IRunicArmor)) {
            return 0;
        }
        int base = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("RS.HARDEN")) {
            base += stack.func_77978_p().func_74771_c("RS.HARDEN");
        }
        return base;
    }

    private void handleSpeedMods(EntityPlayer player) {
        this.updateSpeed(player);
        if (player.field_70170_p.field_72995_K && (player.func_70093_af() || player.field_71071_by.func_70440_f(0) == null || player.field_71071_by.func_70440_f(0).func_77973_b() != ItemsTC.travellerBoots) && this.prevStep.containsKey(player.func_145782_y())) {
            player.field_70138_W = this.prevStep.get(player.func_145782_y()).floatValue();
            this.prevStep.remove(player.func_145782_y());
        }
    }

    private void updateSpeed(EntityPlayer player) {
        try {
            int haste;
            if (!player.field_71075_bZ.field_75100_b && player.field_71071_by.func_70440_f(0) != null && player.field_70701_bs > 0.0f && (haste = EnchantmentHelper.func_77506_a((int)Config.enchHaste.field_77352_x, (ItemStack)player.field_71071_by.func_70440_f(0))) > 0) {
                float bonus = (float)haste * 0.015f;
                if (player.field_70160_al) {
                    bonus /= 2.0f;
                }
                if (player.func_70090_H()) {
                    bonus /= 2.0f;
                }
                player.func_70060_a(0.0f, 1.0f, bonus);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void playerJumps(LivingEvent.LivingJumpEvent event) {
        if (event.entity instanceof EntityPlayer && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(0) != null && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(0).func_77973_b() == ItemsTC.travellerBoots) {
            event.entityLiving.field_70181_x += (double)0.275f;
        }
    }

    private void handleRepair(EntityPlayer player) {
        if (player.field_70173_aa % 40 == 0) {
            ItemStack is;
            int a = 0;
            while (true) {
                EntityPlayer entityPlayer = player;
                if (a >= entityPlayer.field_71071_by.func_70451_h()) break;
                if (player.field_71071_by.field_70462_a[a] != null && (is = player.field_71071_by.field_70462_a[a]).func_77952_i() > 0 && is.func_77973_b() instanceof IRepairable && !player.field_71075_bZ.field_75098_d) {
                    PlayerEvents.doRepair(is, player);
                }
                ++a;
            }
            for (a = 0; a < 4; ++a) {
                if (player.field_71071_by.func_70440_f(a) == null || (is = player.field_71071_by.func_70440_f(a)).func_77952_i() <= 0 || !(is.func_77973_b() instanceof IRepairable) || player.field_71075_bZ.field_75098_d) continue;
                PlayerEvents.doRepair(is, player);
            }
        }
    }

    public static void doRepair(ItemStack is, EntityPlayer player) {
        AspectList cost;
        int level = EnchantmentHelper.func_77506_a((int)Config.enchRepair.field_77352_x, (ItemStack)is);
        if (level <= 0) {
            return;
        }
        if (level > 2) {
            level = 2;
        }
        if ((cost = ThaumcraftCraftingManager.getObjectTags(is)) == null || cost.size() == 0) {
            return;
        }
        cost = AspectHelper.reduceToPrimals(cost);
        AspectList finalCost = new AspectList();
        finalCost.merge(Aspect.EARTH, level);
        for (Aspect a : cost.getAspects()) {
            if (a == null) continue;
            finalCost.merge(a, level);
        }
        Aspect[] aa = finalCost.getAspects();
        Aspect as = aa[player.func_70681_au().nextInt(aa.length)];
        if (is.func_77973_b() instanceof IRepairableExtended) {
            if (((IRepairableExtended)is.func_77973_b()).doRepair(is, player, level) && !AuraHandler.shouldPreserveAura(player.field_70170_p, player, new BlockPos((Entity)player), as) && AuraHandler.drainAura(player.field_70170_p, new BlockPos((Entity)player), as, level)) {
                is.func_77972_a(-level, (EntityLivingBase)player);
            }
        } else if (!AuraHandler.shouldPreserveAura(player.field_70170_p, player, new BlockPos((Entity)player), as) && AuraHandler.drainAura(player.field_70170_p, new BlockPos((Entity)player), as, level)) {
            is.func_77972_a(-level, (EntityLivingBase)player);
        }
    }

    private void handleWarp(EntityPlayer player) {
        if (!Config.wuss && player.field_70173_aa > 0 && player.field_70173_aa % 2000 == 0 && !player.func_70644_a((Potion)PotionWarpWard.instance)) {
            WarpEvents.checkWarpEvent(player);
        }
        if (player.field_70173_aa % 10 == 0 && player.func_70644_a((Potion)PotionDeathGaze.instance)) {
            WarpEvents.checkDeathGaze(player);
        }
    }

    @SubscribeEvent
    public void droppedItem(ItemTossEvent event) {
        NBTTagCompound itemData = event.entityItem.getEntityData();
        itemData.func_74778_a("thrower", event.player.func_70005_c_());
    }

    @SubscribeEvent
    public void playerLoad(PlayerEvent.LoadFromFile event) {
        ResearchManager.loadingBlocked = true;
        EntityPlayer p = event.entityPlayer;
        Thaumcraft.proxy.getPlayerKnowledge().wipePlayerKnowledge(p.func_70005_c_());
        File file1 = this.getPlayerFile("thaum", event.playerDirectory, p.func_70005_c_());
        ResearchManager.loadPlayerData(p.func_70005_c_(), file1, this.getPlayerFile("thaumback", event.playerDirectory, p.func_70005_c_()));
        Collection<ResearchCategoryList> rc = ResearchCategories.researchCategories.values();
        for (ResearchCategoryList cat : rc) {
            Collection<ResearchItem> res = cat.research.values();
            for (ResearchItem ri : res) {
                if (!ri.isAutoUnlock()) continue;
                Thaumcraft.proxy.getResearchManager().completeResearch(p, ri.key, (byte)0);
            }
        }
        ResearchManager.loadingBlocked = false;
    }

    public File getPlayerFile(String suffix, File playerDirectory, String playername) {
        if ("dat".equals(suffix)) {
            throw new IllegalArgumentException("The suffix 'dat' is reserved");
        }
        return new File(playerDirectory, "_" + playername + "." + suffix);
    }

    @SubscribeEvent
    public void playerSave(PlayerEvent.SaveToFile event) {
        ResearchManager.loadingBlocked = true;
        EntityPlayer p = event.entityPlayer;
        ResearchManager.savePlayerData(p, this.getPlayerFile("thaum", event.playerDirectory, p.func_70005_c_()), this.getPlayerFile("thaumback", event.playerDirectory, p.func_70005_c_()));
        ResearchManager.loadingBlocked = false;
    }

    @SubscribeEvent
    public void finishedUsingItem(PlayerUseItemEvent.Finish event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entityPlayer.func_70644_a((Potion)PotionUnnaturalHunger.instance)) {
            if (event.item.func_77969_a(new ItemStack(Items.field_151078_bh)) || event.item.func_77969_a(new ItemStack(ItemsTC.brain))) {
                PotionEffect pe = event.entityPlayer.func_70660_b((Potion)PotionUnnaturalHunger.instance);
                int amp = pe.func_76458_c() - 1;
                int duration = pe.func_76459_b() - 600;
                event.entityPlayer.func_82170_o(PotionUnnaturalHunger.instance.func_76396_c());
                if (duration > 0 && amp >= 0) {
                    pe = new PotionEffect(PotionUnnaturalHunger.instance.func_76396_c(), duration, amp, true, false);
                    pe.getCurativeItems().clear();
                    pe.addCurativeItem(new ItemStack(Items.field_151078_bh));
                    event.entityPlayer.func_70690_d(pe);
                }
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("\u00a72\u00a7o" + StatCollector.func_74838_a((String)"warp.text.hunger.2")));
            } else if (event.item.func_77973_b() instanceof ItemFood) {
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("\u00a74\u00a7o" + StatCollector.func_74838_a((String)"warp.text.hunger.1")));
            }
        }
    }
}

