/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.playerdata;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketResearchComplete;
import thaumcraft.common.lib.research.ResearchManager;

public class PacketPlayerCompleteToServer
implements IMessage,
IMessageHandler<PacketPlayerCompleteToServer, IMessage> {
    private String key;
    private int dim;
    private String username;
    private byte type;

    public PacketPlayerCompleteToServer() {
    }

    public PacketPlayerCompleteToServer(String key, String username, int dim, byte type) {
        this.key = key;
        this.dim = dim;
        this.username = username;
        this.type = type;
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.key);
        buffer.writeInt(this.dim);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.username);
        buffer.writeByte((int)this.type);
    }

    public void fromBytes(ByteBuf buffer) {
        this.key = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.dim = buffer.readInt();
        this.username = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.type = buffer.readByte();
    }

    public IMessage onMessage(PacketPlayerCompleteToServer message, MessageContext ctx) {
        WorldServer world = DimensionManager.getWorld((int)message.dim);
        if (world == null || ctx.getServerHandler().field_147369_b != null && !ctx.getServerHandler().field_147369_b.func_70005_c_().equals(message.username)) {
            return null;
        }
        EntityPlayer player = world.func_72924_a(message.username);
        if (player != null && !ResearchManager.isResearchComplete(message.username, message.key)) {
            if (ResearchManager.doesPlayerHaveRequisites(message.username, message.key)) {
                if (message.type == 0) {
                    int xp = ResearchCategories.getResearch(message.key).getExperience();
                    if (player.field_71075_bZ.field_75098_d || player.field_71068_ca >= xp) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.func_71013_b(xp);
                        }
                        PacketHandler.INSTANCE.sendTo((IMessage)new PacketResearchComplete(message.key, 0), (EntityPlayerMP)player);
                        Thaumcraft.proxy.getResearchManager().completeResearch(player, message.key, (byte)0);
                        if (ResearchCategories.getResearch((String)message.key).siblings != null) {
                            for (String sibling : ResearchCategories.getResearch((String)message.key).siblings) {
                                if (ResearchManager.isResearchComplete(message.username, sibling) || !ResearchManager.doesPlayerHaveRequisites(message.username, sibling)) continue;
                                PacketHandler.INSTANCE.sendTo((IMessage)new PacketResearchComplete(sibling, 0), (EntityPlayerMP)player);
                                Thaumcraft.proxy.getResearchManager().completeResearch(player, sibling, (byte)0);
                            }
                        }
                    }
                } else if (message.type == 1) {
                    ResearchManager.createResearchNoteForPlayer((World)world, player, message.key);
                }
                world.func_72956_a((Entity)player, "thaumcraft:learn", 0.75f, 1.0f);
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation(StatCollector.func_74838_a((String)"tc.researcherror"), new Object[0]));
            }
        }
        return null;
    }
}

