/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.world.objects;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.lib.utils.TCVec3;
import thaumcraft.common.lib.world.dim.GenCommon;
import thaumcraft.common.lib.world.dim.MazeHandler;
import thaumcraft.common.tiles.misc.TileBanner;
import thaumcraft.common.tiles.misc.TileEldritchAltar;

public class WorldGenEldritchRing
extends WorldGenerator {
    public int chunkX;
    public int chunkZ;
    public int width;
    public int height = 0;

    protected Block[] GetValidSpawnBlocks() {
        return new Block[]{Blocks.field_150348_b, Blocks.field_150354_m, Blocks.field_150403_cj, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150346_d};
    }

    public boolean locationIsValidSpawn(World world, BlockPos pos) {
        int distanceToAir = 0;
        Block checkID = world.func_180495_p(pos).func_177230_c();
        while (checkID != Blocks.field_150350_a && !world.func_175623_d(pos)) {
            checkID = world.func_180495_p(pos.func_177981_b(++distanceToAir)).func_177230_c();
        }
        if (distanceToAir > 2) {
            return false;
        }
        int j = distanceToAir - 1;
        Block blockID = world.func_180495_p(pos.func_177981_b(j)).func_177230_c();
        Block blockIDAbove = world.func_180495_p(pos.func_177981_b(j + 1)).func_177230_c();
        Block blockIDBelow = world.func_180495_p(pos.func_177981_b(j - 1)).func_177230_c();
        for (Block x : this.GetValidSpawnBlocks()) {
            if (blockIDAbove != Blocks.field_150350_a) {
                return false;
            }
            if (blockID == x) {
                return true;
            }
            if (blockID != Blocks.field_150431_aC && blockID != Blocks.field_150329_H || blockIDBelow != x) continue;
            return true;
        }
        return false;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        BlockPos p;
        int z;
        int x;
        if (!(this.locationIsValidSpawn(world, pos.func_177982_a(-3, 0, -3)) && this.locationIsValidSpawn(world, pos) && this.locationIsValidSpawn(world, pos.func_177982_a(3, 0, 0)) && this.locationIsValidSpawn(world, pos.func_177982_a(3, 0, 3)) && this.locationIsValidSpawn(world, pos.func_177982_a(0, 0, 3)) && !MazeHandler.mazesInRange(this.chunkX, this.chunkZ, this.width, this.height))) {
            return false;
        }
        IBlockState replaceBlock = world.func_180494_b((BlockPos)pos).field_76752_A;
        int i = pos.func_177958_n();
        int k = pos.func_177952_p();
        for (x = i - 3; x <= i + 3; ++x) {
            for (z = k - 3; z <= k + 3; ++z) {
                p = new BlockPos(x, pos.func_177956_o(), z);
                for (int q = -3; q < 5; ++q) {
                    Block bb = world.func_180495_p(p.func_177981_b(q)).func_177230_c();
                    TCVec3 v1 = TCVec3.createVectorHelper(pos);
                    TCVec3 v2 = TCVec3.createVectorHelper(p.func_177981_b(q));
                    if (q <= 0 && v1.squareDistanceTo(v2) < 15.0) {
                        if (rand.nextInt(3) == 0) {
                            world.func_175656_a(p.func_177981_b(q), BlocksTC.stone.func_176203_a(4));
                            continue;
                        }
                        world.func_175656_a(p.func_177981_b(q), Blocks.field_150343_Z.func_176223_P());
                        continue;
                    }
                    if (q <= 0) continue;
                    world.func_175698_g(p.func_177981_b(q));
                }
            }
        }
        for (x = i - 3; x <= i + 3; ++x) {
            for (z = k - 3; z <= k + 3; ++z) {
                if (!(x != i - 3 && x != i + 3 || z != k - 3 && z != k + 3)) continue;
                p = new BlockPos(x, pos.func_177956_o(), z);
                if (x == i && z == k) {
                    world.func_175656_a(p.func_177984_a(), BlocksTC.eldritch.func_176223_P());
                    world.func_175656_a(p, BlocksTC.stone.func_176203_a(4));
                    int r = rand.nextInt(10);
                    TileEntity te = world.func_175625_s(p.func_177984_a());
                    if (te != null && te instanceof TileEldritchAltar) {
                        switch (r) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                ((TileEldritchAltar)te).setSpawner(true);
                                ((TileEldritchAltar)te).setSpawnType((byte)0);
                                for (EnumFacing dir : EnumFacing.field_176754_o) {
                                    BlockPos pp = p.func_177982_a(-dir.func_82601_c() * 3, 1, dir.func_82599_e() * 3);
                                    world.func_175656_a(pp, BlocksTC.banner.func_176203_a(1));
                                    te = world.func_175625_s(pp);
                                    if (te == null || !(te instanceof TileBanner)) continue;
                                    int face = 0;
                                    switch (dir.ordinal()) {
                                        case 2: {
                                            face = 8;
                                            break;
                                        }
                                        case 3: {
                                            face = 0;
                                            break;
                                        }
                                        case 4: {
                                            face = 12;
                                            break;
                                        }
                                        case 5: {
                                            face = 4;
                                            break;
                                        }
                                    }
                                    ((TileBanner)te).setBannerFacing((byte)face);
                                }
                                break;
                            }
                            case 6: 
                            case 7: {
                                ((TileEldritchAltar)te).setSpawner(true);
                                ((TileEldritchAltar)te).setSpawnType((byte)1);
                            }
                        }
                    }
                    GenCommon.genObelisk(world, p.func_177981_b(3));
                    continue;
                }
                if ((x != i - 3 && x != i + 3 || Math.abs((z - k) % 2) != 1) && (z != k - 3 && z != k + 3 || Math.abs((x - i) % 2) != 1) || Math.abs(x - i) == Math.abs(z - k)) continue;
                world.func_175656_a(p.func_177984_a(), BlocksTC.eldritch.func_176203_a(1));
            }
        }
        return true;
    }
}

