/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.misc;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ITickable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.blocks.TileThaumcraft;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;
import thaumcraft.common.entities.monster.cult.EntityCultist;
import thaumcraft.common.entities.monster.cult.EntityCultistCleric;
import thaumcraft.common.entities.monster.cult.EntityCultistKnight;
import thaumcraft.common.lib.world.dim.MazeHandler;
import thaumcraft.common.lib.world.dim.MazeThread;

public class TileEldritchAltar
extends TileThaumcraft
implements ITickable {
    private boolean spawner = false;
    private boolean open = false;
    private boolean spawnedClerics = false;
    private byte spawnType = 0;
    private byte eyes = 0;
    private int counter = 0;

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.setEyes(nbttagcompound.func_74771_c("eyes"));
        this.setOpen(nbttagcompound.func_74767_n("open"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74774_a("eyes", this.getEyes());
        nbttagcompound.func_74757_a("open", this.isOpen());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.spawnedClerics = nbttagcompound.func_74767_n("spawnedClerics");
        this.spawner = nbttagcompound.func_74767_n("spawner");
        this.spawnType = nbttagcompound.func_74771_c("spawntype");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("spawnedClerics", this.spawnedClerics);
        nbttagcompound.func_74757_a("spawner", this.spawner);
        nbttagcompound.func_74774_a("spawntype", this.spawnType);
    }

    public double func_145833_n() {
        return 9216.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_178781_a((double)((double)this.func_174877_v().func_177958_n() - 0.3), (double)((double)this.func_174877_v().func_177956_o() - 0.3), (double)((double)this.func_174877_v().func_177952_p() - 0.3), (double)((double)this.func_174877_v().func_177958_n() + 1.3), (double)((double)this.func_174877_v().func_177956_o() + 1.3), (double)((double)this.func_174877_v().func_177952_p() + 1.3));
    }

    public boolean isSpawner() {
        return this.spawner;
    }

    public void setSpawner(boolean spawner) {
        this.spawner = spawner;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isSpawner() && this.counter++ >= 80 && this.counter % 40 == 0) {
            switch (this.spawnType) {
                case 0: {
                    if (!this.spawnedClerics) {
                        this.spawnClerics();
                        break;
                    }
                    this.spawnGuards();
                    break;
                }
                case 1: {
                    this.spawnGuardian();
                }
            }
        }
    }

    private void spawnGuards() {
        List ents = this.field_145850_b.func_72872_a(EntityCultistCleric.class, AxisAlignedBB.func_178781_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)).func_72314_b(24.0, 16.0, 24.0));
        if (ents.size() < 1) {
            this.setSpawner(false);
            return;
        }
        ents = this.field_145850_b.func_72872_a(EntityCultist.class, AxisAlignedBB.func_178781_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)).func_72314_b(24.0, 16.0, 24.0));
        if (ents.size() < 8) {
            int k1;
            int j1;
            EntityCultistKnight eg = new EntityCultistKnight(this.field_145850_b);
            int i1 = this.func_174877_v().func_177958_n() + MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)4, (int)10) * MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)-1, (int)1);
            if (World.func_175683_a((IBlockAccess)this.field_145850_b, (BlockPos)new BlockPos(i1, (j1 = this.func_174877_v().func_177956_o() + MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)0, (int)3) * MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)-1, (int)1)) - 1, k1 = this.func_174877_v().func_177952_p() + MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)4, (int)10) * MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)-1, (int)1)))) {
                eg.func_70107_b(i1, j1, k1);
                if (this.field_145850_b.func_72855_b(eg.func_174813_aQ()) && this.field_145850_b.func_72945_a((Entity)eg, eg.func_174813_aQ()).isEmpty() && !this.field_145850_b.func_72953_d(eg.func_174813_aQ())) {
                    eg.func_180482_a(this.field_145850_b.func_175649_E(this.field_174879_c), null);
                    eg.func_175449_a(this.field_174879_c, 16);
                    this.field_145850_b.func_72838_d((Entity)eg);
                    eg.func_70656_aK();
                }
            }
        }
    }

    private void spawnGuardian() {
        int k1;
        int j1;
        EntityEldritchGuardian eg = new EntityEldritchGuardian(this.field_145850_b);
        int i1 = this.func_174877_v().func_177958_n() + MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)4, (int)10) * MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)-1, (int)1);
        if (World.func_175683_a((IBlockAccess)this.field_145850_b, (BlockPos)new BlockPos(i1, (j1 = this.func_174877_v().func_177956_o() + MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)0, (int)3) * MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)-1, (int)1)) - 1, k1 = this.func_174877_v().func_177952_p() + MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)4, (int)10) * MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)-1, (int)1)))) {
            eg.func_70107_b(i1, j1, k1);
            if (this.field_145850_b.func_72855_b(eg.func_174813_aQ()) && this.field_145850_b.func_72945_a((Entity)eg, eg.func_174813_aQ()).isEmpty() && !this.field_145850_b.func_72953_d(eg.func_174813_aQ()) && eg.func_70601_bi()) {
                eg.func_180482_a(this.field_145850_b.func_175649_E(this.field_174879_c), null);
                eg.func_70656_aK();
                eg.func_175449_a(this.field_174879_c, 16);
                this.field_145850_b.func_72838_d((Entity)eg);
            }
        }
    }

    private void spawnClerics() {
        int success = 0;
        for (int a = 0; a < 4; ++a) {
            int xx = 0;
            int zz = 0;
            switch (a) {
                case 0: {
                    xx = -2;
                    zz = -2;
                    break;
                }
                case 1: {
                    xx = -2;
                    zz = 2;
                    break;
                }
                case 2: {
                    xx = 2;
                    zz = -2;
                    break;
                }
                case 3: {
                    xx = 2;
                    zz = 2;
                }
            }
            EntityCultistCleric cleric = new EntityCultistCleric(this.field_145850_b);
            if (!World.func_175683_a((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(xx, -1, zz))) continue;
            cleric.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5 + (double)xx, this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)zz);
            if (!this.field_145850_b.func_72855_b(cleric.func_174813_aQ()) || !this.field_145850_b.func_72945_a((Entity)cleric, cleric.func_174813_aQ()).isEmpty() || this.field_145850_b.func_72953_d(cleric.func_174813_aQ())) continue;
            cleric.func_175449_a(this.field_174879_c, 8);
            cleric.func_180482_a(this.field_145850_b.func_175649_E(this.field_174879_c), null);
            if (!this.field_145850_b.func_72838_d((Entity)cleric)) continue;
            ++success;
            cleric.setIsRitualist(true);
            cleric.func_70656_aK();
        }
        if (success > 2) {
            this.spawnedClerics = true;
            this.func_70296_d();
        }
    }

    public byte getSpawnType() {
        return this.spawnType;
    }

    public void setSpawnType(byte spawnType) {
        this.spawnType = spawnType;
    }

    public byte getEyes() {
        return this.eyes;
    }

    public void setEyes(byte eyes) {
        this.eyes = eyes;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public boolean checkForMaze() {
        int w = 15 + this.field_145850_b.field_73012_v.nextInt(8) * 2;
        int h = 15 + this.field_145850_b.field_73012_v.nextInt(8) * 2;
        if (!MazeHandler.mazesInRange(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4, w, h)) {
            Thread t = new Thread(new MazeThread(this.field_174879_c.func_177956_o() >> 4, this.field_174879_c.func_177952_p() >> 4, w, h, this.field_145850_b.field_73012_v.nextLong()));
            t.start();
            return false;
        }
        return true;
    }
}

