/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.wands;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import thaumcraft.api.wands.IWandTriggerManager;

public class WandTriggerRegistry {
    private static HashMap<String, HashMap<IBlockState, List>> triggers = new HashMap();
    private static final String DEFAULT = "default";

    public static void registerWandBlockTrigger(IWandTriggerManager manager, int event, IBlockState state, String modid) {
        if (!triggers.containsKey(modid)) {
            triggers.put(modid, new HashMap());
        }
        HashMap<IBlockState, List> temp = triggers.get(modid);
        temp.put(state, Arrays.asList(manager, event));
        triggers.put(modid, temp);
    }

    public static void registerWandBlockTrigger(IWandTriggerManager manager, int event, IBlockState state) {
        WandTriggerRegistry.registerWandBlockTrigger(manager, event, state, DEFAULT);
    }

    public static boolean hasTrigger(IBlockState state) {
        for (String modid : triggers.keySet()) {
            HashMap<IBlockState, List> temp = triggers.get(modid);
            if (!temp.containsKey(state)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTrigger(IBlockState state, String modid) {
        if (!triggers.containsKey(modid)) {
            return false;
        }
        HashMap<IBlockState, List> temp = triggers.get(modid);
        return temp.containsKey(state);
    }

    public static boolean performTrigger(World world, ItemStack wand, EntityPlayer player, BlockPos pos, EnumFacing side, IBlockState state) {
        for (String modid : triggers.keySet()) {
            int event;
            IWandTriggerManager manager;
            boolean result;
            HashMap<IBlockState, List> temp = triggers.get(modid);
            List l = temp.get(state);
            if (l == null || !(result = (manager = (IWandTriggerManager)l.get(0)).performTrigger(world, wand, player, pos, side, event = ((Integer)l.get(1)).intValue()))) continue;
            return true;
        }
        return false;
    }

    public static boolean performTrigger(World world, ItemStack wand, EntityPlayer player, BlockPos pos, EnumFacing side, IBlockState state, String modid) {
        if (!triggers.containsKey(modid)) {
            return false;
        }
        HashMap<IBlockState, List> temp = triggers.get(modid);
        List l = temp.get(state);
        if (l == null) {
            return false;
        }
        IWandTriggerManager manager = (IWandTriggerManager)l.get(0);
        int event = (Integer)l.get(1);
        return manager.performTrigger(world, wand, player, pos, side, event);
    }
}

