/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib;

import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.Vec3;

public class TexturedQuadTC {
    public PositionTextureVertex[] vertexPositions;
    public int nVertices;
    private boolean invertNormal;

    public TexturedQuadTC(PositionTextureVertex[] vertices) {
        this.vertexPositions = vertices;
        this.nVertices = vertices.length;
    }

    public TexturedQuadTC(PositionTextureVertex[] vertices, int texcoordU1, int texcoordV1, int texcoordU2, int texcoordV2, float textureWidth, float textureHeight) {
        this(vertices);
        float f2 = 0.0f / textureWidth;
        float f3 = 0.0f / textureHeight;
        vertices[0] = vertices[0].func_78240_a((float)texcoordU2 / textureWidth - f2, (float)texcoordV1 / textureHeight + f3);
        vertices[1] = vertices[1].func_78240_a((float)texcoordU1 / textureWidth + f2, (float)texcoordV1 / textureHeight + f3);
        vertices[2] = vertices[2].func_78240_a((float)texcoordU1 / textureWidth + f2, (float)texcoordV2 / textureHeight - f3);
        vertices[3] = vertices[3].func_78240_a((float)texcoordU2 / textureWidth - f2, (float)texcoordV2 / textureHeight - f3);
    }

    public void flipFace() {
        PositionTextureVertex[] apositiontexturevertex = new PositionTextureVertex[this.vertexPositions.length];
        for (int i = 0; i < this.vertexPositions.length; ++i) {
            apositiontexturevertex[i] = this.vertexPositions[this.vertexPositions.length - i - 1];
        }
        this.vertexPositions = apositiontexturevertex;
    }

    public void draw(WorldRenderer renderer, float scale, int bright, int color, float alpha) {
        Vec3 vec3 = this.vertexPositions[1].field_78243_a.func_72444_a(this.vertexPositions[0].field_78243_a);
        Vec3 vec31 = this.vertexPositions[1].field_78243_a.func_72444_a(this.vertexPositions[2].field_78243_a);
        Vec3 vec32 = vec31.func_72431_c(vec3).func_72432_b();
        renderer.func_178970_b();
        if (bright != -99) {
            renderer.func_178963_b(bright);
        }
        renderer.func_178974_a(color, (int)(alpha * 255.0f));
        if (this.invertNormal) {
            renderer.func_178980_d(-((float)vec32.field_72450_a), -((float)vec32.field_72448_b), -((float)vec32.field_72449_c));
        } else {
            renderer.func_178980_d((float)vec32.field_72450_a, (float)vec32.field_72448_b, (float)vec32.field_72449_c);
        }
        for (int i = 0; i < 4; ++i) {
            PositionTextureVertex positiontexturevertex = this.vertexPositions[i];
            renderer.func_178985_a(positiontexturevertex.field_78243_a.field_72450_a * (double)scale, positiontexturevertex.field_78243_a.field_72448_b * (double)scale, positiontexturevertex.field_78243_a.field_72449_c * (double)scale, (double)positiontexturevertex.field_78241_b, (double)positiontexturevertex.field_78242_c);
        }
        Tessellator.func_178181_a().func_78381_a();
    }
}

