/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.models;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import thaumcraft.client.lib.models.MeshPart;
import thaumcraft.codechicken.lib.vec.Rotation;
import thaumcraft.codechicken.lib.vec.Vector3;

public class MeshModel {
    public List<Vector3f> positions;
    public List<Vector3f> normals;
    public List<Vector2f> texCoords;
    public List<MeshPart> parts = new ArrayList<MeshPart>();

    public MeshModel clone() {
        MeshModel mm = new MeshModel();
        mm.parts = new ArrayList<MeshPart>();
        for (MeshPart meshPart : this.parts) {
            mm.parts.add(meshPart);
        }
        if (this.positions != null) {
            mm.positions = new ArrayList<Vector3f>();
            for (Vector3f vector3f : this.positions) {
                mm.positions.add((Vector3f)vector3f.clone());
            }
        }
        if (this.normals != null) {
            mm.normals = new ArrayList<Vector3f>();
            for (Vector3f vector3f : this.normals) {
                mm.normals.add((Vector3f)vector3f.clone());
            }
        }
        if (this.texCoords != null) {
            mm.texCoords = new ArrayList<Vector2f>();
            for (Vector2f vector2f : this.texCoords) {
                mm.texCoords.add((Vector2f)vector2f.clone());
            }
        }
        return mm;
    }

    public void rotate(double d, Vector3 axis, Vector3 offset) {
        Rotation r = new Rotation(d, axis);
        ArrayList<Vector3f> p = new ArrayList<Vector3f>();
        for (Vector3f v : this.positions) {
            Vector3 vec = new Vector3(v.x, v.y, v.z);
            r.apply(vec);
            vec = vec.add(offset);
            p.add(new Vector3f((float)vec.x, (float)vec.y, (float)vec.z));
        }
        this.positions = p;
    }

    public void addPosition(float x, float y, float z) {
        if (this.positions == null) {
            this.positions = new ArrayList<Vector3f>();
        }
        this.positions.add(new Vector3f(x, y, z));
    }

    public void addNormal(float x, float y, float z) {
        if (this.normals == null) {
            this.normals = new ArrayList<Vector3f>();
        }
        this.normals.add(new Vector3f(x, y, z));
    }

    public void addTexCoords(float x, float y) {
        if (this.texCoords == null) {
            this.texCoords = new ArrayList<Vector2f>();
        }
        this.texCoords.add(new Vector2f(x, y));
    }

    public void addPart(MeshPart part) {
        this.parts.add(part);
    }

    public void addPart(MeshPart part, int ti) {
        this.parts.add(new MeshPart(part, ti));
    }

    private int getColorValue(Vector3f color) {
        int r = (int)color.x;
        int g = (int)color.y;
        int b = (int)color.z;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public List<BakedQuad> bakeModel(ModelManager manager) {
        ArrayList<BakedQuad> bakeList = new ArrayList<BakedQuad>();
        for (int j = 0; j < this.parts.size(); ++j) {
            MeshPart part = this.parts.get(j);
            TextureAtlasSprite sprite = null;
            int color = -1;
            if (part.material != null) {
                if (part.material.DiffuseTextureMap != null) {
                    sprite = manager.func_174952_b().func_110572_b(part.material.DiffuseTextureMap);
                } else if (part.material.AmbientTextureMap != null) {
                    sprite = manager.func_174952_b().func_110572_b(part.material.AmbientTextureMap);
                }
                if (part.material.DiffuseColor != null) {
                    color = this.getColorValue(part.material.DiffuseColor);
                }
            }
            for (int i = 0; i < part.indices.size(); i += 4) {
                BakedQuad quad = this.bakeQuad(part, i, sprite, color);
                bakeList.add(quad);
            }
        }
        return bakeList;
    }

    public List<BakedQuad> bakeModel(TextureAtlasSprite sprite) {
        ArrayList<BakedQuad> bakeList = new ArrayList<BakedQuad>();
        for (int j = 0; j < this.parts.size(); ++j) {
            MeshPart part = this.parts.get(j);
            int color = -1;
            for (int i = 0; i < part.indices.size(); i += 4) {
                BakedQuad quad = this.bakeQuad(part, i, sprite, color);
                bakeList.add(quad);
            }
        }
        return bakeList;
    }

    private BakedQuad bakeQuad(MeshPart part, int startIndex, TextureAtlasSprite sprite, int color) {
        int[] faceData = new int[28];
        for (int i = 0; i < 4; ++i) {
            Vector3f position = new Vector3f(0.0f, 0.0f, 0.0f);
            Vector2f texCoord = new Vector2f(0.0f, 0.0f);
            int p = 0;
            int[] indices = part.indices.get(startIndex + i);
            if (this.positions != null) {
                position = this.positions.get(indices[p++]);
            }
            if (this.normals != null) {
                ++p;
            }
            if (this.texCoords != null) {
                texCoord = this.texCoords.get(indices[p++]);
            }
            MeshModel.storeVertexData(faceData, i, position, texCoord, sprite, color);
        }
        return new BakedQuad(faceData, part.name.contains("focus") ? 1 : part.tintIndex, FaceBakery.func_178410_a((int[])faceData));
    }

    private static void storeVertexData(int[] faceData, int storeIndex, Vector3f position, Vector2f faceUV, TextureAtlasSprite sprite, int shadeColor) {
        int l = storeIndex * 7;
        faceData[l + 0] = Float.floatToRawIntBits(position.x);
        faceData[l + 1] = Float.floatToRawIntBits(position.y);
        faceData[l + 2] = Float.floatToRawIntBits(position.z);
        faceData[l + 3] = shadeColor;
        if (sprite != null) {
            faceData[l + 4] = Float.floatToRawIntBits(sprite.func_94214_a((double)(faceUV.x * 16.0f)));
            faceData[l + 5] = Float.floatToRawIntBits(sprite.func_94207_b((double)(faceUV.y * 16.0f)));
        } else {
            faceData[l + 4] = Float.floatToRawIntBits(faceUV.x);
            faceData[l + 5] = Float.floatToRawIntBits(faceUV.y);
        }
        faceData[l + 6] = 0;
    }
}

