/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.models.gear;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ISmartItemModel;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.client.lib.models.IInitializeBakedModel;
import thaumcraft.client.lib.models.MeshLoader;
import thaumcraft.client.lib.models.MeshModel;
import thaumcraft.client.lib.models.ModelRegistrationHelper;

public class CustomWandMeshModel
implements ISmartItemModel,
IInitializeBakedModel {
    String variant;
    ResourceLocation model;
    ItemCameraTransforms transforms;
    List<BakedQuad> faceQuads;
    List<BakedQuad> generalQuads;
    MeshModel sourceMesh;
    TextureAtlasSprite iconSprite;
    private static final List<List<BakedQuad>> empty_face_quads = Lists.newArrayList();
    static HashMap<String, CustomWandMeshModel> variants;
    static HashMap<String, SimpleBakedModel> cache;

    public CustomWandMeshModel(String variant, WandCap cap) {
        this.setup(variant, false);
        this.sourceMesh.parts.get((int)4).material.DiffuseTextureMap = cap.getTexture().toString();
        this.sourceMesh.parts.remove(3);
        this.sourceMesh.parts.remove(2);
        this.sourceMesh.parts.remove(1);
        this.sourceMesh.parts.remove(0);
        variants.put(variant, this);
    }

    public CustomWandMeshModel(String variant, ItemFocusBasic focus) {
        this.setup(variant, false);
        this.sourceMesh.parts.remove(4);
        this.sourceMesh.parts.get((int)3).material.DiffuseTextureMap = focus.getFocusTexture().toString();
        this.sourceMesh.parts.remove(2);
        this.sourceMesh.parts.remove(1);
        this.sourceMesh.parts.remove(0);
        variants.put(variant, this);
    }

    public CustomWandMeshModel(String variant, WandRod rod) {
        this.setup(variant, rod.isStaff());
        this.sourceMesh.parts.get((int)0).material.DiffuseTextureMap = rod.getTexture().toString();
        if (!rod.isStaff()) {
            this.sourceMesh.parts.remove(4);
        }
        this.sourceMesh.parts.remove(3);
        this.sourceMesh.parts.remove(2);
        this.sourceMesh.parts.remove(1);
        variants.put(variant, this);
    }

    public CustomWandMeshModel(String variant, WandCap cap, boolean staff) {
        this.setup(variant, staff);
        this.sourceMesh.parts.get((int)1).material.DiffuseTextureMap = cap.getTexture().toString();
        this.sourceMesh.parts.get((int)2).material.DiffuseTextureMap = cap.getTexture().toString();
        if (!staff) {
            this.sourceMesh.parts.remove(4);
        }
        this.sourceMesh.parts.remove(3);
        this.sourceMesh.parts.remove(0);
        variants.put(variant, this);
    }

    public CustomWandMeshModel(String itemName) {
        this.setup(itemName, false);
    }

    public void setup(String variant, boolean staff) {
        this.variant = variant;
        this.model = staff ? new ResourceLocation("Thaumcraft", "models/obj/staff.obj") : new ResourceLocation("Thaumcraft", "models/obj/wand.obj");
        this.faceQuads = new ArrayList<BakedQuad>();
        this.generalQuads = new ArrayList<BakedQuad>();
        try {
            this.generalQuads.clear();
            this.sourceMesh = new MeshLoader().loadFromResource(this.model);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize(ItemCameraTransforms cameraTransforms, ResourceLocation icon, ModelManager modelManager) {
        this.transforms = cameraTransforms;
        this.iconSprite = modelManager.func_174952_b().func_110572_b(icon.toString());
        this.generalQuads = this.sourceMesh.bakeModel(modelManager);
    }

    public IBakedModel handleItemState(ItemStack stack) {
        SimpleBakedModel model;
        ResourceLocation icon;
        ModelRegistrationHelper helper;
        ModelBlock modelblock;
        IWand wand = (IWand)stack.func_77973_b();
        WandRod rod = wand.getRod(stack);
        WandCap cap = wand.getCap(stack);
        ItemFocusBasic focus = wand.getFocus(stack);
        String cacheKey = (rod.isStaff() ? "staff" : (wand.isSceptre(stack) ? "sceptre" : "wand")) + rod.getTag() + cap.getTag();
        if (focus != null) {
            cacheKey = cacheKey + focus.getFocusId();
        }
        if (cache.containsKey(cacheKey)) {
            return (IBakedModel)cache.get(cacheKey);
        }
        ArrayList quads = Lists.newArrayList();
        String key = (rod.isStaff() ? "staff" : "wand") + rod.getTag();
        if (!variants.containsKey(key)) {
            return this;
        }
        for (BakedQuad q : CustomWandMeshModel.variants.get((Object)key).generalQuads) {
            quads.add(q);
        }
        key = (rod.isStaff() ? "staff" : "wand") + cap.getTag();
        if (!variants.containsKey(key)) {
            return this;
        }
        for (BakedQuad q : CustomWandMeshModel.variants.get((Object)key).generalQuads) {
            quads.add(q);
        }
        if (wand.isSceptre(stack)) {
            key = "sceptre" + cap.getTag();
            if (!variants.containsKey(key)) {
                return this;
            }
            for (BakedQuad q : CustomWandMeshModel.variants.get((Object)key).generalQuads) {
                quads.add(q);
            }
        }
        if (focus != null) {
            key = "focus" + focus.getFocusId();
            if (!variants.containsKey(key)) {
                return this;
            }
            for (BakedQuad q : CustomWandMeshModel.variants.get((Object)key).generalQuads) {
                quads.add(q);
            }
        }
        ItemCameraTransforms trans = this.func_177552_f();
        if (rod.isStaff() && (modelblock = (helper = new ModelRegistrationHelper()).loadModelResource(icon = new ResourceLocation("Thaumcraft", "item/staff"))) != null) {
            trans = new ItemCameraTransforms(modelblock.func_178296_g(), modelblock.func_178306_h(), modelblock.func_178301_i(), modelblock.func_178297_j());
        }
        if ((model = new SimpleBakedModel((List)quads, empty_face_quads, this.func_177555_b(), this.func_177556_c(), this.func_177554_e(), trans)) != null) {
            cache.put(cacheKey, model);
        }
        return model;
    }

    public List func_177551_a(EnumFacing face) {
        return this.faceQuads;
    }

    public List func_177550_a() {
        return this.generalQuads;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.iconSprite;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.transforms;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            empty_face_quads.add(new LinkedList());
        }
        variants = new HashMap();
        cache = new HashMap();
    }
}

