/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.basic;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.blocks.BlockTC;

public class BlockPillar
extends BlockTC {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", PillarType.class);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private final Random rand = new Random();

    public BlockPillar() {
        super(Material.field_151576_e);
        this.func_149711_c(2.5f);
        this.func_149672_a(field_149769_e);
        this.func_149647_a(null);
        IBlockState bs = this.field_176227_L.func_177621_b();
        bs.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
        bs.func_177226_a((IProperty)TYPE, (Comparable)((Object)PillarType.NORMAL));
        this.func_180632_j(bs);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        return super.func_180646_a(world, pos);
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
        super.func_180638_a(world, pos, state, axisalignedbb, arraylist, par7Entity);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState bs = this.field_176227_L.func_177621_b();
        bs.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
        bs.func_177226_a((IProperty)TYPE, (Comparable)((Object)PillarType.values()[meta / 4]));
        return bs;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        state = state.func_177226_a((IProperty)TYPE, (Comparable)((Object)PillarType.values()[stack.func_77952_i() / 4]));
        worldIn.func_180501_a(pos, state, 3);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150899_d((int)0);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        int t = ((PillarType)((Object)state.func_177229_b((IProperty)TYPE))).ordinal();
        if (t == 0) {
            BlockPillar.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(BlocksTC.stone, 2, 0));
        }
        if (t == 1) {
            BlockPillar.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(BlocksTC.stone, 2, 2));
        }
        if (t == 2) {
            BlockPillar.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(BlocksTC.stone, 2, 4));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)TYPE, (Comparable)((Object)PillarType.values()[(meta - enumfacing.ordinal()) / 4]));
    }

    public int func_176201_c(IBlockState state) {
        int baseMeta = ((PillarType)((Object)state.func_177229_b((IProperty)TYPE))).ordinal();
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal() + baseMeta * 4;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING, TYPE});
    }

    @Override
    public String getStateName(IBlockState state, boolean fullName) {
        PillarType type = (PillarType)((Object)state.func_177229_b((IProperty)TYPE));
        return "pillar_" + type.func_176610_l();
    }

    @Override
    public IProperty[] getProperties() {
        return new IProperty[]{TYPE};
    }

    public static enum PillarType implements IStringSerializable
    {
        NORMAL,
        ANCIENT,
        ELDRITCH;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

