/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.devices;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.codechicken.lib.raytracer.ExtendedMOP;
import thaumcraft.codechicken.lib.raytracer.IndexedCuboid6;
import thaumcraft.codechicken.lib.raytracer.RayTracer;
import thaumcraft.codechicken.lib.vec.BlockCoord;
import thaumcraft.codechicken.lib.vec.Cuboid6;
import thaumcraft.codechicken.lib.vec.Vector3;
import thaumcraft.common.blocks.BlockTCDevice;
import thaumcraft.common.blocks.IBlockEnabled;
import thaumcraft.common.items.resources.ItemShard;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.devices.TileDioptra;

public class BlockDioptra
extends BlockTCDevice
implements IBlockEnabled {
    private RayTracer rayTracer = new RayTracer();

    public BlockDioptra() {
        super(Material.field_151575_d, TileDioptra.class);
        this.func_149672_a(Block.field_149766_f);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileDioptra) {
            int d = -1;
            switch (((TileDioptra)tile).type) {
                case 0: {
                    d = 7;
                    break;
                }
                case 1: {
                    d = 0;
                    break;
                }
                case 2: {
                    d = 1;
                    break;
                }
                case 3: {
                    d = 2;
                    break;
                }
                case 4: {
                    d = 3;
                    break;
                }
                case 5: {
                    d = 4;
                    break;
                }
                case 6: {
                    d = 5;
                    break;
                }
                case 7: {
                    d = 6;
                }
            }
            if (d >= 0) {
                InventoryUtils.dropItemAtPos(worldIn, new ItemStack(ItemsTC.shard, 1, d), pos);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        MovingObjectPosition hit = RayTracer.retraceBlock(world, playerIn, pos);
        if (hit == null) {
            return super.func_180639_a(world, pos, state, playerIn, side, hitX, hitY, hitZ);
        }
        TileEntity tile = world.func_175625_s(pos);
        if (hit.subHit == 0 && tile instanceof TileDioptra) {
            int d = -1;
            switch (((TileDioptra)tile).type) {
                case 0: {
                    d = 7;
                    break;
                }
                case 1: {
                    d = 0;
                    break;
                }
                case 2: {
                    d = 1;
                    break;
                }
                case 3: {
                    d = 2;
                    break;
                }
                case 4: {
                    d = 3;
                    break;
                }
                case 5: {
                    d = 4;
                    break;
                }
                case 6: {
                    d = 5;
                    break;
                }
                case 7: {
                    d = 6;
                }
            }
            if (d >= 0) {
                InventoryUtils.dropItemAtEntity(world, new ItemStack(ItemsTC.shard, 1, d), (Entity)playerIn);
            }
            int t = -1;
            if (playerIn.func_70694_bm() != null && playerIn.func_70694_bm().func_77973_b() instanceof ItemShard) {
                switch (playerIn.func_70694_bm().func_77952_i()) {
                    case 0: {
                        t = 1;
                        break;
                    }
                    case 1: {
                        t = 2;
                        break;
                    }
                    case 2: {
                        t = 3;
                        break;
                    }
                    case 3: {
                        t = 4;
                        break;
                    }
                    case 4: {
                        t = 5;
                        break;
                    }
                    case 5: {
                        t = 6;
                        break;
                    }
                    case 7: {
                        t = 0;
                        break;
                    }
                    case 6: {
                        t = 7;
                    }
                }
                if (t >= 0) {
                    --playerIn.func_70694_bm().field_77994_a;
                }
            }
            ((TileDioptra)tile).switchType(playerIn, (byte)t);
            if (d >= 0 || t >= 0) {
                world.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "thaumcraft:crystal", 0.5f, 1.0f);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileDioptra) {
            MovingObjectPosition hit = RayTracer.retraceBlock(world, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, pos);
            if (hit != null && hit.subHit == 0) {
                LinkedList cuboids = new LinkedList();
                Cuboid6 cubeoid = new Cuboid6((double)pos.func_177958_n() + 0.375, (double)pos.func_177956_o() + 0.875, (double)pos.func_177952_p() + 0.375, (double)pos.func_177958_n() + 0.625, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.625);
                Vector3 v = new Vector3(pos);
                Cuboid6 c = cubeoid.sub(v);
                this.func_149676_a((float)c.min.x, (float)c.min.y, (float)c.min.z, (float)c.max.x, (float)c.max.y, (float)c.max.z);
            } else {
                this.func_180654_a((IBlockAccess)world, pos);
            }
        }
        return super.func_180646_a(world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && event.player.field_70170_p.func_180495_p(event.target.func_178782_a()).func_177230_c() == this) {
            RayTracer.retraceBlock(event.player.field_70170_p, event.player, event.target.func_178782_a());
        }
    }

    public MovingObjectPosition func_180636_a(World world, BlockPos pos, Vec3 start, Vec3 end) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !(tile instanceof TileDioptra)) {
            return super.func_180636_a(world, pos, start, end);
        }
        LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
        if (tile instanceof TileDioptra) {
            ((TileDioptra)tile).addTraceableCuboids(cuboids);
        }
        ArrayList<ExtendedMOP> list = new ArrayList<ExtendedMOP>();
        this.rayTracer.rayTraceCuboids(new Vector3(start), new Vector3(end), cuboids, new BlockCoord(pos), this, list);
        return list.size() > 0 ? (MovingObjectPosition)list.get(0) : super.func_180636_a(world, pos, start, end);
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
    }
}

