/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.devices;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.blocks.BlockTC;
import thaumcraft.common.blocks.ItemBlockTC;
import thaumcraft.common.tiles.crafting.TileAlembic;
import thaumcraft.common.tiles.essentia.TileJarFillable;

public class BlockJarItem
extends ItemBlockTC
implements IEssentiaContainerItem {
    public BlockJarItem(Block block) {
        super(block);
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float f1, float f2, float f3) {
        Block bi = world.func_180495_p(pos).func_177230_c();
        if (bi == BlocksTC.alembic && !world.field_72995_K) {
            TileAlembic tile = (TileAlembic)world.func_175625_s(pos);
            if (tile.amount > 0) {
                if (this.getFilter(itemstack) != null && this.getFilter(itemstack) != tile.aspect) {
                    return false;
                }
                if (this.getAspects(itemstack) != null && this.getAspects(itemstack).getAspects()[0] != tile.aspect) {
                    return false;
                }
                int amt = tile.amount;
                if (this.getAspects(itemstack) != null && this.getAspects(itemstack).visSize() + amt > 64) {
                    amt = Math.abs(this.getAspects(itemstack).visSize() - 64);
                }
                if (amt <= 0) {
                    return false;
                }
                Aspect a = tile.aspect;
                if (tile.takeFromContainer(tile.aspect, amt)) {
                    int base;
                    int n = base = this.getAspects(itemstack) == null ? 0 : this.getAspects(itemstack).visSize();
                    if (itemstack.field_77994_a > 1) {
                        ItemStack stack = itemstack.func_77946_l();
                        this.setAspects(stack, new AspectList().add(a, base + amt));
                        --itemstack.field_77994_a;
                        stack.field_77994_a = 1;
                        if (!player.field_71071_by.func_70441_a(stack)) {
                            world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack));
                        }
                    } else {
                        this.setAspects(itemstack, new AspectList().add(a, base + amt));
                    }
                    world.func_72956_a((Entity)player, "game.neutral.swim", 0.25f, 1.0f);
                    player.field_71069_bz.func_75142_b();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        TileEntity te;
        boolean b = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (b && !world.field_72995_K && (te = world.func_175625_s(pos)) != null && te instanceof TileJarFillable) {
            TileJarFillable jar = (TileJarFillable)te;
            jar.setAspects(this.getAspects(stack));
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("AspectFilter")) {
                jar.aspectFilter = Aspect.getAspect(stack.func_77978_p().func_74779_i("AspectFilter"));
            }
            te.func_70296_d();
            world.func_175689_h(pos);
        }
        return b;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("AspectFilter")) {
            String tf = stack.func_77978_p().func_74779_i("AspectFilter");
            Aspect tag = Aspect.getAspect(tf);
            list.add("\u00a75" + tag.getName());
        }
        super.func_77624_a(stack, player, list, par4);
    }

    @Override
    public AspectList getAspects(ItemStack itemstack) {
        if (itemstack.func_77942_o()) {
            AspectList aspects = new AspectList();
            aspects.readFromNBT(itemstack.func_77978_p());
            return aspects.size() > 0 ? aspects : null;
        }
        return null;
    }

    public Aspect getFilter(ItemStack itemstack) {
        if (itemstack.func_77942_o()) {
            return Aspect.getAspect(itemstack.func_77978_p().func_74779_i("AspectFilter"));
        }
        return null;
    }

    @Override
    public void setAspects(ItemStack itemstack, AspectList aspects) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        aspects.writeToNBT(itemstack.func_77978_p());
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int layer) {
        if (this.getAspects(stack) != null) {
            return this.getAspects(stack).getAspects()[0].getColor();
        }
        return super.func_82790_a(stack, layer);
    }

    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        BlockTC block = (BlockTC)this.field_150939_a;
        ModelResourceLocation modelresourcelocation = null;
        if (this.getAspects(stack) != null && this.getAspects(stack).visSize() > 0) {
            modelresourcelocation = this.getAspects(stack).visSize() < 16 ? new ModelResourceLocation("Thaumcraft:" + block.getStateName(block.func_176203_a(stack.func_77960_j()), false) + "_0", "inventory") : (this.getAspects(stack).visSize() < 32 ? new ModelResourceLocation("Thaumcraft:" + block.getStateName(block.func_176203_a(stack.func_77960_j()), false) + "_1", "inventory") : (this.getAspects(stack).visSize() < 48 ? new ModelResourceLocation("Thaumcraft:" + block.getStateName(block.func_176203_a(stack.func_77960_j()), false) + "_2", "inventory") : new ModelResourceLocation("Thaumcraft:" + block.getStateName(block.func_176203_a(stack.func_77960_j()), false) + "_3", "inventory")));
        }
        return modelresourcelocation;
    }

    @Override
    public boolean ignoreContainedAspects() {
        return false;
    }
}

