/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.world.eldritch;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGenericP2P;

public class BlockVacuum
extends Block {
    public static final PropertyInteger SPREAD = PropertyInteger.func_177719_a((String)"spread", (int)0, (int)12);

    public BlockVacuum() {
        super((Material)new MaterialAiry(MapColor.field_151660_b));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SPREAD, (Comparable)Integer.valueOf(0)));
        this.func_149722_s();
        this.field_149781_w = 999.0f;
        this.func_149675_a(true);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SPREAD, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)SPREAD);
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{SPREAD});
    }

    public int func_149645_b() {
        return -1;
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_176214_u() {
        return false;
    }

    public boolean func_149637_q() {
        return true;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return false;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public boolean func_176200_f(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        int spread = state.func_177230_c().func_176201_c(state);
        return spread > 0;
    }

    private void check(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState bs;
            boolean con;
            int spread = state.func_177230_c().func_176201_c(state);
            boolean bl = con = spread == 0;
            if (!con) {
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    if (!worldIn.func_175667_e(pos.func_177972_a(face)) || (bs = worldIn.func_180495_p(pos.func_177972_a(face))).func_177230_c() != this || bs.func_177230_c().func_176201_c(bs) >= spread) continue;
                    con = true;
                    break;
                }
            }
            if (con) {
                if (spread < 12) {
                    for (EnumFacing face : EnumFacing.field_82609_l) {
                        if (!worldIn.func_175667_e(pos.func_177972_a(face)) || ((bs = worldIn.func_180495_p(pos.func_177972_a(face))).func_177230_c() == this || !worldIn.func_175623_d(pos.func_177972_a(face))) && (bs.func_177230_c() != this || bs.func_177230_c().func_176201_c(bs) <= spread + 1)) continue;
                        worldIn.func_175656_a(pos.func_177972_a(face), BlocksTC.vacuum.func_176203_a(spread + 1));
                        worldIn.func_175684_a(pos.func_177972_a(face), (Block)this, 5);
                        break;
                    }
                }
            } else if (spread < 12) {
                worldIn.func_175656_a(pos, BlocksTC.vacuum.func_176203_a(spread + 1));
                worldIn.func_175684_a(pos, (Block)this, 5);
            } else {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.check(worldIn, pos, state);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
    }

    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        int spread = state.func_177230_c().func_176201_c(state);
        return spread * 21;
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        this.check(worldIn, pos, state);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).field_71075_bZ.field_75098_d || !entityIn.func_180431_b(DamageSource.field_76380_i)) {
            return;
        }
        int md = this.func_176201_c(state);
        if (!(worldIn.field_72995_K || md != 0 && entityIn instanceof EntityLiving && ((EntityLiving)entityIn).func_70648_aU() || md != 0 && worldIn.field_73012_v.nextInt(2000) >= 12 - this.func_176201_c(state))) {
            entityIn.func_70097_a(DamageSource.field_76380_i, md == 0 ? 10.0f : 1.0f);
        }
        if (md > 0 && entityIn.func_70104_M()) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                IBlockState bs = worldIn.func_180495_p(pos.func_177972_a(face));
                if (bs.func_177230_c() != this || bs.func_177230_c().func_176201_c(bs) >= md) continue;
                entityIn.field_70159_w += (double)((float)face.func_82601_c() / (25.0f * (float)(md + 1)));
                entityIn.field_70181_x = entityIn.field_70181_x + (double)((float)face.func_96559_d() / ((entityIn instanceof EntityItem ? 1.0f : 10.0f) * (float)(md + 1)));
                entityIn.field_70179_y += (double)((float)face.func_82599_e() / (25.0f * (float)(md + 1)));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        BlockPos p;
        if (this.func_176201_c(state) > 3 && rand.nextInt(500) < this.func_176201_c(state) && (p = this.findSource(worldIn, pos, this.func_176201_c(state))) != pos) {
            FXGenericP2P bp = new FXGenericP2P(worldIn, (float)pos.func_177958_n() + rand.nextFloat(), (float)pos.func_177956_o() + rand.nextFloat(), (float)pos.func_177952_p() + rand.nextFloat(), (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5);
            bp.func_82338_g(0.4f);
            bp.setParticles(48, 14, 1);
            bp.setLoop(true);
            bp.setScale(3.0f);
            bp.setLayer(0);
            ParticleEngine.instance.addEffect(worldIn, bp);
            if (rand.nextInt(33) == 0) {
                worldIn.func_72980_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "thaumcraft:wind", 0.33f, 1.0f, true);
            }
        }
    }

    BlockPos findSource(World worldIn, BlockPos pos, int spread) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            IBlockState bs = worldIn.func_180495_p(pos.func_177972_a(face));
            if (bs.func_177230_c() != this || bs.func_177230_c().func_176201_c(bs) >= spread) continue;
            return this.findSource(worldIn, pos.func_177972_a(face), bs.func_177230_c().func_176201_c(bs));
        }
        return pos;
    }

    public static class MaterialAiry
    extends Material {
        public MaterialAiry(MapColor par1MapColor) {
            super(par1MapColor);
        }

        public boolean func_76220_a() {
            return false;
        }

        public boolean func_76228_b() {
            return true;
        }

        public boolean func_76222_j() {
            return false;
        }

        public boolean func_76230_c() {
            return false;
        }
    }
}

