/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.construct.EntityOwnedConstruct;
import thaumcraft.common.items.wands.ItemWand;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.Utils;

public class EntityTurretFocus
extends EntityOwnedConstruct {
    protected AspectList vis = new AspectList();
    protected int maxVis = 100;
    protected int attackTimer = 10;
    boolean attackedLastTick = false;
    int attackCount = 0;

    public EntityTurretFocus(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 0.9f);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchTarget((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 12.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestValidTarget(this, EntityLivingBase.class, 5, true, false, null));
        this.setTargetMob(true);
        this.field_70728_aV = 6;
    }

    public EntityTurretFocus(World worldIn, BlockPos pos, EnumFacing face) {
        this(worldIn);
        this.func_70080_a((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
        this.setFacing(face);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)new ItemStack(ItemsTC.wand));
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    @Override
    public boolean func_142014_c(EntityLivingBase otherEntity) {
        return this.func_142012_a(otherEntity.func_96124_cp());
    }

    @Override
    public Team func_96124_cp() {
        EntityLivingBase entitylivingbase;
        if (this.isOwned() && (entitylivingbase = this.getOwnerEntity()) != null) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public int func_70658_aO() {
        return 4;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.doUpdateStuff();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70177_z = this.field_70759_as;
            if (this.field_70173_aa % 4 == 0) {
                this.rechargeVis();
            }
            if (this.field_70173_aa % 40 == 0) {
                this.func_70691_i(1.0f);
            }
            if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            boolean at = this.attackedLastTick;
            this.attackedLastTick = false;
            if (this.func_70638_az() != null && this.attackTimer <= 0) {
                this.attackEntityWithFocus();
            }
            if (at && !this.attackedLastTick) {
                this.attackCount = 0;
            }
        }
    }

    protected void doUpdateStuff() {
        if (this.func_70638_az() != null && this.func_70638_az() instanceof EntityTurretFocus && !this.getTargetFriendly()) {
            this.func_70624_b(null);
        }
        if (!this.field_70170_p.field_72995_K && !MinecraftServer.func_71276_C().func_71219_W() && this.func_70638_az() != null && this.func_70638_az() instanceof EntityPlayer && this.func_70638_az() != this.getOwnerEntity()) {
            this.func_70624_b(null);
        }
    }

    public void func_70030_z() {
        if (this.func_70115_ae()) {
            this.field_70163_u += 1.0;
        }
        super.func_70030_z();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 16 && this.func_70694_bm() != null && this.func_70694_bm().func_77973_b() != null && this.func_70694_bm().func_77973_b() instanceof ItemFocusBasic) {
            ((ItemFocusBasic)this.func_70694_bm().func_77973_b()).onFocusActivation(this.getWand(), this.field_70170_p, (EntityLivingBase)this, this.getMovingObjectPosition(), this.attackCount);
        } else {
            super.func_70103_a(par1);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.field_70177_z = (float)((double)this.field_70177_z + this.func_70681_au().nextGaussian() * 45.0);
        this.field_70125_A = (float)((double)this.field_70125_A + this.func_70681_au().nextGaussian() * 20.0);
        return super.func_70097_a(source, amount);
    }

    protected void attackEntityWithFocus() {
        if (this.func_70694_bm() != null && this.func_70694_bm().func_77973_b() != null && this.func_70694_bm().func_77973_b() instanceof ItemFocusBasic) {
            ItemFocusBasic focus = (ItemFocusBasic)this.func_70694_bm().func_77973_b();
            double dis = this.func_70032_d((Entity)this.func_70638_az());
            if (dis > (double)focus.getTurretRange(this.func_70694_bm()) || !EntityUtils.isVisibleTo(0.3f, (Entity)this, (Entity)this.func_70638_az(), focus.getTurretRange(this.func_70694_bm()))) {
                return;
            }
            AspectList cost = focus.getVisCost(this.func_70694_bm());
            if (this.consumeVis(cost, false)) {
                float d = (float)(dis / (double)focus.getTurretRange(this.func_70694_bm()));
                this.field_70125_A -= focus.getTurretCorrection(this.func_70694_bm()) * d;
                if (focus.onFocusActivation(this.getWand(), this.field_70170_p, (EntityLivingBase)this, this.getMovingObjectPosition(), this.attackCount)) {
                    this.consumeVis(cost, true);
                    this.attackTimer = focus.getActivationCooldown(this.func_70694_bm()) / 50;
                    if (!focus.isVisCostPerTick(this.func_70694_bm())) {
                        this.attackTimer = (int)((double)this.attackTimer * 1.33);
                    }
                    this.field_70125_A += focus.getTurretCorrection(this.func_70694_bm()) * d;
                    this.attackedLastTick = true;
                    ++this.attackCount;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)16);
                }
            }
        }
    }

    protected boolean consumeVis(AspectList aspects, boolean doit) {
        int cost;
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (aspects == null || aspects.size() == 0) {
            return false;
        }
        for (Aspect aspect : aspects.getAspects()) {
            cost = aspects.getAmount(aspect);
            if (this.vis.getAmount(aspect) >= cost) continue;
            return false;
        }
        if (doit) {
            for (Aspect aspect : aspects.getAspects()) {
                cost = aspects.getAmount(aspect);
                this.vis.remove(aspect, cost);
            }
        }
        return true;
    }

    protected void rechargeVis() {
        Aspect low = null;
        int amt = Integer.MAX_VALUE;
        for (Aspect aspect : Aspect.getPrimalAspects()) {
            if (this.vis.getAmount(aspect) >= this.maxVis || this.vis.getAmount(aspect) >= amt || AuraHandler.getAuraCurrent(this.field_70170_p, this.func_180425_c(), aspect) <= 0) continue;
            low = aspect;
            amt = this.vis.getAmount(aspect);
        }
        if (low != null) {
            this.vis.add(low, AuraHandler.drainAuraAvailable(this.field_70170_p, this.func_180425_c(), low, 1));
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.vis.readFromNBT(nbt);
        this.setFacing(EnumFacing.field_82609_l[nbt.func_74771_c("face")]);
        this.field_70180_af.func_75692_b(20, (Object)nbt.func_74771_c("targets"));
        this.updateFocus();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.vis.writeToNBT(nbt);
        nbt.func_74774_a("face", (byte)this.getFacing().ordinal());
        nbt.func_74774_a("targets", this.field_70180_af.func_75683_a(20));
    }

    public EnumFacing getFacing() {
        return EnumFacing.field_82609_l[this.field_70180_af.func_75683_a(19)];
    }

    public void setFacing(EnumFacing face) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)face.ordinal()));
    }

    public void func_70091_d(double x, double y, double z) {
    }

    public void func_70060_a(float strafe, float forward, float friction) {
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.isOwner((EntityLivingBase)player)) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IWand) {
                this.func_85030_a("thaumcraft:zap", 1.0f, 1.0f);
                this.dropFocus();
                this.func_70099_a(new ItemStack(ItemsTC.turretPlacer, 1, 1), 0.5f);
                this.func_70106_y();
                player.func_71038_i();
            } else {
                player.openGui((Object)Thaumcraft.instance, 15, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropFocus();
        }
    }

    protected void dropFocus() {
        if (this.func_70694_bm() != null) {
            this.func_70099_a(this.func_70694_bm(), 0.0f);
        }
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        float b = (float)p_70628_2_ * 0.15f;
        if (this.field_70146_Z.nextFloat() < 0.2f + b) {
            this.func_70099_a(new ItemStack(ItemsTC.mind, 1, 1), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.5f + b) {
            this.func_70099_a(new ItemStack(ItemsTC.gear), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.5f + b) {
            this.func_70099_a(new ItemStack(BlocksTC.plank), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.5f + b) {
            this.func_70099_a(new ItemStack(BlocksTC.plank), 0.5f);
        }
    }

    public ItemStack getWand() {
        return this.field_70180_af.func_82710_f(18);
    }

    public void setWand(ItemStack ws) {
        this.field_70180_af.func_75692_b(18, (Object)ws);
    }

    public void updateFocus() {
        ItemStack wand = new ItemStack(ItemsTC.wand);
        ItemWand ws = (ItemWand)wand.func_77973_b();
        ws.setCap(wand, ConfigItems.WAND_CAP_GOLD);
        ws.setRod(wand, ConfigItems.WAND_ROD_GREATWOOD);
        if (this.func_70694_bm() != null) {
            ws.setFocus(wand, this.func_70694_bm());
            ItemFocusBasic focus = (ItemFocusBasic)this.func_70694_bm().func_77973_b();
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)focus.getTurretRange(this.func_70694_bm()));
        }
        this.setWand(wand);
    }

    protected MovingObjectPosition getMovingObjectPosition() {
        float f = this.field_70127_C + (this.field_70125_A - this.field_70127_C);
        float f1 = this.field_70126_B + (this.field_70177_z - this.field_70126_B);
        double d0 = this.field_70169_q + (this.field_70165_t - this.field_70169_q);
        double d1 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) + (double)this.func_70047_e();
        double d2 = this.field_70166_s + (this.field_70161_v - this.field_70166_s);
        Vec3 vec3 = new Vec3(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = 5.0;
        Vec3 vec31 = vec3.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return this.field_70170_p.func_147447_a(vec3, vec31, true, false, false);
    }

    public int func_70646_bf() {
        return 20;
    }

    public boolean func_70686_a(Class clazz) {
        if (IAnimals.class.isAssignableFrom(clazz) && !IMob.class.isAssignableFrom(clazz) && this.getTargetAnimal()) {
            return true;
        }
        if (IMob.class.isAssignableFrom(clazz) && this.getTargetMob()) {
            return true;
        }
        if (EntityPlayer.class.isAssignableFrom(clazz) && this.getTargetPlayer()) {
            if (!(this.field_70170_p.field_72995_K || MinecraftServer.func_71276_C().func_71219_W() || this.getTargetFriendly())) {
                this.setTargetPlayer(false);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean getTargetAnimal() {
        return Utils.getBit(this.field_70180_af.func_75683_a(20), 0);
    }

    public void setTargetAnimal(boolean par1) {
        byte var2 = this.field_70180_af.func_75683_a(20);
        if (par1) {
            this.field_70180_af.func_75692_b(20, (Object)((byte)Utils.setBit(var2, 0)));
        } else {
            this.field_70180_af.func_75692_b(20, (Object)((byte)Utils.clearBit(var2, 0)));
        }
        this.func_70624_b(null);
    }

    public boolean getTargetMob() {
        return Utils.getBit(this.field_70180_af.func_75683_a(20), 1);
    }

    public void setTargetMob(boolean par1) {
        byte var2 = this.field_70180_af.func_75683_a(20);
        if (par1) {
            this.field_70180_af.func_75692_b(20, (Object)((byte)Utils.setBit(var2, 1)));
        } else {
            this.field_70180_af.func_75692_b(20, (Object)((byte)Utils.clearBit(var2, 1)));
        }
        this.func_70624_b(null);
    }

    public boolean getTargetPlayer() {
        return Utils.getBit(this.field_70180_af.func_75683_a(20), 2);
    }

    public void setTargetPlayer(boolean par1) {
        byte var2 = this.field_70180_af.func_75683_a(20);
        if (par1) {
            this.field_70180_af.func_75692_b(20, (Object)((byte)Utils.setBit(var2, 2)));
        } else {
            this.field_70180_af.func_75692_b(20, (Object)((byte)Utils.clearBit(var2, 2)));
        }
        this.func_70624_b(null);
    }

    public boolean getTargetFriendly() {
        return Utils.getBit(this.field_70180_af.func_75683_a(20), 3);
    }

    public void setTargetFriendly(boolean par1) {
        byte var2 = this.field_70180_af.func_75683_a(20);
        if (par1) {
            this.field_70180_af.func_75692_b(20, (Object)((byte)Utils.setBit(var2, 3)));
        } else {
            this.field_70180_af.func_75692_b(20, (Object)((byte)Utils.clearBit(var2, 3)));
        }
        this.func_70624_b(null);
    }

    protected class EntityAINearestValidTarget
    extends EntityAITarget {
        protected final Class targetClass;
        private final int targetChance;
        protected final EntityAINearestAttackableTarget.Sorter theNearestAttackableTargetSorter;
        protected Predicate targetEntitySelector;
        protected EntityLivingBase targetEntity;
        private int targetUnseenTicks;

        public EntityAINearestValidTarget(EntityCreature p_i45878_1_, Class p_i45878_2_, boolean p_i45878_3_) {
            this(p_i45878_1_, p_i45878_2_, p_i45878_3_, false);
        }

        public EntityAINearestValidTarget(EntityCreature p_i45879_1_, Class p_i45879_2_, boolean p_i45879_3_, boolean p_i45879_4_) {
            this(p_i45879_1_, p_i45879_2_, 10, p_i45879_3_, p_i45879_4_, null);
        }

        public EntityAINearestValidTarget(EntityCreature p_i45880_1_, Class p_i45880_2_, int p_i45880_3_, boolean p_i45880_4_, boolean p_i45880_5_, final Predicate tselector) {
            super(p_i45880_1_, p_i45880_4_, p_i45880_5_);
            this.targetClass = p_i45880_2_;
            this.targetChance = p_i45880_3_;
            this.theNearestAttackableTargetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)p_i45880_1_);
            this.func_75248_a(1);
            this.targetEntitySelector = new Predicate(){
                private static final String __OBFID = "CL_00001621";

                public boolean applySelection(EntityLivingBase entity) {
                    if (tselector != null && !tselector.apply((Object)entity)) {
                        return false;
                    }
                    if (entity instanceof EntityPlayer) {
                        double d0 = EntityAINearestValidTarget.this.func_111175_f();
                        if (entity.func_70093_af()) {
                            d0 *= (double)0.8f;
                        }
                        if (entity.func_82150_aj()) {
                            float f = ((EntityPlayer)entity).func_82243_bO();
                            if (f < 0.1f) {
                                f = 0.1f;
                            }
                            d0 *= (double)(0.7f * f);
                        }
                        if ((double)entity.func_70032_d((Entity)EntityAINearestValidTarget.this.field_75299_d) > d0) {
                            return false;
                        }
                    }
                    return EntityAINearestValidTarget.this.func_75296_a(entity, false);
                }

                public boolean apply(Object p_apply_1_) {
                    return this.applySelection((EntityLivingBase)p_apply_1_);
                }
            };
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.field_75299_d.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            Team team = this.field_75299_d.func_96124_cp();
            Team team1 = entitylivingbase.func_96124_cp();
            if (team != null && team1 == team && !((EntityTurretFocus)this.field_75299_d).getTargetFriendly()) {
                return false;
            }
            if (team != null && team1 != team && ((EntityTurretFocus)this.field_75299_d).getTargetFriendly()) {
                return false;
            }
            double d0 = this.func_111175_f();
            if (this.field_75299_d.func_70068_e((Entity)entitylivingbase) > d0 * d0) {
                return false;
            }
            if (this.field_75297_f) {
                if (this.field_75299_d.func_70635_at().func_75522_a((Entity)entitylivingbase)) {
                    this.targetUnseenTicks = 0;
                } else if (++this.targetUnseenTicks > 60) {
                    return false;
                }
            }
            return true;
        }

        protected boolean func_75296_a(EntityLivingBase p_75296_1_, boolean p_75296_2_) {
            if (!this.isGoodTarget((EntityLiving)this.field_75299_d, p_75296_1_, p_75296_2_, this.field_75297_f)) {
                return false;
            }
            return this.field_75299_d.func_180485_d(new BlockPos((Entity)p_75296_1_));
        }

        private boolean isGoodTarget(EntityLiving attacker, EntityLivingBase posTar, boolean p_179445_2_, boolean checkSight) {
            if (posTar == null) {
                return false;
            }
            if (posTar == attacker) {
                return false;
            }
            if (!posTar.func_70089_S()) {
                return false;
            }
            if (!attacker.func_70686_a(posTar.getClass())) {
                return false;
            }
            Team team = attacker.func_96124_cp();
            Team team1 = posTar.func_96124_cp();
            if (team != null && team1 == team && !((EntityTurretFocus)attacker).getTargetFriendly()) {
                return false;
            }
            if (team != null && team1 != team && ((EntityTurretFocus)attacker).getTargetFriendly()) {
                return false;
            }
            if (attacker instanceof IEntityOwnable && StringUtils.isNotEmpty((CharSequence)((IEntityOwnable)attacker).func_152113_b())) {
                if (posTar instanceof IEntityOwnable && ((IEntityOwnable)attacker).func_152113_b().equals(((IEntityOwnable)posTar).func_152113_b()) && !((EntityTurretFocus)attacker).getTargetFriendly()) {
                    return false;
                }
                if (!(posTar instanceof IEntityOwnable) && !(posTar instanceof EntityPlayer) && ((EntityTurretFocus)attacker).getTargetFriendly()) {
                    return false;
                }
                if (posTar instanceof IEntityOwnable && !((IEntityOwnable)attacker).func_152113_b().equals(((IEntityOwnable)posTar).func_152113_b()) && ((EntityTurretFocus)attacker).getTargetFriendly()) {
                    return false;
                }
                if (posTar == ((IEntityOwnable)attacker).func_70902_q() && !((EntityTurretFocus)attacker).getTargetFriendly()) {
                    return false;
                }
            } else if (posTar instanceof EntityPlayer && !p_179445_2_ && ((EntityPlayer)posTar).field_71075_bZ.field_75102_a && !((EntityTurretFocus)attacker).getTargetFriendly()) {
                return false;
            }
            return !checkSight || attacker.func_70635_at().func_75522_a((Entity)posTar);
        }

        public boolean func_75250_a() {
            if (this.targetChance > 0 && this.field_75299_d.func_70681_au().nextInt(this.targetChance) != 0) {
                return false;
            }
            double d0 = this.func_111175_f();
            List list = this.field_75299_d.field_70170_p.func_175647_a(this.targetClass, this.field_75299_d.func_174813_aQ().func_72314_b(d0, 4.0, d0), Predicates.and((Predicate)this.targetEntitySelector, (Predicate)IEntitySelector.field_180132_d));
            Collections.sort(list, this.theNearestAttackableTargetSorter);
            if (list.isEmpty()) {
                return false;
            }
            this.targetEntity = (EntityLivingBase)list.get(0);
            return true;
        }

        public void func_75249_e() {
            this.field_75299_d.func_70624_b(this.targetEntity);
            this.targetUnseenTicks = 0;
            super.func_75249_e();
        }

        public class Sorter
        implements Comparator {
            private final Entity theEntity;
            private static final String __OBFID = "CL_00001622";

            public Sorter(Entity p_i1662_1_) {
                this.theEntity = p_i1662_1_;
            }

            public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                double d1;
                double d0 = this.theEntity.func_70068_e(p_compare_1_);
                return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
            }

            public int compare(Object p_compare_1_, Object p_compare_2_) {
                return this.compare((Entity)p_compare_1_, (Entity)p_compare_2_);
            }
        }
    }

    protected class EntityAIWatchTarget
    extends EntityAIBase {
        protected EntityLiving theWatcher;
        protected Entity closestEntity;
        private int lookTime;

        public EntityAIWatchTarget(EntityLiving p_i1631_1_) {
            this.theWatcher = p_i1631_1_;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            if (this.theWatcher.func_70638_az() != null) {
                this.closestEntity = this.theWatcher.func_70638_az();
            }
            return this.closestEntity != null;
        }

        public boolean func_75253_b() {
            float d = (float)this.getTargetDistance();
            return !this.closestEntity.func_70089_S() ? false : (this.theWatcher.func_70068_e(this.closestEntity) > (double)(d * d) ? false : this.lookTime > 0);
        }

        public void func_75249_e() {
            this.lookTime = 40 + this.theWatcher.func_70681_au().nextInt(40);
        }

        public void func_75251_c() {
            this.closestEntity = null;
        }

        public void func_75246_d() {
            this.theWatcher.func_70671_ap().func_75650_a(this.closestEntity.field_70165_t, this.closestEntity.field_70163_u + (double)this.closestEntity.func_70047_e(), this.closestEntity.field_70161_v, 10.0f, (float)this.theWatcher.func_70646_bf());
            --this.lookTime;
        }

        protected double getTargetDistance() {
            IAttributeInstance iattributeinstance = this.theWatcher.func_110148_a(SharedMonsterAttributes.field_111265_b);
            return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
        }
    }
}

