/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thaumcraft.common.entities.construct.golem.gui.GuiCategoryButton;
import thaumcraft.common.entities.construct.golem.gui.GuiGolemToggleButton;
import thaumcraft.common.entities.construct.golem.gui.GuiPlusMinusButton;
import thaumcraft.common.entities.construct.golem.gui.SealBaseContainer;
import thaumcraft.common.entities.construct.golem.seals.ISealConfigFilter;
import thaumcraft.common.entities.construct.golem.seals.ISealConfigProperties;
import thaumcraft.common.entities.construct.golem.seals.ISealGui;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;

@SideOnly(value=Side.CLIENT)
public class SealBaseGUI
extends GuiContainer {
    SealEntity seal;
    int middleX;
    int middleY;
    int category = -1;
    int[] categories;
    ResourceLocation tex = new ResourceLocation("thaumcraft", "textures/gui/gui_base.png");

    public SealBaseGUI(InventoryPlayer player, World world, SealEntity seal) {
        super((Container)new SealBaseContainer(player, world, seal));
        this.seal = seal;
        this.field_146999_f = 176;
        this.field_147000_g = 232;
        this.middleX = this.field_146999_f / 2;
        this.middleY = (this.field_147000_g - 72) / 2 - 8;
        this.categories = seal.getSeal() instanceof ISealGui ? ((ISealGui)((Object)seal.getSeal())).getGuiCategories() : new int[]{0};
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.setupCategories();
    }

    private void setupCategories() {
        this.field_146292_n.clear();
        int c = 0;
        float slice = 60.0f / (float)this.categories.length;
        float start = -180.0f + (float)(this.categories.length - 1) * slice / 2.0f;
        if (slice > 24.0f) {
            slice = 24.0f;
        }
        if (slice < 12.0f) {
            slice = 12.0f;
        }
        for (int cat : this.categories) {
            if (this.category < 0) {
                this.category = cat;
            }
            if (this.categories.length > 1) {
                int xx = (int)(MathHelper.func_76134_b((float)((start - (float)c * slice) / 180.0f * (float)Math.PI)) * 86.0f);
                int yy = (int)(MathHelper.func_76126_a((float)((start - (float)c * slice) / 180.0f * (float)Math.PI)) * 86.0f);
                this.field_146292_n.add(new GuiCategoryButton(c, this.field_147003_i + this.middleX + xx, this.field_147009_r + this.middleY + yy, 16, 16, "button.category." + cat, cat, this.category == cat));
            }
            ++c;
        }
        switch (this.category) {
            case 0: {
                this.field_146292_n.add(new GuiPlusMinusButton(80, this.field_147003_i + this.middleX - 5 - 14, this.field_147009_r + this.middleY - 5, 10, 10, true));
                this.field_146292_n.add(new GuiPlusMinusButton(81, this.field_147003_i + this.middleX - 5 + 14, this.field_147009_r + this.middleY - 5, 10, 10, false));
                break;
            }
            case 2: {
                this.field_146292_n.add(new GuiPlusMinusButton(90, this.field_147003_i + this.middleX - 5 - 14, this.field_147009_r + this.middleY - 25, 10, 10, true));
                this.field_146292_n.add(new GuiPlusMinusButton(91, this.field_147003_i + this.middleX - 5 + 14, this.field_147009_r + this.middleY - 25, 10, 10, false));
                this.field_146292_n.add(new GuiPlusMinusButton(92, this.field_147003_i + this.middleX - 5 - 14, this.field_147009_r + this.middleY, 10, 10, true));
                this.field_146292_n.add(new GuiPlusMinusButton(93, this.field_147003_i + this.middleX - 5 + 14, this.field_147009_r + this.middleY, 10, 10, false));
                this.field_146292_n.add(new GuiPlusMinusButton(94, this.field_147003_i + this.middleX - 5 - 14, this.field_147009_r + this.middleY + 25, 10, 10, true));
                this.field_146292_n.add(new GuiPlusMinusButton(95, this.field_147003_i + this.middleX - 5 + 14, this.field_147009_r + this.middleY + 25, 10, 10, false));
                break;
            }
            case 3: {
                if (!(this.seal.getSeal() instanceof ISealConfigProperties)) break;
                ISealConfigProperties cp = (ISealConfigProperties)((Object)this.seal.getSeal());
                int h = (cp.getProperties().length - 1) * 7;
                int p = 0;
                for (ISealConfigProperties.SealProp prop : cp.getProperties()) {
                    this.field_146292_n.add(new GuiGolemToggleButton(30 + p, this.field_147003_i + this.middleX - 36, this.field_147009_r + this.middleY - 5 - h + p * 14, 8, 8, prop.getName(), prop.getValue()));
                    ++p;
                }
                break;
            }
        }
    }

    protected boolean func_146983_a(int par1) {
        return false;
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.field_146297_k.field_71446_o.func_110577_a(this.tex);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i + this.middleX - 80, this.field_147009_r + this.middleY - 80, 96, 0, 160, 160);
        this.func_73729_b(this.field_147003_i, this.field_147009_r + 143, 0, 167, 176, 89);
        this.func_73732_a(this.field_146289_q, StatCollector.func_74838_a((String)("button.category." + this.category)), this.field_147003_i + this.middleX, this.field_147009_r + this.middleY - 64, 0xFFFFFF);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.field_146297_k.field_71446_o.func_110577_a(this.tex);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (this.category) {
            case 0: {
                this.func_73732_a(this.field_146289_q, "" + this.seal.getPriority(), this.field_147003_i + this.middleX, this.field_147009_r + this.middleY - 4, 0xFFFFFF);
                break;
            }
            case 1: {
                if (!(this.seal.getSeal() instanceof ISealConfigFilter)) break;
                int s = ((ISealConfigFilter)((Object)this.seal.getSeal())).getFilterSize();
                int sx = 16 + (s - 1) % 3 * 12;
                int sy = 16 + (s - 1) / 3 * 12;
                for (int a = 0; a < s; ++a) {
                    int x = a % 3;
                    int y = a / 3;
                    this.func_73729_b(this.field_147003_i + this.middleX + x * 24 - sx, this.field_147009_r + this.middleY + y * 24 - sy, 0, 56, 32, 32);
                }
                break;
            }
            case 2: {
                this.func_73732_a(this.field_146289_q, StatCollector.func_74838_a((String)"button.caption.y"), this.field_147003_i + this.middleX, this.field_147009_r + this.middleY - 24 - 9, 0xDDDDDD);
                this.func_73732_a(this.field_146289_q, StatCollector.func_74838_a((String)"button.caption.x"), this.field_147003_i + this.middleX, this.field_147009_r + this.middleY - 9, 0xDDDDDD);
                this.func_73732_a(this.field_146289_q, StatCollector.func_74838_a((String)"button.caption.z"), this.field_147003_i + this.middleX, this.field_147009_r + this.middleY + 24 - 9, 0xDDDDDD);
                this.func_73732_a(this.field_146289_q, "" + this.seal.getArea().func_177956_o(), this.field_147003_i + this.middleX, this.field_147009_r + this.middleY - 24, 0xFFFFFF);
                this.func_73732_a(this.field_146289_q, "" + this.seal.getArea().func_177958_n(), this.field_147003_i + this.middleX, this.field_147009_r + this.middleY, 0xFFFFFF);
                this.func_73732_a(this.field_146289_q, "" + this.seal.getArea().func_177952_p(), this.field_147003_i + this.middleX, this.field_147009_r + this.middleY + 24, 0xFFFFFF);
            }
        }
        GL11.glDisable((int)3042);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k < this.categories.length && this.categories[button.field_146127_k] != this.category) {
            ((SealBaseContainer)this.field_147002_h).category = this.category = this.categories[button.field_146127_k];
            ((SealBaseContainer)this.field_147002_h).setupCategories();
            this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, button.field_146127_k);
            this.setupCategories();
        } else if (this.category == 3 && this.seal.getSeal() instanceof ISealConfigProperties && button.field_146127_k >= 30 && button.field_146127_k < 30 + ((ISealConfigProperties)((Object)this.seal.getSeal())).getProperties().length) {
            ISealConfigProperties cp = (ISealConfigProperties)((Object)this.seal.getSeal());
            cp.setProperty(button.field_146127_k - 30, !cp.getProperties()[button.field_146127_k - 30].getValue());
            this.setupCategories();
            this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, button.field_146127_k);
        } else {
            this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, button.field_146127_k);
        }
    }
}

