/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import thaumcraft.api.internal.WorldCoordinates;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.entities.construct.golem.IGolemAPI;
import thaumcraft.common.entities.construct.golem.seals.ISeal;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;
import thaumcraft.common.entities.construct.golem.tasks.Task;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;

public class SealCobbler
implements ISeal {
    int delay = 0;
    static ArrayList<WorldCoordinates> taskLocs = new ArrayList();
    private static final ItemStack item = new ItemStack(ItemsTC.seals, 1, 2);

    @Override
    public String getKey() {
        return "Thaumcraft:cobbler";
    }

    @Override
    public void tickSeal(World world, SealEntity seal) {
        ++this.delay;
        int x = this.delay / 17 % 17;
        int z = this.delay % 17;
        for (int y = 2; y >= -2; --y) {
            BlockPos p = seal.sealPos.pos.func_177982_a(x - 8, y, z - 8);
            WorldCoordinates wc = new WorldCoordinates(p, world.field_73011_w.func_177502_q());
            if (world.func_180495_p(p).func_177230_c() != Blocks.field_150347_e || taskLocs.contains(wc)) continue;
            taskLocs.add(wc);
            TaskHandler.addTask(world.field_73011_w.func_177502_q(), new Task(seal.sealPos, p, true));
        }
    }

    @Override
    public boolean onTaskCompletion(World world, IGolemAPI golem, Task task) {
        world.func_175655_b(task.getPos(), false);
        task.setSuspended(true);
        return true;
    }

    @Override
    public boolean canGolemPerformTask(IGolemAPI golem, Task task) {
        return true;
    }

    @Override
    public void onTaskSuspension(World world, Task task) {
        taskLocs.remove(new WorldCoordinates(task.getPos(), world.field_73011_w.func_177502_q()));
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
    }

    @Override
    public boolean canPlaceAt(World world, BlockPos pos, EnumFacing side) {
        return !world.func_175623_d(pos);
    }

    @Override
    public ItemStack getSealItem() {
        return item;
    }

    @Override
    public void onRemoval(World world, BlockPos pos, EnumFacing side) {
    }

    @Override
    public Object returnContainer(World world, EntityPlayer player, BlockPos pos, EnumFacing side, SealEntity seal) {
        return null;
    }

    @Override
    public Object returnGui(World world, EntityPlayer player, BlockPos pos, EnumFacing side, SealEntity seal) {
        return null;
    }
}

