/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.entities.construct.golem.IGolemAPI;
import thaumcraft.common.entities.construct.golem.gui.SealBaseContainer;
import thaumcraft.common.entities.construct.golem.gui.SealBaseGUI;
import thaumcraft.common.entities.construct.golem.seals.ISeal;
import thaumcraft.common.entities.construct.golem.seals.ISealConfigFilter;
import thaumcraft.common.entities.construct.golem.seals.ISealGui;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;
import thaumcraft.common.entities.construct.golem.tasks.Task;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;
import thaumcraft.common.lib.utils.InventoryUtils;

public class SealEmpty
implements ISeal,
ISealGui,
ISealConfigFilter {
    int delay = 0;
    private static final ItemStack item = new ItemStack(ItemsTC.seals, 1, 4);
    ItemStack[] filter = new ItemStack[this.getFilterSize()];

    @Override
    public String getKey() {
        return "Thaumcraft:empty";
    }

    @Override
    public void tickSeal(World world, SealEntity seal) {
        if (this.delay++ % 20 != 0) {
            return;
        }
        TileEntity te = world.func_175625_s(seal.sealPos.pos);
        if (te != null && te instanceof IInventory) {
            Task task = new Task(seal.sealPos, seal.sealPos.pos, true);
            task.setPriority(seal.getPriority());
            task.setLifespan((short)1);
            TaskHandler.addTask(world.field_73011_w.func_177502_q(), task);
        }
    }

    @Override
    public boolean onTaskCompletion(World world, IGolemAPI golem, Task task) {
        TileEntity te = world.func_175625_s(task.getSealPos().pos);
        if (te != null && te instanceof IInventory) {
            ItemStack stack = null;
            if (this.filter[0] != null) {
                if (InventoryUtils.inventoryContains((IInventory)te, this.filter[0], task.getSealPos().face, false, false, false)) {
                    stack = this.filter[0].func_77946_l();
                }
                stack.field_77994_a = stack.func_77976_d();
            } else {
                stack = InventoryUtils.getFirstItemInInventory((IInventory)te, -99, task.getSealPos().face, false);
            }
            if (stack != null && golem.canCarry(stack, true)) {
                ItemStack q;
                ItemStack s = golem.holdItem(InventoryUtils.extractStack((IInventory)te, stack, task.getSealPos().face, false, false, false, true));
                if (s != null && (q = InventoryUtils.placeItemStackIntoInventory(s, (IInventory)te, task.getSealPos().face, true)) != null) {
                    ((Entity)golem).func_70099_a(q, 0.25f);
                }
                world.func_72956_a((Entity)golem, "random.pop", 0.125f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        task.setSuspended(true);
        return true;
    }

    @Override
    public boolean canGolemPerformTask(IGolemAPI golem, Task task) {
        TileEntity te = golem.getGolemWorld().func_175625_s(task.getSealPos().pos);
        if (te != null && te instanceof IInventory) {
            ItemStack stack = null;
            if (this.filter[0] != null) {
                if (InventoryUtils.inventoryContains((IInventory)te, this.filter[0], task.getSealPos().face, false, false, false)) {
                    stack = this.filter[0].func_77946_l();
                }
            } else {
                stack = InventoryUtils.getFirstItemInInventory((IInventory)te, -99, task.getSealPos().face, false);
            }
            return stack != null && golem.canCarry(stack, true);
        }
        return false;
    }

    @Override
    public void onTaskSuspension(World world, Task task) {
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.filter = new ItemStack[this.getFilterSize()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.filter.length) continue;
            this.filter[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.filter.length; ++i) {
            if (this.filter[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.filter[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    public void onRemoval(World world, BlockPos pos, EnumFacing side) {
    }

    @Override
    public boolean canPlaceAt(World world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        return te != null && te instanceof IInventory;
    }

    @Override
    public ItemStack getSealItem() {
        return item;
    }

    @Override
    public Object returnContainer(World world, EntityPlayer player, BlockPos pos, EnumFacing side, SealEntity seal) {
        return new SealBaseContainer(player.field_71071_by, world, seal);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object returnGui(World world, EntityPlayer player, BlockPos pos, EnumFacing side, SealEntity seal) {
        return new SealBaseGUI(player.field_71071_by, world, seal);
    }

    @Override
    public int[] getGuiCategories() {
        return new int[]{1, 0};
    }

    @Override
    public int getFilterSize() {
        return 1;
    }

    @Override
    public ItemStack[] getInv() {
        return this.filter;
    }

    @Override
    public ItemStack getFilterSlot(int i) {
        return this.filter[i];
    }

    @Override
    public void setFilterSlot(int i, ItemStack stack) {
        this.filter[i] = stack.func_77946_l();
    }
}

