/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.entities.construct.golem.IGolemAPI;
import thaumcraft.common.entities.construct.golem.gui.SealBaseContainer;
import thaumcraft.common.entities.construct.golem.gui.SealBaseGUI;
import thaumcraft.common.entities.construct.golem.seals.ISeal;
import thaumcraft.common.entities.construct.golem.seals.ISealConfigArea;
import thaumcraft.common.entities.construct.golem.seals.ISealConfigFilter;
import thaumcraft.common.entities.construct.golem.seals.ISealGui;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;
import thaumcraft.common.entities.construct.golem.tasks.Task;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;
import thaumcraft.common.lib.utils.InventoryUtils;

public class SealPickup
implements ISeal,
ISealGui,
ISealConfigArea,
ISealConfigFilter {
    int delay = 0;
    static HashMap<Integer, HashMap<Integer, Integer>> itemEntities = new HashMap();
    private static final ItemStack item = new ItemStack(ItemsTC.seals, 1, 1);
    ItemStack[] filter = new ItemStack[this.getFilterSize()];

    @Override
    public String getKey() {
        return "Thaumcraft:pickup";
    }

    @Override
    public void tickSeal(World world, SealEntity seal) {
        AxisAlignedBB area;
        List list;
        if (this.delay++ % 20 != 0) {
            return;
        }
        if (!itemEntities.containsKey(world.field_73011_w.func_177502_q())) {
            itemEntities.put(world.field_73011_w.func_177502_q(), new HashMap());
        }
        if ((list = world.func_72872_a(EntityItem.class, area = AxisAlignedBB.func_178781_a((double)seal.sealPos.pos.func_177958_n(), (double)seal.sealPos.pos.func_177956_o(), (double)seal.sealPos.pos.func_177952_p(), (double)(seal.sealPos.pos.func_177958_n() + 1), (double)(seal.sealPos.pos.func_177956_o() + 1), (double)(seal.sealPos.pos.func_177952_p() + 1)).func_72317_d((double)seal.getSealPos().face.func_82601_c(), (double)seal.getSealPos().face.func_96559_d(), (double)seal.getSealPos().face.func_82599_e()).func_72321_a(seal.getSealPos().face.func_82601_c() != 0 ? (double)((seal.getArea().func_177958_n() - 1) * seal.getSealPos().face.func_82601_c()) : 0.0, seal.getSealPos().face.func_96559_d() != 0 ? (double)((seal.getArea().func_177956_o() - 1) * seal.getSealPos().face.func_96559_d()) : 0.0, seal.getSealPos().face.func_82599_e() != 0 ? (double)((seal.getArea().func_177952_p() - 1) * seal.getSealPos().face.func_82599_e()) : 0.0).func_72314_b(seal.getSealPos().face.func_82601_c() == 0 ? (double)(seal.getArea().func_177958_n() - 1) : 0.0, seal.getSealPos().face.func_96559_d() == 0 ? (double)(seal.getArea().func_177956_o() - 1) : 0.0, seal.getSealPos().face.func_82599_e() == 0 ? (double)(seal.getArea().func_177952_p() - 1) : 0.0))).size() > 0) {
            for (Object e : list) {
                EntityItem ent = (EntityItem)e;
                if (ent == null || !ent.field_70122_E || ent.func_174874_s() || ent.func_92059_d() == null || this.filter[0] != null && !InventoryUtils.compareMultipleItems(ent.func_92059_d(), this.filter) || itemEntities.get(world.field_73011_w.func_177502_q()).containsValue(ent.func_145782_y())) continue;
                Task task = new Task(seal.sealPos, (Entity)ent, true);
                task.setPriority(seal.getPriority());
                itemEntities.get(world.field_73011_w.func_177502_q()).put(task.getId(), ent.func_145782_y());
                TaskHandler.addTask(world.field_73011_w.func_177502_q(), task);
            }
        }
    }

    @Override
    public boolean onTaskCompletion(World world, IGolemAPI golem, Task task) {
        EntityItem ei;
        if (!itemEntities.containsKey(world.field_73011_w.func_177502_q())) {
            itemEntities.put(world.field_73011_w.func_177502_q(), new HashMap());
        }
        if ((ei = this.getItemEntity(world, task)) != null && ei.func_92059_d() != null && (this.filter[0] == null || InventoryUtils.compareMultipleItems(ei.func_92059_d(), this.filter))) {
            ItemStack is = golem.holdItem(ei.func_92059_d());
            if (is != null && is.field_77994_a >= 0) {
                ei.func_92058_a(is);
            } else {
                ei.func_70106_y();
            }
            world.func_72956_a((Entity)golem, "random.pop", 0.125f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        task.setSuspended(true);
        itemEntities.get(world.field_73011_w.func_177502_q()).remove(task.getId());
        return true;
    }

    private EntityItem getItemEntity(World world, Task task) {
        Entity ent;
        Integer ei = itemEntities.get(world.field_73011_w.func_177502_q()).get(task.getId());
        if (ei != null && (ent = world.func_73045_a(ei.intValue())) != null && ent instanceof EntityItem) {
            return (EntityItem)ent;
        }
        return null;
    }

    @Override
    public boolean canGolemPerformTask(IGolemAPI golem, Task task) {
        EntityItem ei = this.getItemEntity(golem.getGolemWorld(), task);
        if (ei != null && ei.func_92059_d() != null) {
            return golem.canCarry(ei.func_92059_d(), true);
        }
        return false;
    }

    @Override
    public void onTaskSuspension(World world, Task task) {
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.filter = new ItemStack[this.getFilterSize()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.filter.length) continue;
            this.filter[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.filter.length; ++i) {
            if (this.filter[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.filter[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    public boolean canPlaceAt(World world, BlockPos pos, EnumFacing side) {
        return !world.func_175623_d(pos);
    }

    @Override
    public ItemStack getSealItem() {
        return item;
    }

    @Override
    public void onRemoval(World world, BlockPos pos, EnumFacing side) {
    }

    @Override
    public Object returnContainer(World world, EntityPlayer player, BlockPos pos, EnumFacing side, SealEntity seal) {
        return new SealBaseContainer(player.field_71071_by, world, seal);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object returnGui(World world, EntityPlayer player, BlockPos pos, EnumFacing side, SealEntity seal) {
        return new SealBaseGUI(player.field_71071_by, world, seal);
    }

    @Override
    public int[] getGuiCategories() {
        return new int[]{1, 0, 2};
    }

    @Override
    public int getFilterSize() {
        return 1;
    }

    @Override
    public ItemStack[] getInv() {
        return this.filter;
    }

    @Override
    public ItemStack getFilterSlot(int i) {
        return this.filter[i];
    }

    @Override
    public void setFilterSlot(int i, ItemStack stack) {
        this.filter[i] = stack.func_77946_l();
    }
}

