/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.tasks;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import thaumcraft.common.entities.construct.golem.EntityThaumcraftGolem;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.construct.golem.seals.SealPos;

public class Task {
    private UUID golemUUID;
    private int id;
    private byte type;
    private SealPos sealPos;
    private BlockPos pos;
    private Entity entity;
    private boolean reserved;
    private boolean waitOnSuspension;
    private boolean suspended;
    private boolean completed;
    private short lifespan;
    private byte priority = 0;

    private Task() {
    }

    public Task(SealPos sealPos, BlockPos pos, boolean wait) {
        this.sealPos = sealPos;
        this.pos = pos;
        this.id = (System.currentTimeMillis() + "/B/" + wait + "/" + sealPos.face.toString() + "/" + sealPos.pos.toString() + "/" + pos.toString()).hashCode();
        this.type = 0;
        this.waitOnSuspension = wait;
        this.lifespan = (short)120;
    }

    public Task(SealPos sealPos, Entity entity, boolean wait) {
        this.sealPos = sealPos;
        this.entity = entity;
        this.id = (System.currentTimeMillis() + "/E/" + wait + "/" + sealPos.face.toString() + "/" + sealPos.pos.toString() + "/" + entity.func_145782_y()).hashCode();
        this.type = 1;
        this.waitOnSuspension = wait;
        this.lifespan = (short)120;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompletion(boolean fulfilled) {
        this.completed = fulfilled;
        this.lifespan = (short)(this.lifespan + 60);
    }

    public boolean waitOnSuspension() {
        return this.waitOnSuspension;
    }

    public UUID getGolemUUID() {
        return this.golemUUID;
    }

    public void setGolemUUID(UUID golemUUID) {
        this.golemUUID = golemUUID;
    }

    public BlockPos getPos() {
        return this.type == 1 ? this.entity.func_180425_c() : this.pos;
    }

    public byte getType() {
        return this.type;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public int getId() {
        return this.id;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    public void setReserved(boolean res) {
        this.reserved = res;
        this.lifespan = (short)(this.lifespan + 60);
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public SealPos getSealPos() {
        return this.sealPos;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Task)) {
            return false;
        }
        Task t = (Task)o;
        return t.id == this.id;
    }

    public long getLifespan() {
        return this.lifespan;
    }

    public void setLifespan(short ls) {
        this.lifespan = ls;
    }

    public boolean canGolemPerformTask(EntityThaumcraftGolem golem) {
        SealEntity se = SealHandler.getSealEntity(golem.field_70170_p.field_73011_w.func_177502_q(), this.sealPos);
        if (se != null) {
            return se.getSeal().canGolemPerformTask(golem, this);
        }
        return false;
    }
}

