/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster.boss;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.world.BlockLoot;
import thaumcraft.common.entities.ai.combat.AIAttackOnCollide;
import thaumcraft.common.entities.ai.combat.AILongRangeAttack;
import thaumcraft.common.entities.monster.boss.EntityThaumcraftBoss;
import thaumcraft.common.entities.monster.mods.ChampionModifier;
import thaumcraft.common.entities.projectile.EntityGolemOrb;
import thaumcraft.common.lib.utils.EntityUtils;

public class EntityEldritchGolem
extends EntityThaumcraftBoss
implements IEldritchMob,
IRangedAttackMob {
    int beamCharge = 0;
    boolean chargingBeam = false;
    int arcing = 0;
    int ax = 0;
    int ay = 0;
    int az = 0;
    private int attackTimer;

    public EntityEldritchGolem(World p_i1745_1_) {
        super(p_i1745_1_);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.1, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.func_70105_a(1.75f, 3.5f);
        this.field_70178_ae = true;
    }

    @Override
    public void generateName() {
        int t = (int)this.func_110148_a(EntityUtils.CHAMPION_MOD).func_111126_e();
        if (t >= 0) {
            this.func_96094_a(String.format(StatCollector.func_74838_a((String)"entity.Thaumcraft.EldritchGolem.name.custom"), ChampionModifier.mods[t].getModNameLocalized()));
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)0);
    }

    public boolean isHeadless() {
        return this.func_70096_w().func_75683_a(12) == 1;
    }

    public void setHeadless(boolean par1) {
        this.field_70180_af.func_75692_b(12, (Object)(par1 ? (byte)1 : 0));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("headless", this.isHeadless());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setHeadless(nbt.func_74767_n("headless"));
        if (this.isHeadless()) {
            this.makeHeadless();
        }
    }

    public float func_70047_e() {
        return this.isHeadless() ? 3.33f : 3.0f;
    }

    public int func_70658_aO() {
        return super.func_70658_aO() + 6;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0);
    }

    protected String func_70621_aR() {
        return "mob.irongolem.hit";
    }

    protected String func_70673_aS() {
        return "mob.irongolem.death";
    }

    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
        this.func_85030_a("mob.irongolem.walk", 1.0f, 1.0f);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance diff, IEntityLivingData data) {
        this.spawnTimer = 100;
        return super.func_180482_a(diff, data);
    }

    public void func_70636_d() {
        float h;
        IBlockState bs;
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0) {
            bs = this.field_70170_p.func_180495_p(this.func_180425_c());
            if (bs.func_177230_c().func_149688_o() != Material.field_151579_a) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)bs)});
            }
            if (!this.field_70170_p.field_72995_K && bs.func_177230_c() instanceof BlockLoot) {
                this.field_70170_p.func_175655_b(this.func_180425_c(), true);
            }
        }
        if (!this.field_70170_p.field_72995_K && (h = (bs = this.field_70170_p.func_180495_p(this.func_180425_c())).func_177230_c().func_176195_g(this.field_70170_p, this.func_180425_c())) >= 0.0f && h <= 0.15f) {
            this.field_70170_p.func_175655_b(this.func_180425_c(), true);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (!this.field_70170_p.field_72995_K && damage > this.func_110143_aJ() && !this.isHeadless()) {
            this.setHeadless(true);
            this.spawnTimer = 100;
            double xx = MathHelper.func_76134_b((float)(this.field_70177_z % 360.0f / 180.0f * (float)Math.PI)) * 0.75f;
            double zz = MathHelper.func_76126_a((float)(this.field_70177_z % 360.0f / 180.0f * (float)Math.PI)) * 0.75f;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t + xx, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v + zz, 2.0f, false);
            this.makeHeadless();
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    void makeHeadless() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AILongRangeAttack(this, 3.0, 1.0, 5, 5, 24.0f));
    }

    public boolean func_70652_k(Entity target) {
        if (this.attackTimer > 0) {
            return false;
        }
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 0.75f);
        if (flag) {
            target.field_70181_x += 0.2000000059604645;
            if (this.isHeadless()) {
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * 1.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * 1.5f));
            }
        }
        return flag;
    }

    public void func_82196_d(EntityLivingBase entitylivingbase, float f) {
        if (this.func_70685_l((Entity)entitylivingbase) && !this.chargingBeam && this.beamCharge > 0) {
            this.beamCharge -= 15 + this.field_70146_Z.nextInt(5);
            this.func_70671_ap().func_75650_a(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f), entitylivingbase.field_70161_v, 30.0f, 30.0f);
            Vec3 v = this.func_70676_i(1.0f);
            EntityGolemOrb blast = new EntityGolemOrb(this.field_70170_p, (EntityLivingBase)this, entitylivingbase, false);
            blast.field_70165_t += v.field_72450_a;
            blast.field_70161_v += v.field_72449_c;
            blast.func_70107_b(blast.field_70165_t, blast.field_70163_u, blast.field_70161_v);
            double d0 = entitylivingbase.field_70165_t + entitylivingbase.field_70159_w - this.field_70165_t;
            double d1 = entitylivingbase.field_70163_u - this.field_70163_u - (double)(entitylivingbase.field_70131_O / 2.0f);
            double d2 = entitylivingbase.field_70161_v + entitylivingbase.field_70179_y - this.field_70161_v;
            blast.func_70186_c(d0, d1, d2, 0.66f, 5.0f);
            this.func_85030_a("thaumcraft:egattack", 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.1f);
            this.field_70170_p.func_72838_d((Entity)blast);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 4) {
            this.attackTimer = 10;
            this.func_85030_a("mob.irongolem.throw", 1.0f, 1.0f);
        } else if (p_70103_1_ == 18) {
            this.spawnTimer = 150;
        } else if (p_70103_1_ == 19) {
            if (this.arcing == 0) {
                float radius = 2.0f + this.field_70146_Z.nextFloat() * 2.0f;
                double radians = Math.toRadians(this.field_70146_Z.nextInt(360));
                double deltaX = (double)radius * Math.cos(radians);
                double deltaZ = (double)radius * Math.sin(radians);
                int bx = MathHelper.func_76128_c((double)(this.field_70165_t + deltaX));
                int by = MathHelper.func_76128_c((double)this.field_70163_u);
                int bz = MathHelper.func_76128_c((double)(this.field_70161_v + deltaZ));
                BlockPos bp = new BlockPos(bx, by, bz);
                int c = 0;
                while (c < 5 && this.field_70170_p.func_175623_d(bp)) {
                    ++c;
                    --by;
                }
                if (this.field_70170_p.func_175623_d(bp.func_177984_a()) && !this.field_70170_p.func_175623_d(bp)) {
                    this.ax = bx;
                    this.ay = by;
                    this.az = bz;
                    this.arcing = 8 + this.field_70146_Z.nextInt(5);
                    this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "thaumcraft:jacobs", 0.8f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.05f, false);
                }
            }
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.getSpawnTimer() == 150) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)18);
        }
        if (this.getSpawnTimer() > 0) {
            this.func_70691_i(2.0f);
        }
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.isHeadless()) {
                this.field_70125_A = 0.0f;
                float f1 = MathHelper.func_76134_b((float)(-this.field_70761_aq * ((float)Math.PI / 180) - (float)Math.PI));
                float f2 = MathHelper.func_76126_a((float)(-this.field_70761_aq * ((float)Math.PI / 180) - (float)Math.PI));
                float f3 = -MathHelper.func_76134_b((float)(-this.field_70125_A * ((float)Math.PI / 180)));
                float f4 = MathHelper.func_76126_a((float)(-this.field_70125_A * ((float)Math.PI / 180)));
                Vec3 v = new Vec3((double)(f2 * f3), (double)f4, (double)(f1 * f3));
                if (this.field_70146_Z.nextInt(20) == 0) {
                    float a = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) / 2.0f;
                    float b = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) / 2.0f;
                    Thaumcraft.proxy.getFX().spark((float)(this.field_70165_t + v.field_72450_a + (double)a), (float)this.field_70163_u + this.func_70047_e() - 0.25f, (float)(this.field_70161_v + v.field_72449_c + (double)b), 0.3f, 0.65f + this.field_70146_Z.nextFloat() * 0.1f, 1.0f, 1.0f, 0.8f);
                }
                Thaumcraft.proxy.getFX().drawVentParticles((double)((float)this.field_70165_t) + v.field_72450_a * 0.66, (float)this.field_70163_u + this.func_70047_e() - 0.75f, (double)((float)this.field_70161_v) + v.field_72449_c * 0.66, 0.0, 0.001, 0.0, 0x555555, 4.0f);
                if (this.arcing > 0) {
                    Thaumcraft.proxy.getFX().arcLightning(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, (double)this.ax + 0.5, this.ay + 1, (double)this.az + 0.5, 0.65f + this.field_70146_Z.nextFloat() * 0.1f, 1.0f, 1.0f, 1.0f - (float)this.arcing / 10.0f);
                    --this.arcing;
                }
            }
        } else {
            if (this.isHeadless() && this.beamCharge <= 0) {
                this.chargingBeam = true;
            }
            if (this.isHeadless() && this.chargingBeam) {
                ++this.beamCharge;
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
                if (this.beamCharge == 150) {
                    this.chargingBeam = false;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }
}

