/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.tiles.misc.TileHole;

public class ItemFocusPortableHole
extends ItemFocusBasic {
    private static final AspectList cost = new AspectList().add(Aspect.ENTROPY, 25).add(Aspect.AIR, 25).add(Aspect.EARTH, 25);

    public ItemFocusPortableHole() {
        super("hole", 594985);
    }

    @Override
    public AspectList getVisCost(ItemStack itemstack) {
        return cost;
    }

    public static boolean createHole(World world, BlockPos pos, EnumFacing side, byte count, int max) {
        IBlockState bs = world.func_180495_p(pos);
        if (!(world.field_72995_K || world.func_175625_s(pos) != null || BlockUtils.isPortableHoleBlackListed(bs) || bs.func_177230_c() == Blocks.field_150357_h || bs.func_177230_c() == BlocksTC.hole || !bs.func_177230_c().isAir((IBlockAccess)world, pos) && bs.func_177230_c().func_176196_c(world, pos) || bs.func_177230_c().func_176195_g(world, pos) == -1.0f)) {
            if (world.func_175656_a(pos, BlocksTC.hole.func_176223_P())) {
                TileHole ts = (TileHole)world.func_175625_s(pos);
                ts.oldblock = bs;
                ts.countdownmax = (short)max;
                ts.count = count;
                ts.direction = side;
                ts.func_70296_d();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onFocusActivation(ItemStack itemstack, World world, EntityLivingBase player, MovingObjectPosition mop, int count) {
        IWand wand = (IWand)itemstack.func_77973_b();
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            IBlockState bi;
            if (world.field_73011_w.func_177502_q() == Config.dimensionOuterId) {
                if (!world.field_72995_K) {
                    world.func_72908_a((double)mop.func_178782_a().func_177958_n() + 0.5, (double)mop.func_178782_a().func_177956_o() + 0.5, (double)mop.func_178782_a().func_177952_p() + 0.5, "thaumcraft:wandfail", 1.0f, 1.0f);
                }
                player.func_71038_i();
                return false;
            }
            int enlarge = wand.getFocusEnlarge(itemstack);
            int distance = 0;
            int maxdis = 33 + enlarge * 8;
            BlockPos pos = new BlockPos((Vec3i)mop.func_178782_a());
            for (distance = 0; distance < maxdis && !BlockUtils.isPortableHoleBlackListed(bi = world.func_180495_p(pos)) && bi.func_177230_c() != Blocks.field_150357_h && bi.func_177230_c() != BlocksTC.hole && !bi.func_177230_c().isAir((IBlockAccess)world, pos) && bi.func_177230_c().func_176195_g(world, pos) != -1.0f; ++distance) {
                pos = pos.func_177972_a(mop.field_178784_b.func_176734_d());
            }
            int di = this.getUpgradeLevel(wand.getFocusStack(itemstack), FocusUpgradeType.extend);
            short dur = (short)(120 + 60 * di);
            ItemFocusPortableHole.createHole(world, mop.func_178782_a(), mop.field_178784_b, (byte)(distance + 1), dur);
            player.func_71038_i();
            if (!world.field_72995_K) {
                world.func_72908_a((double)mop.func_178782_a().func_177958_n() + 0.5, (double)mop.func_178782_a().func_177956_o() + 0.5, (double)mop.func_178782_a().func_177952_p() + 0.5, "mob.endermen.portal", 1.0f, 1.0f);
            }
        }
        return true;
    }

    @Override
    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.extend};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.extend};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.extend};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.extend};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.extend};
            }
        }
        return null;
    }
}

