/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.entities.projectile.EntityHomingShard;
import thaumcraft.common.lib.utils.EntityUtils;

public class ItemFocusShard
extends ItemFocusBasic {
    private static final AspectList cost = new AspectList().add(Aspect.FIRE, 1).add(Aspect.ENTROPY, 1).add(Aspect.AIR, 1);
    private static final AspectList costP = new AspectList().add(Aspect.FIRE, 1).add(Aspect.ENTROPY, 1).add(Aspect.WATER, 1).add(Aspect.AIR, 1);
    public static FocusUpgradeType persistant = new FocusUpgradeType(new ResourceLocation("thaumcraft", "textures/foci/persistant.png"), "focus.upgrade.persistant.name", "focus.upgrade.persistant.text", new AspectList().add(Aspect.PROTECT, 1).add(Aspect.AVERSION, 1).add(Aspect.ENERGY, 1));

    public ItemFocusShard() {
        super("shard", 10037693);
    }

    @Override
    public boolean canBePlacedInTurret() {
        return true;
    }

    @Override
    public int getActivationCooldown(ItemStack focusstack) {
        return 300;
    }

    @Override
    public boolean onFocusActivation(ItemStack itemstack, World world, EntityLivingBase p, MovingObjectPosition movingobjectposition, int count) {
        IWand wand = (IWand)itemstack.func_77973_b();
        Entity pointedEntity = EntityUtils.getPointedEntity(p.field_70170_p, (Entity)p, 0.0, 32.0, 1.1f);
        if (pointedEntity != null && pointedEntity instanceof EntityLivingBase) {
            if (!world.field_72995_K) {
                EntityHomingShard blast = new EntityHomingShard(world, p, (EntityLivingBase)pointedEntity, wand.getFocusPotency(itemstack), this.isUpgradedWith(wand.getFocusStack(itemstack), persistant));
                world.func_72838_d((Entity)blast);
                world.func_72956_a((Entity)blast, "thaumcraft:scan", 0.3f, 1.1f + world.field_73012_v.nextFloat() * 0.1f);
            }
            p.func_71038_i();
            return true;
        }
        return false;
    }

    @Override
    public AspectList getVisCost(ItemStack itemstack) {
        return this.isUpgradedWith(itemstack, persistant) ? costP : cost;
    }

    @Override
    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, persistant};
            }
        }
        return null;
    }
}

